/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.rtp.core;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.modules.rtp.data.RTPConfig;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class Locator {
    public static final class_3230<class_2338> RTP_TICKET = class_3230.method_20628((String)"rtp", Comparator.comparingLong(class_1923::method_37232), (int)300);
    public final class_3222 player;
    public final class_3218 world;
    public final RTPConfig config;
    @Nullable
    public final class_5321<class_1959> biome;
    private Consumer<Result> callback;
    private final Stopwatch stopwatch = Stopwatch.createUnstarted();
    private class_2791 chunk;
    private class_2338 attemptPos;
    private boolean failed = false;
    private int remainingAttempts = 0;
    private static final ImmutableList<class_2248> unsafeBlocks = ImmutableList.of((Object)class_2246.field_10164, (Object)class_2246.field_10092, (Object)class_2246.field_10029, (Object)class_2246.field_10036, (Object)class_2246.field_17350, (Object)class_2246.field_27098, (Object)class_2246.field_16999, (Object)class_2246.field_27879);
    private static final ImmutableList<class_2248> nonIdealBlocks = ImmutableList.of((Object)class_2246.field_10382);

    public Locator(class_3222 player, class_3218 world, RTPConfig config) {
        this(player, world, config, null);
    }

    public Locator(class_3222 player, class_3218 world, RTPConfig config, @Nullable class_5321<class_1959> biome) {
        this.player = player;
        this.world = world;
        this.config = config;
        this.biome = biome;
        this.remainingAttempts = config.attempts;
    }

    public void locate(Consumer<Result> callback) {
        this.callback = callback;
        this.stopwatch.start();
        this.attempt();
    }

    private void attempt() {
        int i = this.config.attempts;
        while (i >= 0) {
            this.remainingAttempts = i--;
            class_2338 pos = this.getRandomPos();
            if (!this.isValid(pos)) continue;
            Solstice.LOGGER.info("RTP spot found at attempt {} for {}", (Object)(this.config.attempts - this.remainingAttempts), (Object)this.player.method_5477());
            this.attemptPos = pos;
            this.load();
            return;
        }
        this.failed = true;
        this.callback.accept(new Result(Result.Type.TOO_MANY_ATTEMPTS, Optional.empty()));
    }

    public boolean tick() {
        if (this.failed) {
            return true;
        }
        if (this.stopwatch.elapsed(TimeUnit.MILLISECONDS) >= (long)this.config.timeout) {
            this.callback.accept(new Result(Result.Type.TIMEOUT, Optional.empty()));
            return true;
        }
        if (this.attemptPos == null) {
            return false;
        }
        Optional<class_2818> chunk = this.getChunk(new class_1923(this.attemptPos));
        if (chunk.isPresent()) {
            this.chunk = (class_2791)chunk.get();
            this.findValidPlacement();
            return true;
        }
        return false;
    }

    private class_2338 getTopBlock(class_2338 pos) {
        return this.world.method_8598(class_2902.class_2903.field_13203, pos);
    }

    private class_2338 getEmptySpace(class_2338 pos) {
        int bottom = this.chunk.method_31607();
        int top = this.world.method_32819();
        class_2338.class_2339 blockPos = new class_2338.class_2339(pos.method_10263(), top, pos.method_10260());
        boolean isAir = false;
        boolean isAirBelow = false;
        while (blockPos.method_10264() >= bottom && isAirBelow || !isAir) {
            isAir = isAirBelow;
            isAirBelow = this.chunk.method_8320((class_2338)blockPos.method_10098(class_2350.field_11033)).method_26215();
        }
        return blockPos.method_10084().method_10062();
    }

    private void findValidPlacement() {
        class_2338 pos = this.attemptPos;
        for (int i = 0; i <= 256; ++i) {
            pos = this.world.method_8597().comp_643() ? this.getEmptySpace(pos) : this.getTopBlock(pos);
            class_2680 bs = this.chunk.method_8320(pos);
            class_2680 bsBelow = this.chunk.method_8320(pos.method_10074());
            if (!unsafeBlocks.contains((Object)bs.method_26204()) && !unsafeBlocks.contains((Object)bsBelow.method_26204())) break;
            int dx = i % 16;
            int dz = i / 16;
            pos = this.chunk.method_12004().method_35231(dx, this.chunk.method_31607(), dz);
        }
        if (pos.method_10264() <= this.chunk.method_31607()) {
            this.callback.accept(new Result(Result.Type.UNSAFE, Optional.empty()));
            return;
        }
        class_243 vec = pos.method_46558();
        this.callback.accept(new Result(Result.Type.SUCCESS, Optional.of(new ServerLocation(vec.method_10216(), vec.method_10214(), vec.method_10215(), 0.0f, 0.0f, this.world))));
    }

    private void load() {
        this.world.method_14178().method_17297(RTP_TICKET, new class_1923(this.attemptPos), 0, (Object)this.attemptPos);
    }

    private Optional<class_2818> getChunk(class_1923 pos) {
        class_3193 holder = this.world.method_14178().method_14131(pos.method_8324());
        if (holder == null) {
            return Optional.empty();
        }
        class_2818 chunk = (class_2818)holder.method_20725().getNow(class_3193.field_16427).method_57130(null);
        if (chunk == null) {
            return Optional.empty();
        }
        return Optional.of(chunk);
    }

    public boolean isValid(class_2338 pos) {
        if (pos == null) {
            return false;
        }
        if (this.biome != null) {
            return this.isInBiome(pos, this.biome);
        }
        class_6880 biome = this.world.method_23753(pos);
        return !this.config.parseBiomes().contains(biome.method_40230().orElse(null));
    }

    public boolean isInBiome(class_2338 pos, class_5321<class_1959> biome) {
        class_6880 biomeAtPos = this.world.method_23753(pos);
        return ((class_5321)biomeAtPos.method_40230().get()).equals(biome);
    }

    public class_2338 getRandomPos() {
        double centerZ;
        double centerX;
        class_2784 worldBorder = this.world.method_8621();
        double size = worldBorder.method_11965();
        if (this.config.aroundPlayer) {
            centerX = this.player.method_23317();
            centerZ = this.player.method_23321();
        } else {
            centerX = worldBorder.method_11964();
            centerZ = worldBorder.method_11980();
        }
        int maxDiameter = this.config.maxRadius * 2;
        int minDiameter = this.config.minRadius * 2;
        int max = Math.min((int)size, maxDiameter);
        int min = Math.max(0, minDiameter);
        int x = 0;
        int z = 0;
        int limit = 256;
        for (int i = 0; i <= limit; ++i) {
            double dist = this.world.method_8409().method_43058() * (double)(max - min) + (double)min;
            double angle = this.world.method_8409().method_43058() * Math.PI * 2.0;
            x = (int)(Math.cos(angle) * dist + centerX);
            if (worldBorder.method_35317((double)x, (double)(z = (int)(Math.sin(angle) * dist + centerZ)))) break;
            if (i != limit) continue;
            return null;
        }
        return new class_2338(x, this.world.method_32819(), z);
    }

    public record Result(Type type, Optional<ServerLocation> position) {

        public static enum Type {
            SUCCESS,
            TOO_MANY_ATTEMPTS,
            TIMEOUT,
            UNSAFE;

        }
    }
}

