/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.rtp.data;

import java.util.List;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;

@ConfigSerializable
public class RTPConfig {
    @Comment(value="How many times to try to find a valid spot to teleport to before failing.")
    public int attempts = 10;
    @Comment(value="How much time in milliseconds /rtp can take at most before failing.")
    public int timeout = 10000;
    @Comment(value="Minimum radius from the center of the world border.")
    public int minRadius = 0;
    @Comment(value="Maximum radius from the center of the world border. It caps to world border size.")
    public int maxRadius = 30000;
    @Comment(value="Use player as the center of the radius instead of the world border.")
    public boolean aroundPlayer = false;
    @Comment(value="List of biomes an attempt should fail at.")
    public List<String> prohibitedBiomes = List.of("minecraft:ocean", "minecraft:cold_ocean", "minecraft:deep_cold_ocean", "minecraft:deep_frozen_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:deep_ocean", "minecraft:frozen_ocean", "minecraft:lukewarm_ocean", "minecraft:warm_ocean", "minecraft:river", "minecraft:frozen_river", "minecraft:small_end_islands");
    @Comment(value="Require that the player has the permission of the world 'solstice.rtp.worlds.<worldName>' to initiate the random teleport in the world.")
    public boolean requireWorldPermission = true;
    @Comment(value="Groups of biomes the player is allowed to RTP to.\nUse 'solstice.rtp.biomes.<world>.<groupName>' to assign.\nRequires 'solstice.rtp.biome.base'.")
    public Map<String, Map<String, List<String>>> biomeGroups = Map.of("minecraft:overworld", Map.of("forests", List.of("minecraft:forest", "minecraft:flower_forest", "minecraft:taiga", "minecraft:old_growth_spruce_taiga", "minecraft:snowy_taiga", "minecraft:birch_forest", "minecraft:old_growth_birch_forest", "minecraft:dark_forest", "minecraft:pale_garden", "minecraft:jungle", "minecraft:sparse_jungle", "minecraft:bamboo_jungle")));

    public List<class_5321<class_1959>> parseBiomes() {
        return this.prohibitedBiomes.stream().map(biomeId -> class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60654((String)biomeId))).toList();
    }
}

