/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.spawn;

import java.util.Map;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.spawn.commands.FirstSpawnCommand;
import me.alexdevs.solstice.modules.spawn.commands.SetFirstSpawnCommand;
import me.alexdevs.solstice.modules.spawn.commands.SetSpawnCommand;
import me.alexdevs.solstice.modules.spawn.commands.SpawnCommand;
import me.alexdevs.solstice.modules.spawn.data.SpawnConfig;
import me.alexdevs.solstice.modules.spawn.data.SpawnLocale;
import me.alexdevs.solstice.modules.spawn.data.SpawnServerData;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class SpawnModule
extends ModuleBase.Toggleable {
    public SpawnModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        this.registerLocale(SpawnLocale.MODULE);
        this.registerServerData(SpawnServerData.class, SpawnServerData::new);
        this.registerConfig(SpawnConfig.class, SpawnConfig::new);
        this.commands.add(new SpawnCommand(this));
        this.commands.add(new SetSpawnCommand(this));
        this.commands.add(new FirstSpawnCommand(this));
        this.commands.add(new SetFirstSpawnCommand(this));
        SolsticeEvents.WELCOME.register((player, server) -> {
            ServerLocation firstSpawn = this.getFirstSpawn();
            if (firstSpawn == null) {
                firstSpawn = this.getGlobalSpawnPosition();
            }
            ServerLocation finalSpawn = firstSpawn;
            Solstice.nextTick(() -> Solstice.nextTick(() -> finalSpawn.teleport(player)));
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            SpawnConfig config = this.getConfig();
            if (config.globalSpawn.onLogin) {
                Solstice.nextTick(() -> this.getGlobalSpawnPosition().teleport(handler.method_32311(), false));
            }
        });
        SolsticeEvents.READY.register((instance, server) -> {
            SpawnServerData spawnData = this.getServerData();
            if (spawnData.spawn != null) {
                ServerLocation legacy = spawnData.spawn;
                class_3218 world = legacy.getWorld(server);
                world.method_8554(new class_2338((int)legacy.getX(), (int)legacy.getY(), (int)legacy.getZ()), legacy.getYaw());
                spawnData.spawn = null;
            }
        });
    }

    @Deprecated
    public ServerLocation getSpawn() {
        SpawnServerData serverData = this.getServerData();
        ServerLocation spawnPosition = serverData.spawn;
        if (spawnPosition == null) {
            MinecraftServer server = Solstice.server;
            class_2338 spawnPos = server.method_30002().method_43126();
            spawnPosition = new ServerLocation((double)spawnPos.method_10263(), (double)spawnPos.method_10264(), (double)spawnPos.method_10260(), 0.0f, 0.0f, server.method_30002());
        }
        return spawnPosition;
    }

    public class_3218 getGlobalSpawnWorld() {
        String targetWorld = this.getConfig().globalSpawn.targetSpawnWorld;
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)targetWorld));
        return Solstice.server.method_3847(key);
    }

    public ServerLocation getGlobalSpawnPosition() {
        return this.getWorldSpawn(this.getGlobalSpawnWorld());
    }

    public ServerLocation getWorldSpawn(class_3218 world) {
        Map<String, ServerLocation> spawnPoints;
        class_243 worldSpawnPosition = world.method_43126().method_46558();
        float worldSpawnYaw = world.method_43127();
        String worldName = world.method_27983().method_29177().toString();
        if (world.method_27983() != class_1937.field_25179 && (spawnPoints = this.getServerData().spawnPoints).containsKey(worldName)) {
            return spawnPoints.get(worldName);
        }
        return new ServerLocation(worldSpawnPosition.method_10216(), worldSpawnPosition.method_10214(), worldSpawnPosition.method_10215(), worldSpawnYaw, 0.0f, world);
    }

    public SpawnConfig getConfig() {
        return Solstice.configManager.getData(SpawnConfig.class);
    }

    public SpawnServerData getServerData() {
        return Solstice.serverData.getData(SpawnServerData.class);
    }

    public void sendToSpawn(class_3222 player) {
        this.sendToSpawn(player, player.method_51469());
    }

    public void sendToSpawn(class_3222 player, class_3218 world) {
        ServerLocation pos = this.getWorldSpawn(world);
        pos.teleport(player);
    }

    @Nullable
    public ServerLocation getFirstSpawn() {
        return Solstice.serverData.getData(SpawnServerData.class).firstSpawn;
    }
}

