/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.styling.data;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;

@ConfigSerializable
public class StylingConfig {
    @Comment(value="Enable Markdown support in chat.")
    public boolean enableMarkdown = true;
    @Comment(value="Whether to broadcast a welcome message to everyone when a player joins for the first time.")
    public boolean welcomeNewPlayers = true;
    @Comment(value="Replace text chunks in chat messages.")
    public HashMap<String, String> replacements = new HashMap<String, String>(Map.of(":shrug:", "\u00af\\\\_(\u30c4)_/\u00af"));
    @Comment(value="Task advancement format.")
    public String advancementTask = "<green>\u2714</green> %player:displayname% <gray>completed the task</gray> <hover:'${description}'><green>${title}</green></hover>";
    @Comment(value="Challenge advancement format.")
    public String advancementChallenge = "<light_purple>\ud83c\udf86</light_purple> %player:displayname% <gray>completed the challenge</gray> <hover:'${description}'><light_purple>${title}</light_purple></hover>";
    @Comment(value="Goal advancement format.")
    public String advancementGoal = "<aqua>\ud83c\udf96</aqua> %player:displayname% <gray>completed the goal</gray> <hover:'${description}'><aqua>${title}</aqua></hover>";
    @Comment(value="!! This setting is deprecated. Use chat-formats instead. !!")
    @Deprecated
    @Nullable
    public String chatFormat = null;
    @Comment(value="Chat format per group. group = format")
    public Map<String, String> chatFormats = Map.of("default", "%player:displayname%<gray>:</gray> ${message}");
    @Comment(value="Emote format (/me)")
    public String emoteFormat = "<gray>\ud83d\udc64 %player:displayname% <i>${message}</i></gray>";
    @Comment(value="Player join format")
    public String joinFormat = "<green>+</green> %player:displayname% <yellow>joined!</yellow>";
    @Comment(value="Player joined with a new username format")
    public String joinRenamedFormat = "<green>+</green> %player:displayname% <yellow>joined! <i>(Previously known as ${previousName})</i></yellow>";
    @Comment(value="Player quit format")
    public String leaveFormat = "<red>-</red> %player:displayname% <yellow>left!</yellow>";
    @Comment(value="Player death format")
    public String deathFormat = "<gray>\u2620 ${message}</gray>";
    @Comment(value="New player welcome message format")
    public String welcome = "<light_purple>Welcome %player:displayname% to the server!</light_purple>";
}

