/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.tablist;

import eu.pb4.placeholders.api.PlaceholderContext;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.api.text.RawPlaceholder;
import me.alexdevs.solstice.modules.tablist.data.TabListConfig;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2596;
import net.minecraft.class_2772;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class TabListModule
extends ModuleBase.Toggleable {
    private MinecraftServer server;
    private ScheduledFuture<?> scheduledFuture = null;

    public TabListModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        this.registerConfig(TabListConfig.class, TabListConfig::new);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.server = server;
            this.schedule();
        });
        SolsticeEvents.RELOAD.register(instance -> {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
            this.schedule();
        });
    }

    public TabListConfig getConfig() {
        return Solstice.configManager.getData(TabListConfig.class);
    }

    private void schedule() {
        if (!this.isEnabled()) {
            return;
        }
        TabListConfig config = this.getConfig();
        if (!config.enable) {
            return;
        }
        this.scheduledFuture = Solstice.scheduler.scheduleAtFixedRate(this::updateTab, 0L, config.delay, TimeUnit.MILLISECONDS);
    }

    public void updateTab() {
        if (!this.isEnabled()) {
            return;
        }
        TabListConfig config = this.getConfig();
        double period = Math.max(config.phasePeriod, 1.0);
        float phase = (float)(Math.sin((double)this.server.method_3780() * Math.PI * 2.0 / period) + 1.0) / 2.0f;
        Map<String, String> placeholders = Map.of("phase", String.valueOf(phase));
        this.server.method_3760().method_14571().forEach(player -> {
            PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
            String header = RawPlaceholder.parse(String.join((CharSequence)"\n", config.header), placeholders);
            String footer = RawPlaceholder.parse(String.join((CharSequence)"\n", config.footer), placeholders);
            player.field_13987.method_14364((class_2596)new class_2772(Format.parse(header, playerContext), Format.parse(footer, playerContext)));
        });
    }
}

