/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.timeBar;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.events.TimeBarEvents;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.timeBar.TimeBar;
import me.alexdevs.solstice.modules.timeBar.commands.TimeBarCommand;
import net.minecraft.class_1259;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class TimeBarModule
extends ModuleBase.Toggleable {
    private static final ConcurrentLinkedDeque<TimeBar> timeBars = new ConcurrentLinkedDeque();

    public TimeBarModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        this.commands.add(new TimeBarCommand(this));
        Solstice.scheduler.scheduleAtFixedRate(this::updateBars, 0L, 1L, TimeUnit.SECONDS);
    }

    public void updateBars() {
        for (TimeBar timeBar : timeBars) {
            boolean remove = timeBar.elapse();
            ((TimeBarEvents.Progress)TimeBarEvents.PROGRESS.invoker()).onProgress(timeBar, Solstice.server);
            List players = Solstice.server.method_3760().method_14571();
            this.showBar(players, timeBar);
            if (!remove) continue;
            timeBars.remove(timeBar);
            ((TimeBarEvents.End)TimeBarEvents.END.invoker()).onEnd(timeBar, Solstice.server);
            this.hideBar(players, timeBar);
        }
    }

    private void showBar(Collection<class_3222> players, TimeBar timeBar) {
        try {
            timeBar.getBossBar().method_12962(players);
        }
        catch (Exception e) {
            Solstice.LOGGER.error("Error while showing boss bar to players", (Throwable)e);
        }
    }

    private void hideBar(Collection<class_3222> players, TimeBar timeBar) {
        players.forEach(player -> {
            try {
                timeBar.getBossBar().method_14089(player);
            }
            catch (Exception e) {
                Solstice.LOGGER.error("Error while hiding boss bar from players", (Throwable)e);
            }
        });
    }

    public TimeBar startTimeBar(String label, int seconds, class_1259.class_1260 color, class_1259.class_1261 style, boolean countdown) {
        TimeBar timeBar = new TimeBar(label, seconds, countdown, color, style);
        Solstice.scheduler.schedule(() -> {
            timeBars.add(timeBar);
            List players = Solstice.server.method_3760().method_14571();
            this.showBar(players, timeBar);
            ((TimeBarEvents.Start)TimeBarEvents.START.invoker()).onStart(timeBar, Solstice.server);
            ((TimeBarEvents.Progress)TimeBarEvents.PROGRESS.invoker()).onProgress(timeBar, Solstice.server);
        }, 0L, TimeUnit.SECONDS);
        return timeBar;
    }

    public boolean cancelTimeBar(TimeBar timeBar) {
        boolean success = timeBars.remove(timeBar);
        if (success) {
            List players = Solstice.server.method_3760().method_14571();
            this.hideBar(players, timeBar);
            ((TimeBarEvents.Cancel)TimeBarEvents.CANCEL.invoker()).onCancel(timeBar, Solstice.server);
        }
        return success;
    }

    public boolean cancelTimeBar(UUID uuid) {
        TimeBar progressBar = timeBars.stream().filter(p -> p.getUuid().equals(uuid)).findFirst().orElse(null);
        if (progressBar == null) {
            return false;
        }
        return this.cancelTimeBar(progressBar);
    }
}

