/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.timeBar.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.events.TimeBarEvents;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.timeBar.TimeBar;
import me.alexdevs.solstice.modules.timeBar.TimeBarModule;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5242;

public class TimeBarCommand
extends ModCommand<TimeBarModule> {
    private static final ConcurrentHashMap<UUID, BarCommand> runningBars = new ConcurrentHashMap();

    public TimeBarCommand(TimeBarModule module) {
        super(module);
        TimeBarEvents.END.register((timeBar, server) -> {
            if (runningBars.containsKey(timeBar.getUuid())) {
                BarCommand barCommand = runningBars.get(timeBar.getUuid());
                String command = barCommand.command();
                class_2168 source = barCommand.source();
                runningBars.remove(timeBar.getUuid());
                Solstice.nextTick(() -> {
                    try {
                        this.dispatcher.execute(command, (Object)source);
                    }
                    catch (CommandSyntaxException e) {
                        source.method_9226(() -> class_2561.method_43470((String)e.toString()).method_27692(class_124.field_1061), false);
                    }
                });
            }
        });
    }

    @Override
    public List<String> getNames() {
        return List.of("timebar");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(3))).then(class_2170.method_9247((String)"start").then(class_2170.method_9244((String)"duration", (ArgumentType)StringArgumentType.word()).suggests(TimeSpan::suggest).then(class_2170.method_9244((String)"color", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            List<String> colors = Arrays.stream(class_1259.class_1260.values()).map(Enum::toString).toList();
            return class_2172.method_9265(colors, (SuggestionsBuilder)builder);
        }).then(class_2170.method_9244((String)"style", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            List<String> styles = Arrays.stream(class_1259.class_1261.values()).map(Enum::toString).toList();
            return class_2172.method_9265(styles, (SuggestionsBuilder)builder);
        }).then(class_2170.method_9244((String)"countdown", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"label", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> this.dispatcher.getRoot().listSuggestions(context, builder)).executes(this::execute))))))))).then(class_2170.method_9247((String)"cancel").then(class_2170.method_9244((String)"uuid", (ArgumentType)class_5242.method_27643()).executes(this::executeCancel)));
    }

    private int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        int seconds = TimeSpan.getTimeSpan(context, "duration");
        String colorName = StringArgumentType.getString(context, (String)"color");
        String styleName = StringArgumentType.getString(context, (String)"style");
        boolean countdown = BoolArgumentType.getBool(context, (String)"countdown");
        String label = StringArgumentType.getString(context, (String)"label");
        String command = StringArgumentType.getString(context, (String)"command");
        class_1259.class_1260 color = class_1259.class_1260.valueOf((String)colorName);
        class_1259.class_1261 style = class_1259.class_1261.valueOf((String)styleName);
        TimeBar bar = ((TimeBarModule)this.module).startTimeBar(label, seconds, color, style, countdown);
        runningBars.put(bar.getUuid(), new BarCommand((class_2168)context.getSource(), command));
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"New time bar created with UUID ").method_10852((class_2561)class_2561.method_43470((String)bar.getUuid().toString()).method_10862(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_30163((String)"Click to copy"))).method_10958(new class_2558(class_2558.class_2559.field_21462, bar.getUuid().toString())))), true);
        return 1;
    }

    private int executeCancel(CommandContext<class_2168> context) {
        UUID uuid = class_5242.method_27645(context, (String)"uuid");
        if (!runningBars.containsKey(uuid)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Time bar not found!").method_27692(class_124.field_1061), false);
            return 1;
        }
        runningBars.remove(uuid);
        ((TimeBarModule)this.module).cancelTimeBar(uuid);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Time bar canceled"), true);
        return 1;
    }

    private record BarCommand(class_2168 source, String command) {
    }
}

