/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.api.protocol;

import com.noxcrew.noxesium.api.protocol.ClientSettings;
import com.noxcrew.noxesium.api.protocol.NoxesiumFeature;
import com.noxcrew.noxesium.api.protocol.rule.ServerRule;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public interface NoxesiumServerManager<PlayerT> {
    @Nullable
    public <T> ServerRule<T, ?> getServerRule(PlayerT var1, int var2);

    @Nullable
    public ClientSettings getClientSettings(PlayerT var1);

    @Nullable
    public ClientSettings getClientSettings(UUID var1);

    default public boolean isUsingNoxesium(PlayerT player, NoxesiumFeature feature) {
        Integer version = this.getProtocolVersion(player);
        if (version == null) {
            return false;
        }
        return version >= feature.getMinProtocolVersion();
    }

    default public boolean isUsingNoxesium(UUID playerId, NoxesiumFeature feature) {
        Integer version = this.getProtocolVersion(playerId);
        if (version == null) {
            return false;
        }
        return version >= feature.getMinProtocolVersion();
    }

    public Integer getProtocolVersion(PlayerT var1);

    public String getExactVersion(PlayerT var1);

    public Integer getProtocolVersion(UUID var1);

    public String getExactVersion(UUID var1);
}

