/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.api.protocol;

public class OffsetStringFormatter {
    private static final int PREFIX_LENGTH = "%nox_offset%".length();

    public static String write(ComponentOffset offset) {
        return "%nox_offset%" + offset.x + "," + offset.y;
    }

    public static Float parseX(String input) {
        String base;
        int commaIndex;
        if (input != null && input.startsWith("%nox_offset%") && (commaIndex = (base = input.substring(PREFIX_LENGTH)).indexOf(",")) != -1) {
            String number = base.substring(0, commaIndex);
            try {
                return Float.valueOf(Float.parseFloat(number));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Float parseY(String input) {
        String base;
        int commaIndex;
        if (input != null && input.startsWith("%nox_offset%") && (commaIndex = (base = input.substring(PREFIX_LENGTH)).indexOf(",")) != -1) {
            String number = base.substring(commaIndex + 1);
            try {
                return Float.valueOf(Float.parseFloat(number));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public record ComponentOffset(float x, float y) {
    }
}

