/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.api.protocol.skull;

import java.util.UUID;

public class SkullStringFormatter {
    public static String write(SkullInfo info) {
        StringBuilder stringBuilder = new StringBuilder();
        if (info.raw()) {
            stringBuilder.append("%nox_raw%");
        } else {
            stringBuilder.append("%nox_uuid%");
        }
        stringBuilder.append(info.value).append(",");
        stringBuilder.append(info.grayscale).append(",");
        stringBuilder.append(info.advance).append(",");
        stringBuilder.append(info.ascent).append(",");
        stringBuilder.append(info.scale);
        return stringBuilder.toString();
    }

    public static SkullInfo parse(String input) throws IllegalArgumentException, NumberFormatException {
        String[] values2;
        boolean raw = false;
        if (input.startsWith("%nox_uuid%")) {
            values2 = input.substring("%nox_uuid%".length()).split(",");
        } else if (input.startsWith("%nox_raw%")) {
            values2 = input.substring("%nox_raw%".length()).split(",");
            raw = true;
        } else {
            throw new IllegalArgumentException("Input string is not a valid skull info string");
        }
        boolean grayscale = Boolean.parseBoolean(values2[1]);
        int advance = Integer.parseInt(values2[2]);
        int ascent = Integer.parseInt(values2[3]);
        float scale = Float.parseFloat(values2[4]);
        return new SkullInfo(raw, values2[0], grayscale, advance, ascent, scale);
    }

    public record SkullInfo(boolean raw, String value, boolean grayscale, int advance, int ascent, float scale) {
        public SkullInfo(String texture) {
            this(true, texture, false, 0, 0, 1.0f);
        }

        public SkullInfo(UUID uuid) {
            this(false, uuid.toString(), false, 0, 0, 1.0f);
        }
    }
}

