/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.paper.api;

import com.noxcrew.noxesium.api.protocol.ClientSettings;
import com.noxcrew.noxesium.api.protocol.NoxesiumFeature;
import com.noxcrew.noxesium.api.protocol.NoxesiumServerManager;
import com.noxcrew.noxesium.paper.api.BaseNoxesiumListener;
import com.noxcrew.noxesium.paper.api.RuleContainer;
import com.noxcrew.noxesium.paper.api.RuleFunction;
import com.noxcrew.noxesium.paper.api.RuleHolder;
import com.noxcrew.noxesium.paper.api.event.NoxesiumPlayerRegisteredEvent;
import com.noxcrew.noxesium.paper.api.network.NoxesiumPacket;
import com.noxcrew.noxesium.paper.api.network.NoxesiumPackets;
import com.noxcrew.noxesium.paper.api.network.clientbound.ClientboundChangeServerRulesPacket;
import com.noxcrew.noxesium.paper.api.network.clientbound.ClientboundServerInformationPacket;
import com.noxcrew.noxesium.paper.api.network.serverbound.ServerboundClientInformationPacket;
import com.noxcrew.noxesium.paper.api.network.serverbound.ServerboundClientSettingsPacket;
import com.noxcrew.noxesium.paper.api.rule.RemoteServerRule;
import com.noxcrew.noxesium.paper.v0.NoxesiumListenerV0;
import com.noxcrew.noxesium.paper.v1.NoxesiumListenerV1;
import com.noxcrew.noxesium.paper.v2.NoxesiumListenerV2;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u0010J\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020-J\u000e\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020\u0002J\u0010\u00101\u001a\u00020-2\u0006\u00100\u001a\u00020\u0002H\u0014J\u0018\u00102\u001a\u0004\u0018\u0001032\u0006\u00100\u001a\u00020\u00022\u0006\u00104\u001a\u000205J\u0016\u00106\u001a\u00020-2\u0006\u00100\u001a\u00020\u00022\u0006\u00104\u001a\u000205J%\u00107\u001a\u00020-2\u0006\u00100\u001a\u00020\u00022\u0006\u00108\u001a\u00020\u00112\u0006\u00109\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b:J\u000e\u0010;\u001a\u00020-2\u0006\u00100\u001a\u00020\u0002J\u0018\u0010;\u001a\u00020-2\u0006\u00100\u001a\u00020\u00022\u0006\u0010<\u001a\u00020\u0017H\u0002J%\u0010=\u001a\u00020-2\u0006\u00100\u001a\u00020\u00022\u0006\u00109\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b>J\u001d\u0010?\u001a\u00020-2\u0006\u00100\u001a\u00020\u00022\u0006\u0010@\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\bAJ.\u0010B\u001a\n\u0012\u0004\u0012\u0002HD\u0018\u00010C\"\b\b\u0000\u0010D*\u00020E2\u0006\u00100\u001a\u00020\u00022\f\u0010F\u001a\b\u0012\u0004\u0012\u0002HD0GJ*\u0010B\u001a\n\u0012\u0004\u0012\u0002HD\u0018\u00010C\"\b\b\u0000\u0010D*\u00020E2\u0006\u00100\u001a\u00020\u00022\u0006\u0010H\u001a\u00020\u0011H\u0016J\u0012\u0010I\u001a\u0004\u0018\u00010\u00152\u0006\u00100\u001a\u00020\u0002H\u0016J\u0012\u0010I\u001a\u0004\u0018\u00010\u00152\u0006\u0010+\u001a\u00020\u0010H\u0016J\u0017\u0010J\u001a\u0004\u0018\u00010\u00112\u0006\u00100\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010KJ\u0012\u0010L\u001a\u0004\u0018\u00010\u00132\u0006\u00100\u001a\u00020\u0002H\u0016J\u0017\u0010J\u001a\u0004\u0018\u00010\u00112\u0006\u0010+\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010MJ\u0014\u0010L\u001a\u0004\u0018\u00010\u00132\b\u0010+\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010N\u001a\u00020-2\u0006\u0010O\u001a\u00020PH\u0007J\u0010\u0010Q\u001a\u00020-2\u0006\u00100\u001a\u00020\u0002H\u0014J \u0010R\u001a\u00020-2\u0006\u00100\u001a\u00020\u00022\u0006\u00109\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0011H\u0014J\u0018\u0010S\u001a\u00020-2\u0006\u00100\u001a\u00020\u00022\u0006\u0010@\u001a\u00020\u0015H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00150\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00170\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RP\u0010\u0018\u001aB\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001b0\u001b \u001a* \u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001b0\u001b\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR&\u0010\u001d\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00130\u001e0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010'\u00a8\u0006T"}, d2={"Lcom/noxcrew/noxesium/paper/api/NoxesiumManager;", "Lcom/noxcrew/noxesium/api/protocol/NoxesiumServerManager;", "Lorg/bukkit/entity/Player;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/Plugin;", "logger", "Lorg/slf4j/Logger;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lorg/slf4j/Logger;)V", "getPlugin", "()Lorg/bukkit/plugin/Plugin;", "getLogger", "()Lorg/slf4j/Logger;", "players", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "", "exact", "", "settings", "Lcom/noxcrew/noxesium/api/protocol/ClientSettings;", "profiles", "Lcom/noxcrew/noxesium/paper/api/RuleHolder;", "ready", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "kotlin.jvm.PlatformType", "", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "pending", "Lkotlin/Pair;", "v0", "Lcom/noxcrew/noxesium/paper/api/BaseNoxesiumListener;", "v1", "v2", "task", "serverRules", "Lcom/noxcrew/noxesium/paper/api/RuleContainer;", "getServerRules", "()Lcom/noxcrew/noxesium/paper/api/RuleContainer;", "entityRules", "getEntityRules", "isReady", "playerId", "register", "", "unregister", "markReady", "player", "onReady", "createPacket", "Lnet/minecraft/network/protocol/common/ClientboundCustomPayloadPacket;", "packet", "Lcom/noxcrew/noxesium/paper/api/network/NoxesiumPacket;", "sendPacket", "registerPlayer", "protocolVersion", "version", "registerPlayer$paper", "updateServerRules", "profile", "saveProtocol", "saveProtocol$paper", "saveSettings", "clientSettings", "saveSettings$paper", "getServerRule", "Lcom/noxcrew/noxesium/paper/api/rule/RemoteServerRule;", "T", "", "rule", "Lcom/noxcrew/noxesium/paper/api/RuleFunction;", "index", "getClientSettings", "getProtocolVersion", "(Lorg/bukkit/entity/Player;)Ljava/lang/Integer;", "getExactVersion", "(Ljava/util/UUID;)Ljava/lang/Integer;", "onPlayerQuit", "e", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onPlayerRegistered", "onPlayerVersionReceived", "onPlayerSettingsReceived", "paper"})
@SourceDebugExtension(value={"SMAP\nNoxesiumManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoxesiumManager.kt\ncom/noxcrew/noxesium/paper/api/NoxesiumManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,255:1\n535#2:256\n520#2,6:257\n462#2:263\n412#2:264\n1246#3,4:265\n*S KotlinDebug\n*F\n+ 1 NoxesiumManager.kt\ncom/noxcrew/noxesium/paper/api/NoxesiumManager\n*L\n190#1:256\n190#1:257,6\n190#1:263\n190#1:264\n190#1:265,4\n*E\n"})
public class NoxesiumManager
implements NoxesiumServerManager<Player>,
Listener {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<UUID, Integer> players;
    @NotNull
    private final ConcurrentHashMap<UUID, String> exact;
    @NotNull
    private final ConcurrentHashMap<UUID, ClientSettings> settings;
    @NotNull
    private final ConcurrentHashMap<UUID, RuleHolder> profiles;
    private final ConcurrentHashMap.KeySetView<UUID, Boolean> ready;
    @NotNull
    private final ConcurrentHashMap<UUID, Pair<Integer, String>> pending;
    private BaseNoxesiumListener v0;
    private BaseNoxesiumListener v1;
    private BaseNoxesiumListener v2;
    private int task;
    @NotNull
    private final RuleContainer serverRules;
    @NotNull
    private final RuleContainer entityRules;

    public NoxesiumManager(@NotNull Plugin plugin, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.plugin = plugin;
        this.logger = logger;
        this.players = new ConcurrentHashMap();
        this.exact = new ConcurrentHashMap();
        this.settings = new ConcurrentHashMap();
        this.profiles = new ConcurrentHashMap();
        this.ready = ConcurrentHashMap.newKeySet();
        this.pending = new ConcurrentHashMap();
        this.task = -1;
        this.serverRules = new RuleContainer(null, null, 3, null);
        this.entityRules = new RuleContainer(null, null, 3, null);
    }

    @NotNull
    public final Plugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final RuleContainer getServerRules() {
        return this.serverRules;
    }

    @NotNull
    public final RuleContainer getEntityRules() {
        return this.entityRules;
    }

    public final boolean isReady(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        return this.ready.contains(playerId);
    }

    public final void register() {
        this.v0 = new NoxesiumListenerV0(this.plugin, this.logger, this).register();
        this.v1 = new NoxesiumListenerV1(this.plugin, this.logger, this).register();
        this.v2 = new NoxesiumListenerV2(this.plugin, this.logger, this).register();
        this.task = Bukkit.getScheduler().scheduleSyncRepeatingTask(this.plugin, () -> NoxesiumManager.register$lambda$0(this), 1L, 1L);
        NoxesiumPackets.INSTANCE.getSERVER_CLIENT_INFO().addListener(this, NoxesiumManager::register$lambda$1);
        NoxesiumPackets.INSTANCE.getSERVER_CLIENT_SETTINGS().addListener(this, NoxesiumManager::register$lambda$2);
        Bukkit.getPluginManager().registerEvents((Listener)this, this.plugin);
    }

    public final void unregister() {
        HandlerList.unregisterAll((Listener)this);
        Bukkit.getScheduler().cancelTask(this.task);
        BaseNoxesiumListener baseNoxesiumListener = this.v0;
        if (baseNoxesiumListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException("v0");
            baseNoxesiumListener = null;
        }
        baseNoxesiumListener.unregister();
        BaseNoxesiumListener baseNoxesiumListener2 = this.v1;
        if (baseNoxesiumListener2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("v1");
            baseNoxesiumListener2 = null;
        }
        baseNoxesiumListener2.unregister();
        BaseNoxesiumListener baseNoxesiumListener3 = this.v2;
        if (baseNoxesiumListener3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("v2");
            baseNoxesiumListener3 = null;
        }
        baseNoxesiumListener3.unregister();
    }

    public final void markReady(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, () -> NoxesiumManager.markReady$lambda$3(player, this), 1L);
    }

    protected void onReady(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
    }

    @Nullable
    public final ClientboundCustomPayloadPacket createPacket(@NotNull Player player, @NotNull NoxesiumPacket packet) {
        ClientboundCustomPayloadPacket clientboundCustomPayloadPacket;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(packet, "packet");
        Integer n = this.getProtocolVersion(player);
        if (n == null) {
            return null;
        }
        int protocol = n;
        if (protocol < NoxesiumFeature.API_V1.getMinProtocolVersion()) {
            BaseNoxesiumListener baseNoxesiumListener = this.v0;
            if (baseNoxesiumListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException("v0");
                baseNoxesiumListener = null;
            }
            clientboundCustomPayloadPacket = baseNoxesiumListener.createPacket(player, packet);
        } else if (protocol < NoxesiumFeature.API_V2.getMinProtocolVersion()) {
            BaseNoxesiumListener baseNoxesiumListener = this.v1;
            if (baseNoxesiumListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException("v1");
                baseNoxesiumListener = null;
            }
            clientboundCustomPayloadPacket = baseNoxesiumListener.createPacket(player, packet);
        } else {
            BaseNoxesiumListener baseNoxesiumListener = this.v2;
            if (baseNoxesiumListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException("v2");
                baseNoxesiumListener = null;
            }
            clientboundCustomPayloadPacket = baseNoxesiumListener.createPacket(player, packet);
        }
        return clientboundCustomPayloadPacket;
    }

    public final void sendPacket(@NotNull Player player, @NotNull NoxesiumPacket packet) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(packet, "packet");
        ClientboundCustomPayloadPacket clientboundCustomPayloadPacket = this.createPacket(player, packet);
        if (clientboundCustomPayloadPacket == null) {
            return;
        }
        ClientboundCustomPayloadPacket nmsPacket = clientboundCustomPayloadPacket;
        CraftPlayer craftPlayer = (CraftPlayer)player;
        craftPlayer.getHandle().connection.send((Packet)nmsPacket);
    }

    public final void registerPlayer$paper(@NotNull Player player, int protocolVersion, @NotNull String version) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(version, "version");
        this.logger.info(player.getName() + " is running Noxesium " + version + " (" + protocolVersion + ")");
        this.saveProtocol$paper(player, version, protocolVersion);
        this.sendPacket(player, new ClientboundServerInformationPacket(18));
        this.onPlayerRegistered(player);
        Bukkit.getPluginManager().callEvent((Event)new NoxesiumPlayerRegisteredEvent(player, protocolVersion, version));
        this.updateServerRules(player);
    }

    public final void updateServerRules(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        RuleHolder ruleHolder = this.profiles.get(player.getUniqueId());
        if (ruleHolder == null) {
            return;
        }
        RuleHolder profile = ruleHolder;
        if (!profile.getNeedsUpdate()) {
            return;
        }
        this.updateServerRules(player, profile);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateServerRules(Player player, RuleHolder profile) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map map2;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        Map<Integer, RemoteServerRule<?>> map3 = profile.getRules();
        Player player2 = player;
        NoxesiumManager noxesiumManager = this;
        boolean $i$f$filter = false;
        void var5_7 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!((RemoteServerRule)it.getValue()).getChangePending$paper()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = map2 = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$filterTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map2 = map4;
            boolean bl2 = false;
            RemoteServerRule rule = (RemoteServerRule)entry2.getValue();
            Function1<RegistryFriendlyByteBuf, Unit> function1 = arg_0 -> NoxesiumManager.updateServerRules$lambda$6$lambda$5(rule, arg_0);
            map2.put(k, function1);
        }
        Map map5 = map2 = destination$iv$iv;
        noxesiumManager.sendPacket(player2, new ClientboundChangeServerRulesPacket(map5));
    }

    public final void saveProtocol$paper(@NotNull Player player, @NotNull String version, int protocolVersion) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(version, "version");
        Integer n = protocolVersion;
        ((Map)this.players).put(player.getUniqueId(), n);
        ((Map)this.exact).put(player.getUniqueId(), version);
        this.onPlayerVersionReceived(player, version, protocolVersion);
    }

    public final void saveSettings$paper(@NotNull Player player, @NotNull ClientSettings clientSettings) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(clientSettings, "clientSettings");
        ((Map)this.settings).put(player.getUniqueId(), clientSettings);
        this.onPlayerSettingsReceived(player, clientSettings);
    }

    @Nullable
    public final <T> RemoteServerRule<T> getServerRule(@NotNull Player player, @NotNull RuleFunction<T> rule) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(rule, "rule");
        return this.getServerRule(player, rule.getIndex());
    }

    @Nullable
    public <T> RemoteServerRule<T> getServerRule(@NotNull Player player, int index) {
        Intrinsics.checkNotNullParameter(player, "player");
        RuleHolder holder = this.profiles.computeIfAbsent(player.getUniqueId(), arg_0 -> NoxesiumManager.getServerRule$lambda$8(NoxesiumManager::getServerRule$lambda$7, arg_0));
        boolean bl = false;
        Intrinsics.checkNotNull(holder);
        Integer n = this.getProtocolVersion(player);
        return this.serverRules.create(index, holder, n != null ? n : -1);
    }

    @Override
    @Nullable
    public ClientSettings getClientSettings(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        return this.getClientSettings(uUID);
    }

    @Override
    @Nullable
    public ClientSettings getClientSettings(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        return this.settings.get(playerId);
    }

    @Override
    @Nullable
    public Integer getProtocolVersion(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        return this.getProtocolVersion(uUID);
    }

    @Override
    @Nullable
    public String getExactVersion(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return this.getExactVersion(player.getUniqueId());
    }

    @Override
    @Nullable
    public Integer getProtocolVersion(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        return this.players.get(playerId);
    }

    @Override
    @Nullable
    public String getExactVersion(@Nullable UUID playerId) {
        return (String)((Map)this.exact).get(playerId);
    }

    @EventHandler
    public final void onPlayerQuit(@NotNull PlayerQuitEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        ((Map)this.players).remove(e.getPlayer().getUniqueId());
        ((Map)this.exact).remove(e.getPlayer().getUniqueId());
        ((Map)this.settings).remove(e.getPlayer().getUniqueId());
        ((Map)this.profiles).remove(e.getPlayer().getUniqueId());
        ConcurrentHashMap.KeySetView<UUID, Boolean> keySetView = this.ready;
        Intrinsics.checkNotNullExpressionValue(keySetView, "ready");
        Collection collection = keySetView;
        collection.remove(e.getPlayer().getUniqueId());
        ((Map)this.pending).remove(e.getPlayer().getUniqueId());
    }

    protected void onPlayerRegistered(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
    }

    protected void onPlayerVersionReceived(@NotNull Player player, @NotNull String version, int protocolVersion) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(version, "version");
    }

    protected void onPlayerSettingsReceived(@NotNull Player player, @NotNull ClientSettings clientSettings) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(clientSettings, "clientSettings");
    }

    private static final void register$lambda$0(NoxesiumManager this$0) {
        for (Map.Entry entry : ((Map)this$0.profiles).entrySet()) {
            UUID player = (UUID)entry.getKey();
            RuleHolder profile = (RuleHolder)entry.getValue();
            if (!profile.getNeedsUpdate()) continue;
            Player player2 = Bukkit.getPlayer((UUID)player);
            if (player2 == null) continue;
            this$0.updateServerRules(player2, profile);
        }
    }

    private static final Unit register$lambda$1(NoxesiumManager $this$addListener, ServerboundClientInformationPacket packet, Player player) {
        Intrinsics.checkNotNullParameter($this$addListener, "$this$addListener");
        Intrinsics.checkNotNullParameter(packet, "packet");
        Intrinsics.checkNotNullParameter(player, "player");
        if (!$this$addListener.ready.contains(player.getUniqueId())) {
            ((Map)$this$addListener.pending).put(player.getUniqueId(), TuplesKt.to(packet.getProtocolVersion(), packet.getVersionString()));
            return Unit.INSTANCE;
        }
        $this$addListener.registerPlayer$paper(player, packet.getProtocolVersion(), packet.getVersionString());
        return Unit.INSTANCE;
    }

    private static final Unit register$lambda$2(NoxesiumManager $this$addListener, ServerboundClientSettingsPacket packet, Player player) {
        Intrinsics.checkNotNullParameter($this$addListener, "$this$addListener");
        Intrinsics.checkNotNullParameter(packet, "packet");
        Intrinsics.checkNotNullParameter(player, "player");
        $this$addListener.saveSettings$paper(player, packet.getSettings());
        return Unit.INSTANCE;
    }

    private static final void markReady$lambda$3(Player $player, NoxesiumManager this$0) {
        if (!$player.isConnected()) {
            return;
        }
        ConcurrentHashMap.KeySetView<UUID, Boolean> keySetView = this$0.ready;
        Intrinsics.checkNotNullExpressionValue(keySetView, "ready");
        Object object = keySetView;
        object.add($player.getUniqueId());
        this$0.onReady($player);
        Pair<Integer, String> pair = this$0.pending.remove($player.getUniqueId());
        if (pair == null) {
            return;
        }
        object = pair;
        int protocolVersion = ((Number)((Pair)object).component1()).intValue();
        String version = (String)((Pair)object).component2();
        this$0.registerPlayer$paper($player, protocolVersion, version);
    }

    private static final Unit updateServerRules$lambda$6$lambda$5(RemoteServerRule $rule, RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNull($rule, "null cannot be cast to non-null type com.noxcrew.noxesium.paper.api.rule.RemoteServerRule<kotlin.Any>");
        $rule.write($rule.getValue(), buffer);
        $rule.setChangePending$paper(false);
        return Unit.INSTANCE;
    }

    private static final RuleHolder getServerRule$lambda$7(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new RuleHolder(null, 1, null);
    }

    private static final RuleHolder getServerRule$lambda$8(Function1 $tmp0, Object p0) {
        return (RuleHolder)$tmp0.invoke(p0);
    }
}

