/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.glowingentities;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import fr.skytasul.reflection.MappedReflectionAccessor;
import fr.skytasul.reflection.ReflectionAccessor;
import fr.skytasul.reflection.TransparentReflectionAccessor;
import fr.skytasul.reflection.Version;
import fr.skytasul.reflection.mappings.Mappings;
import fr.skytasul.reflection.mappings.files.MappingFileReader;
import fr.skytasul.reflection.mappings.files.ProguardMapping;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class GlowingEntities
implements Listener {
    @NotNull
    protected final Plugin plugin;
    private Map<Player, PlayerData> glowing;
    boolean enabled = false;
    private int uid;

    public GlowingEntities(@NotNull Plugin plugin) {
        Packets.ensureInitialized();
        this.plugin = Objects.requireNonNull(plugin);
        this.enable();
    }

    public void enable() {
        if (this.enabled) {
            throw new IllegalStateException("The Glowing Entities API has already been enabled.");
        }
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
        this.glowing = new HashMap<Player, PlayerData>();
        this.uid = ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);
        this.enabled = true;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        HandlerList.unregisterAll((Listener)this);
        this.glowing.values().forEach(playerData -> {
            try {
                Packets.removePacketsHandler(playerData);
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        });
        this.glowing = null;
        this.uid = 0;
        this.enabled = false;
    }

    private void ensureEnabled() {
        if (!this.enabled) {
            throw new IllegalStateException("The Glowing Entities API is not enabled.");
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.glowing.remove(event.getPlayer());
    }

    public void setGlowing(Entity entity, Player receiver) throws ReflectiveOperationException {
        this.setGlowing(entity, receiver, null);
    }

    public void setGlowing(Entity entity, Player receiver, ChatColor color) throws ReflectiveOperationException {
        String teamID = entity instanceof Player ? entity.getName() : entity.getUniqueId().toString();
        this.setGlowing(entity.getEntityId(), teamID, receiver, color, Packets.getEntityFlags(entity));
    }

    public void setGlowing(int entityID, String teamID, Player receiver) throws ReflectiveOperationException {
        this.setGlowing(entityID, teamID, receiver, null, (byte)0);
    }

    public void setGlowing(int entityID, String teamID, Player receiver, ChatColor color) throws ReflectiveOperationException {
        this.setGlowing(entityID, teamID, receiver, color, (byte)0);
    }

    public void setGlowing(int entityID, String teamID, Player receiver, ChatColor color, byte otherFlags) throws ReflectiveOperationException {
        GlowingData glowingData;
        this.ensureEnabled();
        if (color != null && !color.isColor()) {
            throw new IllegalArgumentException("ChatColor must be a color format");
        }
        PlayerData playerData = this.glowing.get(receiver);
        if (playerData == null) {
            playerData = new PlayerData(this, receiver);
            Packets.addPacketsHandler(playerData);
            this.glowing.put(receiver, playerData);
        }
        if ((glowingData = playerData.glowingDatas.get(entityID)) == null) {
            glowingData = new GlowingData(playerData, entityID, teamID, color, otherFlags);
            playerData.glowingDatas.put(entityID, glowingData);
            Packets.createGlowing(glowingData);
            if (color != null) {
                Packets.setGlowingColor(glowingData);
            }
        } else {
            if (Objects.equals(glowingData.color, color)) {
                return;
            }
            if (color == null) {
                Packets.removeGlowingColor(glowingData);
                glowingData.color = color;
            } else {
                glowingData.color = color;
                Packets.setGlowingColor(glowingData);
            }
        }
    }

    public void unsetGlowing(Entity entity, Player receiver) throws ReflectiveOperationException {
        this.unsetGlowing(entity.getEntityId(), receiver);
    }

    public void unsetGlowing(int entityID, Player receiver) throws ReflectiveOperationException {
        this.ensureEnabled();
        PlayerData playerData = this.glowing.get(receiver);
        if (playerData == null) {
            return;
        }
        GlowingData glowingData = playerData.glowingDatas.remove(entityID);
        if (glowingData == null) {
            return;
        }
        Packets.removeGlowing(glowingData);
        if (glowingData.color != null) {
            Packets.removeGlowingColor(glowingData);
        }
    }

    protected static class Packets {
        private static final byte GLOWING_FLAG = 64;
        private static Cache<Object, Object> packets = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();
        private static Object dummy = new Object();
        private static Logger logger;
        private static String cpack;
        private static Version version;
        private static boolean isEnabled;
        private static boolean hasInitialized;
        private static Throwable initializationError;
        private static Method getHandle;
        private static Method getDataWatcher;
        private static Object watcherObjectFlags;
        private static Object watcherDummy;
        private static Method watcherGet;
        private static Constructor<?> watcherItemConstructor;
        private static Method watcherItemObject;
        private static Method watcherItemDataGet;
        private static Method watcherBCreator;
        private static Method watcherBId;
        private static Method watcherBSerializer;
        private static Method watcherSerializerObject;
        private static Field playerConnection;
        private static Method sendPacket;
        private static Field networkManager;
        private static Field channelField;
        private static ReflectionAccessor.ClassAccessor packetBundle;
        private static Method packetBundlePackets;
        private static ReflectionAccessor.ClassAccessor packetMetadata;
        private static Constructor<?> packetMetadataConstructor;
        private static Field packetMetadataEntity;
        private static Field packetMetadataItems;
        private static EnumMap<ChatColor, TeamData> teams;
        private static Constructor<?> createTeamPacket;
        private static Constructor<?> createTeamPacketData;
        private static Constructor<?> createTeam;
        private static Object scoreboardDummy;
        private static Object pushNever;
        private static Method setTeamPush;
        private static Method setTeamColor;
        private static Method getColorConstant;
        protected static Object shulkerEntityType;
        private static Constructor<?> packetAddEntity;
        private static Constructor<?> packetRemove;
        private static Object vec3dZero;

        protected Packets() {
        }

        protected static void ensureInitialized() {
            if (!hasInitialized) {
                Packets.initialize();
            }
            if (!isEnabled) {
                throw new IllegalStateException("The Glowing Entities API is disabled. An error has occured during first initialization.", initializationError);
            }
        }

        private static void initialize() {
            hasInitialized = true;
            try {
                ReflectionAccessor reflection;
                boolean remapped;
                logger = new Logger("GlowingEntities", null){

                    @Override
                    public void log(LogRecord logRecord) {
                        logRecord.setMessage("[GlowingEntities] " + logRecord.getMessage());
                        super.log(logRecord);
                    }
                };
                logger.setParent(Bukkit.getServer().getLogger());
                logger.setLevel(Level.ALL);
                String versionString = Bukkit.getBukkitVersion().split("-R")[0];
                Version serverVersion = Version.parse(versionString);
                logger.info("Found server version " + String.valueOf(serverVersion));
                cpack = Bukkit.getServer().getClass().getPackage().getName() + ".";
                boolean bl = remapped = Bukkit.getServer().getClass().getPackage().getName().split("\\.").length == 3;
                if (remapped) {
                    version = serverVersion;
                    reflection = new TransparentReflectionAccessor();
                    logger.info("Loaded transparent mappings.");
                } else {
                    String mappingsFile = new String(GlowingEntities.class.getResourceAsStream("mappings/spigot.txt").readAllBytes());
                    MappingFileReader mappingsReader = new MappingFileReader(new ProguardMapping(false), mappingsFile.lines().toList());
                    Optional<Version> foundVersion = mappingsReader.keepBestMatchedVersion(serverVersion);
                    if (foundVersion.isEmpty()) {
                        throw new UnsupportedOperationException("Cannot find mappings to match server version");
                    }
                    if (!foundVersion.get().is(serverVersion)) {
                        logger.warning("Loaded not matching version of the mappings for your server version");
                    }
                    version = foundVersion.get();
                    mappingsReader.parseMappings();
                    Mappings mappings = mappingsReader.getParsedMappings(foundVersion.get());
                    logger.info("Loaded mappings for " + String.valueOf(version));
                    reflection = new MappedReflectionAccessor(mappings);
                }
                Packets.loadReflection(reflection, version);
                isEnabled = true;
            }
            catch (Exception ex) {
                initializationError = ex;
                String errorMsg = "Glowing Entities reflection failed to initialize. The util is disabled. Please ensure your version (" + Bukkit.getBukkitVersion() + ") is supported.";
                if (logger == null) {
                    ex.printStackTrace();
                    System.err.println(errorMsg);
                }
                logger.log(Level.SEVERE, errorMsg, ex);
            }
        }

        protected static void loadReflection(@NotNull ReflectionAccessor reflection, @NotNull Version version) throws ReflectiveOperationException {
            ReflectionAccessor.ClassAccessor entityClass = Packets.getNMSClass(reflection, "world.entity", "Entity");
            ReflectionAccessor.ClassAccessor entityTypesClass = Packets.getNMSClass(reflection, "world.entity", "EntityType");
            Object worldInstance = version.isAfter(1, 21, 3) && cpack != null ? Packets.getCraftClass("", "CraftWorld").getDeclaredMethod("getHandle", new Class[0]).invoke(Bukkit.getWorlds().get(0), new Object[0]) : null;
            Object markerEntity = Packets.getNMSClass(reflection, "world.entity", "Marker").getConstructor(entityTypesClass, Packets.getNMSClass(reflection, "world.level", "Level")).newInstance(entityTypesClass.getField("MARKER").get(null), worldInstance);
            getHandle = cpack == null ? null : Packets.getCraftClass("entity", "CraftEntity").getDeclaredMethod("getHandle", new Class[0]);
            getDataWatcher = entityClass.getMethodInstance("getEntityData", new Type[0]);
            ReflectionAccessor.ClassAccessor dataWatcherClass = Packets.getNMSClass(reflection, "network.syncher", "SynchedEntityData");
            if (version.isAfter(1, 20, 5)) {
                ReflectionAccessor.ClassAccessor dataWatcherBuilderClass = Packets.getNMSClass(reflection, "network.syncher", "SynchedEntityData$Builder");
                Object watcherBuilder = dataWatcherBuilderClass.getConstructor(Packets.getNMSClass(reflection, "network.syncher", "SyncedDataHolder")).newInstance(markerEntity);
                ReflectionAccessor.ClassAccessor.FieldAccessor watcherBuilderItems = dataWatcherBuilderClass.getField("itemsById");
                watcherBuilderItems.set(watcherBuilder, Array.newInstance(Packets.getNMSClass(reflection, "network.syncher", "SynchedEntityData$DataItem").getClassInstance(), 0));
                watcherDummy = dataWatcherBuilderClass.getMethod("build", new Type[0]).invoke(watcherBuilder, new Object[0]);
            } else {
                watcherDummy = dataWatcherClass.getConstructor(entityClass).newInstance(markerEntity);
            }
            ReflectionAccessor.ClassAccessor entityDataAccessorClass = Packets.getNMSClass(reflection, "network.syncher", "EntityDataAccessor");
            watcherObjectFlags = entityClass.getField("DATA_SHARED_FLAGS_ID").get(null);
            watcherGet = dataWatcherClass.getMethodInstance("get", entityDataAccessorClass);
            if (!version.isAfter(1, 19, 3)) {
                ReflectionAccessor.ClassAccessor watcherItemClass = Packets.getNMSClass(reflection, "network.syncher", "SynchedEntityData$DataItem");
                watcherItemConstructor = watcherItemClass.getConstructorInstance(new Type[]{entityDataAccessorClass, Object.class});
                watcherItemObject = watcherItemClass.getMethodInstance("getAccessor", new Type[0]);
                watcherItemDataGet = watcherItemClass.getMethodInstance("getValue", new Type[0]);
            } else {
                ReflectionAccessor.ClassAccessor watcherValueClass = Packets.getNMSClass(reflection, "network.syncher", "SynchedEntityData$DataValue");
                watcherBCreator = watcherValueClass.getMethodInstance("create", new Type[]{entityDataAccessorClass, Object.class});
                watcherBId = watcherValueClass.getMethodInstance("id", new Type[0]);
                watcherBSerializer = watcherValueClass.getMethodInstance("serializer", new Type[0]);
                watcherItemDataGet = watcherValueClass.getMethodInstance("value", new Type[0]);
                watcherSerializerObject = Packets.getNMSClass(reflection, "network.syncher", "EntityDataSerializer").getMethodInstance("createAccessor", Integer.TYPE);
            }
            playerConnection = Packets.getNMSClass(reflection, "server.level", "ServerPlayer").getFieldInstance("connection");
            ReflectionAccessor.ClassAccessor packetListenerClass = Packets.getNMSClass(reflection, "server.network", version.isAfter(1, 20, 2) ? "ServerCommonPacketListenerImpl" : "ServerGamePacketListenerImpl");
            sendPacket = packetListenerClass.getMethodInstance("send", Packets.getNMSClass(reflection, "network.protocol", "Packet"));
            networkManager = packetListenerClass.getFieldInstance("connection");
            channelField = Packets.getNMSClass(reflection, "network", "Connection").getFieldInstance("channel");
            if (version.isAfter(1, 19, 4)) {
                packetBundle = Packets.getNMSClass(reflection, "network.protocol", "BundlePacket");
                packetBundlePackets = packetBundle.getMethodInstance("subPackets", new Type[0]);
            }
            packetMetadata = Packets.getNMSClass(reflection, "network.protocol.game", "ClientboundSetEntityDataPacket");
            packetMetadataEntity = packetMetadata.getFieldInstance("id");
            packetMetadataItems = packetMetadata.getFieldInstance("packedItems");
            packetMetadataConstructor = version.isAfter(1, 19, 3) ? packetMetadata.getConstructorInstance(new Type[]{Integer.TYPE, List.class}) : packetMetadata.getConstructorInstance(Integer.TYPE, dataWatcherClass, Boolean.TYPE);
            ReflectionAccessor.ClassAccessor scoreboardClass = Packets.getNMSClass(reflection, "world.scores", "Scoreboard");
            ReflectionAccessor.ClassAccessor teamClass = Packets.getNMSClass(reflection, "world.scores", "PlayerTeam");
            ReflectionAccessor.ClassAccessor pushClass = Packets.getNMSClass(reflection, "world.scores", "Team$CollisionRule");
            ReflectionAccessor.ClassAccessor chatFormatClass = Packets.getNMSClass(reflection, "ChatFormatting");
            createTeamPacket = Packets.getNMSClass(reflection, "network.protocol.game", "ClientboundSetPlayerTeamPacket").getConstructorInstance(new Type[]{String.class, Integer.TYPE, Optional.class, Collection.class});
            createTeamPacketData = Packets.getNMSClass(reflection, "network.protocol.game", "ClientboundSetPlayerTeamPacket$Parameters").getConstructorInstance(teamClass);
            createTeam = teamClass.getConstructorInstance(new Type[]{scoreboardClass, String.class});
            scoreboardDummy = scoreboardClass.getConstructor(new Type[0]).newInstance(new Object[0]);
            pushNever = pushClass.getField("NEVER").get(null);
            setTeamPush = teamClass.getMethodInstance("setCollisionRule", pushClass);
            setTeamColor = teamClass.getMethodInstance("setColor", chatFormatClass);
            getColorConstant = chatFormatClass.getMethodInstance("getByCode", Character.TYPE);
            shulkerEntityType = entityTypesClass.getField("SHULKER").get(null);
            ReflectionAccessor.ClassAccessor vec3dClass = Packets.getNMSClass(reflection, "world.phys", "Vec3");
            vec3dZero = vec3dClass.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE).newInstance(0.0, 0.0, 0.0);
            ReflectionAccessor.ClassAccessor addEntityPacketClass = Packets.getNMSClass(reflection, "network.protocol.game", "ClientboundAddEntityPacket");
            packetAddEntity = version.isAfter(1, 19, 0) ? addEntityPacketClass.getConstructorInstance(new Type[]{Integer.TYPE, UUID.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, entityTypesClass, Integer.TYPE, vec3dClass, Double.TYPE}) : addEntityPacketClass.getConstructorInstance(new Type[]{Integer.TYPE, UUID.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, entityTypesClass, Integer.TYPE, vec3dClass});
            packetRemove = version.is(1, 17, 0) ? Packets.getNMSClass(reflection, "network.protocol.game", "ClientboundRemoveEntityPacket").getConstructorInstance(Integer.TYPE) : Packets.getNMSClass(reflection, "network.protocol.game", "ClientboundRemoveEntitiesPacket").getConstructorInstance(new Type[]{int[].class});
        }

        public static void sendPackets(Player p, Object ... packets) throws ReflectiveOperationException {
            Object connection = playerConnection.get(getHandle.invoke((Object)p, new Object[0]));
            for (Object packet : packets) {
                if (packet == null) continue;
                sendPacket.invoke(connection, packet);
            }
        }

        public static byte getEntityFlags(Entity entity) throws ReflectiveOperationException {
            Object nmsEntity = getHandle.invoke((Object)entity, new Object[0]);
            Object dataWatcher = getDataWatcher.invoke(nmsEntity, new Object[0]);
            return (Byte)watcherGet.invoke(dataWatcher, watcherObjectFlags);
        }

        public static void createGlowing(GlowingData glowingData) throws ReflectiveOperationException {
            Packets.setMetadata(glowingData.player.player, glowingData.entityID, Packets.computeFlags(glowingData), true);
        }

        private static byte computeFlags(GlowingData glowingData) {
            byte newFlags = glowingData.otherFlags;
            newFlags = glowingData.enabled ? (byte)(newFlags | 0x40) : (byte)(newFlags & 0xFFFFFFBF);
            return newFlags;
        }

        public static Object createFlagWatcherItem(byte newFlags) throws ReflectiveOperationException {
            return watcherItemConstructor != null ? watcherItemConstructor.newInstance(watcherObjectFlags, newFlags) : watcherBCreator.invoke(null, watcherObjectFlags, newFlags);
        }

        public static void removeGlowing(GlowingData glowingData) throws ReflectiveOperationException {
            Packets.setMetadata(glowingData.player.player, glowingData.entityID, glowingData.otherFlags, true);
        }

        public static void updateGlowingState(GlowingData glowingData) throws ReflectiveOperationException {
            if (glowingData.enabled) {
                Packets.createGlowing(glowingData);
            } else {
                Packets.removeGlowing(glowingData);
            }
        }

        public static void setMetadata(Player player, int entityId, byte flags, boolean ignore) throws ReflectiveOperationException {
            Object packetMetadata;
            ArrayList dataItems = new ArrayList(1);
            dataItems.add(watcherItemConstructor != null ? watcherItemConstructor.newInstance(watcherObjectFlags, flags) : watcherBCreator.invoke(null, watcherObjectFlags, flags));
            if (version.isBefore(1, 19, 3)) {
                packetMetadata = packetMetadataConstructor.newInstance(entityId, watcherDummy, false);
                packetMetadataItems.set(packetMetadata, dataItems);
            } else {
                packetMetadata = packetMetadataConstructor.newInstance(entityId, dataItems);
            }
            if (ignore) {
                packets.put(packetMetadata, dummy);
            }
            Packets.sendPackets(player, packetMetadata);
        }

        public static void setGlowingColor(GlowingData glowingData) throws ReflectiveOperationException {
            boolean sendCreation = false;
            if (glowingData.player.sentColors == null) {
                glowingData.player.sentColors = EnumSet.of(glowingData.color);
                sendCreation = true;
            } else if (glowingData.player.sentColors.add(glowingData.color)) {
                sendCreation = true;
            }
            TeamData teamData = teams.get(glowingData.color);
            if (teamData == null) {
                teamData = new TeamData(glowingData.player.instance.uid, glowingData.color);
                teams.put(glowingData.color, teamData);
            }
            Object entityAddPacket = teamData.getEntityAddPacket(glowingData.teamID);
            if (sendCreation) {
                Packets.sendPackets(glowingData.player.player, teamData.creationPacket, entityAddPacket);
            } else {
                Packets.sendPackets(glowingData.player.player, entityAddPacket);
            }
        }

        public static void removeGlowingColor(GlowingData glowingData) throws ReflectiveOperationException {
            TeamData teamData = teams.get(glowingData.color);
            if (teamData == null) {
                return;
            }
            Packets.sendPackets(glowingData.player.player, teamData.getEntityRemovePacket(glowingData.teamID));
        }

        public static void createEntity(Player player, int entityId, UUID entityUuid, Object entityType, Location location) throws IllegalArgumentException, ReflectiveOperationException {
            Object packet = version.isAfter(1, 19, 0) ? packetAddEntity.newInstance(entityId, entityUuid, location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getPitch()), Float.valueOf(location.getYaw()), entityType, 0, vec3dZero, 0.0) : packetAddEntity.newInstance(entityId, entityUuid, location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getPitch()), Float.valueOf(location.getYaw()), entityType, 0, vec3dZero);
            Packets.sendPackets(player, packet);
        }

        public static void removeEntities(Player player, int ... entitiesId) throws ReflectiveOperationException {
            Object[] packets;
            if (version.is(1, 17, 0)) {
                packets = new Object[entitiesId.length];
                for (int i = 0; i < entitiesId.length; ++i) {
                    packets[i] = packetRemove.newInstance(entitiesId[i]);
                }
            } else {
                packets = new Object[]{packetRemove.newInstance(new Object[]{entitiesId})};
            }
            Packets.sendPackets(player, packets);
        }

        private static Channel getChannel(Player player) throws ReflectiveOperationException {
            return (Channel)channelField.get(networkManager.get(playerConnection.get(getHandle.invoke((Object)player, new Object[0]))));
        }

        public static void addPacketsHandler(final PlayerData playerData) throws ReflectiveOperationException {
            playerData.packetsHandler = new ChannelDuplexHandler(){

                public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                    if (msg.getClass().equals(packetMetadata.getClassInstance()) && packets.asMap().remove(msg) == null) {
                        ArrayList<Object> items;
                        int entityID = packetMetadataEntity.getInt(msg);
                        GlowingData glowingData = playerData.glowingDatas.get(entityID);
                        if (glowingData != null && (items = (ArrayList<Object>)packetMetadataItems.get(msg)) != null) {
                            byte flags;
                            boolean containsFlags = false;
                            boolean edited = false;
                            for (int i = 0; i < items.size(); ++i) {
                                byte flags2;
                                Object watcherObject;
                                Object item = items.get(i);
                                if (watcherItemObject != null) {
                                    watcherObject = watcherItemObject.invoke(item, new Object[0]);
                                } else {
                                    Object serializer = watcherBSerializer.invoke(item, new Object[0]);
                                    watcherObject = watcherSerializerObject.invoke(serializer, watcherBId.invoke(item, new Object[0]));
                                }
                                if (!watcherObject.equals(watcherObjectFlags)) continue;
                                containsFlags = true;
                                glowingData.otherFlags = flags2 = ((Byte)watcherItemDataGet.invoke(item, new Object[0])).byteValue();
                                byte newFlags = Packets.computeFlags(glowingData);
                                if (newFlags == flags2) continue;
                                edited = true;
                                items = new ArrayList(items);
                                items.set(i, Packets.createFlagWatcherItem(newFlags));
                                break;
                            }
                            if (!edited && !containsFlags && (flags = Packets.computeFlags(glowingData)) != 0) {
                                edited = true;
                                items = new ArrayList<Object>(items);
                                items.add(Packets.createFlagWatcherItem(flags));
                            }
                            if (edited) {
                                Object newMsg;
                                if (version.isBefore(1, 19, 3)) {
                                    newMsg = packetMetadataConstructor.newInstance(entityID, watcherDummy, false);
                                    packetMetadataItems.set(newMsg, items);
                                } else {
                                    newMsg = packetMetadataConstructor.newInstance(entityID, items);
                                }
                                packets.put(newMsg, dummy);
                                Packets.sendPackets(playerData.player, newMsg);
                                return;
                            }
                        }
                    } else if (packetBundle != null && packetBundle.getClassInstance().isInstance(msg)) {
                        this.handlePacketBundle(msg);
                    }
                    super.write(ctx, msg, promise);
                }

                private void handlePacketBundle(Object bundle) throws ReflectiveOperationException {
                    Iterable subPackets = (Iterable)packetBundlePackets.invoke(bundle, new Object[0]);
                    for (Object packet : subPackets) {
                        int entityID;
                        GlowingData glowingData;
                        if (!packet.getClass().equals(packetMetadata) || (glowingData = playerData.glowingDatas.get(entityID = packetMetadataEntity.getInt(packet))) == null) continue;
                        Bukkit.getScheduler().runTaskLaterAsynchronously(playerData.instance.plugin, () -> {
                            try {
                                Packets.updateGlowingState(glowingData);
                            }
                            catch (ReflectiveOperationException e) {
                                e.printStackTrace();
                            }
                        }, 1L);
                        return;
                    }
                }
            };
            Packets.getChannel(playerData.player).pipeline().addBefore("packet_handler", null, playerData.packetsHandler);
        }

        public static void removePacketsHandler(PlayerData playerData) throws ReflectiveOperationException {
            if (playerData.packetsHandler != null) {
                Packets.getChannel(playerData.player).pipeline().remove(playerData.packetsHandler);
            }
        }

        private static Class<?> getCraftClass(String craftPackage, String className) throws ClassNotFoundException {
            return Class.forName(cpack + (String)(craftPackage.isBlank() ? "" : craftPackage + ".") + className);
        }

        @NotNull
        private static ReflectionAccessor.ClassAccessor getNMSClass(@NotNull ReflectionAccessor reflection, @NotNull String className) throws ClassNotFoundException {
            return reflection.getClass("net.minecraft." + className);
        }

        @NotNull
        private static ReflectionAccessor.ClassAccessor getNMSClass(@NotNull ReflectionAccessor reflection, @NotNull String nmPackage, @NotNull String className) throws ClassNotFoundException {
            return reflection.getClass("net.minecraft." + nmPackage + "." + className);
        }

        static {
            isEnabled = false;
            hasInitialized = false;
            initializationError = null;
            teams = new EnumMap(ChatColor.class);
        }

        private static class TeamData {
            private final String id;
            private final Object creationPacket;
            private final Cache<String, Object> addPackets = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).build();
            private final Cache<String, Object> removePackets = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).build();

            public TeamData(int uid, ChatColor color) throws ReflectiveOperationException {
                if (!color.isColor()) {
                    throw new IllegalArgumentException();
                }
                this.id = "glow-" + uid + color.getChar();
                Object team = createTeam.newInstance(scoreboardDummy, this.id);
                setTeamPush.invoke(team, pushNever);
                setTeamColor.invoke(team, getColorConstant.invoke(null, Character.valueOf(color.getChar())));
                Object packetData = createTeamPacketData.newInstance(team);
                this.creationPacket = createTeamPacket.newInstance(this.id, 0, Optional.of(packetData), Collections.EMPTY_LIST);
            }

            public Object getEntityAddPacket(String teamID) throws ReflectiveOperationException {
                Object packet = this.addPackets.getIfPresent((Object)teamID);
                if (packet == null) {
                    packet = createTeamPacket.newInstance(this.id, 3, Optional.empty(), Arrays.asList(teamID));
                    this.addPackets.put((Object)teamID, packet);
                }
                return packet;
            }

            public Object getEntityRemovePacket(String teamID) throws ReflectiveOperationException {
                Object packet = this.removePackets.getIfPresent((Object)teamID);
                if (packet == null) {
                    packet = createTeamPacket.newInstance(this.id, 4, Optional.empty(), Arrays.asList(teamID));
                    this.removePackets.put((Object)teamID, packet);
                }
                return packet;
            }
        }
    }

    private static class PlayerData {
        final GlowingEntities instance;
        final Player player;
        final Map<Integer, GlowingData> glowingDatas;
        ChannelHandler packetsHandler;
        EnumSet<ChatColor> sentColors;

        PlayerData(GlowingEntities instance, Player player) {
            this.instance = instance;
            this.player = player;
            this.glowingDatas = new HashMap<Integer, GlowingData>();
        }
    }

    private static class GlowingData {
        final PlayerData player;
        final int entityID;
        final String teamID;
        ChatColor color;
        byte otherFlags;
        boolean enabled;

        GlowingData(PlayerData player, int entityID, String teamID, ChatColor color, byte otherFlags) {
            this.player = player;
            this.entityID = entityID;
            this.teamID = teamID;
            this.color = color;
            this.otherFlags = otherFlags;
            this.enabled = true;
        }
    }
}

