/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.hocon.serializers;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigMemorySize;
import java.math.BigInteger;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.hocon.HoconDecoder;
import kotlinx.serialization.hocon.HoconEncoder;
import kotlinx.serialization.hocon.HoconExceptionsKt;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0014\u0010\u0014\u001a\u00020\u0002*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lkotlinx/serialization/hocon/serializers/ConfigMemorySizeSerializer;", "Lkotlinx/serialization/KSerializer;", "Lcom/typesafe/config/ConfigMemorySize;", "<init>", "()V", "memoryUnitFormats", "", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "decodeMemorySize", "Lcom/typesafe/config/Config;", "path", "kotlinx-serialization-hocon"})
public final class ConfigMemorySizeSerializer
implements KSerializer<ConfigMemorySize> {
    @NotNull
    public static final ConfigMemorySizeSerializer INSTANCE = new ConfigMemorySizeSerializer();
    @NotNull
    private static final List<String> memoryUnitFormats;
    @NotNull
    private static final SerialDescriptor descriptor;

    private ConfigMemorySizeSerializer() {
    }

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @Override
    @NotNull
    public ConfigMemorySize deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        if (!(decoder instanceof HoconDecoder)) {
            HoconExceptionsKt.throwUnsupportedFormatException("ConfigMemorySizeSerializer");
            throw new KotlinNothingValueException();
        }
        return ((HoconDecoder)((Object)decoder)).decodeConfigValue(ConfigMemorySizeSerializer::deserialize$lambda$0);
    }

    @Override
    public void serialize(@NotNull Encoder encoder, @NotNull ConfigMemorySize value) {
        int unitIndex;
        BigInteger bytes;
        Intrinsics.checkNotNullParameter(encoder, "encoder");
        Intrinsics.checkNotNullParameter(value, "value");
        if (encoder instanceof HoconEncoder) {
            BigInteger andVal = BigInteger.valueOf(1023L);
            bytes = value.toBytesBigInteger();
            for (unitIndex = 0; Intrinsics.areEqual(bytes.and(andVal), BigInteger.ZERO) && unitIndex < CollectionsKt.getLastIndex(memoryUnitFormats); ++unitIndex) {
                bytes = bytes.shiftRight(10);
            }
        } else {
            HoconExceptionsKt.throwUnsupportedFormatException("ConfigMemorySizeSerializer");
            throw new KotlinNothingValueException();
        }
        encoder.encodeString(bytes + ' ' + memoryUnitFormats.get(unitIndex));
    }

    private final ConfigMemorySize decodeMemorySize(Config $this$decodeMemorySize, String path) {
        ConfigMemorySize configMemorySize;
        try {
            configMemorySize = $this$decodeMemorySize.getMemorySize(path);
            Intrinsics.checkNotNull(configMemorySize);
        }
        catch (ConfigException e) {
            throw new SerializationException("Value at " + path + " cannot be read as ConfigMemorySize because it is not a valid HOCON Size value", e);
        }
        return configMemorySize;
    }

    private static final ConfigMemorySize deserialize$lambda$0(Config conf, String path) {
        Intrinsics.checkNotNullParameter(conf, "conf");
        Intrinsics.checkNotNullParameter(path, "path");
        return INSTANCE.decodeMemorySize(conf, path);
    }

    static {
        String[] stringArray = new String[]{"byte", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"};
        memoryUnitFormats = CollectionsKt.listOf(stringArray);
        descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor("hocon.com.typesafe.config.ConfigMemorySize", PrimitiveKind.STRING.INSTANCE);
    }
}

