/*
 * Decompiled with CFR 0.152.
 */
package me.iris.noxesiumapi.commandapi.arguments;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.iris.noxesiumapi.commandapi.CommandAPIBukkit;
import me.iris.noxesiumapi.commandapi.CommandAPIPaper;
import me.iris.noxesiumapi.commandapi.arguments.CommandAPIArgumentType;
import me.iris.noxesiumapi.commandapi.arguments.SafeOverrideableArgument;
import me.iris.noxesiumapi.commandapi.executors.CommandArguments;

public class AsyncPlayerProfileArgument
extends SafeOverrideableArgument<CompletableFuture<List<PlayerProfile>>, PlayerProfile> {
    public AsyncPlayerProfileArgument(String nodeName) {
        super(nodeName, CommandAPIBukkit.get().getNMS()._ArgumentProfile(), PlayerProfile::getName);
    }

    @Override
    public Class<CompletableFuture<List<PlayerProfile>>> getPrimitiveType() {
        return CompletableFuture.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.ASYNC_OFFLINE_PLAYER;
    }

    @Override
    public <CommandSourceStack> CompletableFuture<List<PlayerProfile>> parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return CommandAPIPaper.getPaper().getNMS().getProfile(cmdCtx, key);
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

