/*
 * Decompiled with CFR 0.152.
 */
package me.iris.noxesiumapi.entityrules;

import com.noxcrew.noxesium.paper.api.EntityRuleManager;
import com.noxcrew.noxesium.paper.api.rule.RemoteServerRule;
import java.awt.Color;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.iris.noxesiumapi.NoxesiumAPI;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0014\u0010\u0010\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0006\u0010\u0011\u001a\u00020\tJ\u0006\u0010\u0012\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/iris/noxesiumapi/entityrules/BeamManager;", "", "entity", "Lorg/bukkit/entity/Entity;", "<init>", "(Lorg/bukkit/entity/Entity;)V", "entityManager", "Lcom/noxcrew/noxesium/paper/api/EntityRuleManager;", "disableBubbles", "", "mode", "", "beamColor", "color", "Ljava/util/Optional;", "Ljava/awt/Color;", "beamFade", "resetBeamColor", "resetBeamFade", "NoxesiumAPI"})
public final class BeamManager {
    @NotNull
    private Entity entity;
    @NotNull
    private final EntityRuleManager entityManager;

    public BeamManager(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        this.entity = entity;
        if (this.entity.getType() != EntityType.GUARDIAN && this.entity.getType() != EntityType.END_CRYSTAL) {
            throw new IllegalArgumentException("Entity must be a (Elder) Guardian or End Crystal");
        }
        this.entityManager = NoxesiumAPI.Companion.getEntityRuleManager();
    }

    public final void disableBubbles(boolean mode) {
        RemoteServerRule<Boolean> rule;
        RemoteServerRule<Boolean> remoteServerRule = rule = this.entityManager.getEntityRule(this.entity, 0);
        Intrinsics.checkNotNull(remoteServerRule);
        remoteServerRule.setValue(mode);
    }

    public final void beamColor(@NotNull Optional<Color> color) {
        RemoteServerRule<Optional<Color>> rule;
        Intrinsics.checkNotNullParameter(color, "color");
        RemoteServerRule<Optional<Color>> remoteServerRule = rule = this.entityManager.getEntityRule(this.entity, 1);
        Intrinsics.checkNotNull(remoteServerRule);
        remoteServerRule.setValue(color);
    }

    public final void beamFade(@NotNull Optional<Color> color) {
        RemoteServerRule<Optional<Color>> rule;
        Intrinsics.checkNotNullParameter(color, "color");
        RemoteServerRule<Optional<Color>> remoteServerRule = rule = this.entityManager.getEntityRule(this.entity, 4);
        Intrinsics.checkNotNull(remoteServerRule);
        remoteServerRule.setValue(color);
    }

    public final void resetBeamColor() {
        RemoteServerRule rule;
        RemoteServerRule remoteServerRule = rule = this.entityManager.getEntityRule(this.entity, 1);
        Intrinsics.checkNotNull(remoteServerRule);
        remoteServerRule.reset();
    }

    public final void resetBeamFade() {
        RemoteServerRule rule;
        RemoteServerRule remoteServerRule = rule = this.entityManager.getEntityRule(this.entity, 4);
        Intrinsics.checkNotNull(remoteServerRule);
        remoteServerRule.reset();
    }
}

