/*
 * Decompiled with CFR 0.152.
 */
package net.manmaed.antiblocksrechiseled.blocks.base;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;

public class AntiPressurePlate
extends PressurePlateBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private final Sensitivity sensitivity;

    public AntiPressurePlate() {
        super(BlockSetType.STONE, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).forceSolidOn().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY).lightLevel(light -> 15));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        this.sensitivity = Sensitivity.PLAYERS;
    }

    protected int getSignalForState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    protected BlockState setSignalForState(BlockState blockState, int power) {
        return (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(power > 0));
    }

    protected int getSignalStrength(Level level, BlockPos blockPos) {
        List list;
        AABB aabb = TOUCH_AABB.move(blockPos);
        switch (this.sensitivity.ordinal()) {
            case 0: {
                list = level.getEntities((Entity)null, aabb);
                break;
            }
            case 2: {
                list = level.getEntitiesOfClass(LivingEntity.class, aabb);
                break;
            }
            case 1: {
                list = level.getEntitiesOfClass(Player.class, aabb);
                break;
            }
            default: {
                return 0;
            }
        }
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.isIgnoringBlockTriggers()) continue;
                return 15;
            }
        }
        return 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{POWERED});
    }

    public static enum Sensitivity {
        EVERYTHING,
        PLAYERS,
        MOBS;

    }
}

