package jerozgen.languagereload.mixin;

import J;
import com.google.common.collect.Maps;
import jerozgen.languagereload.access.ITranslationStorage;
import jerozgen.languagereload.config.Config;
import net.minecraft.class_1078;
import net.minecraft.class_2477;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

@Mixin(class_1078.class)
abstract class TranslationStorageMixin extends class_2477 implements ITranslationStorage {
    @Unique private final Map<Long, String> targetLanguageByThread = Maps.newConcurrentMap();
    @Unique private static Map<String, Map<String, String>> separateTranslationsOnLoad;
    @Unique private Map<String, Map<String, String>> separateTranslations;

    @Inject(method = "<init>", at = @At("RETURN"))
    void onConstructed(Map<String, String> translations, boolean rightToLeft, CallbackInfo ci) {
        separateTranslations = separateTranslationsOnLoad;
        separateTranslationsOnLoad = null;
    }

    @Inject(method = "load(Lnet/minecraft/resource/ResourceManager;Ljava/util/List;Z)Lnet/minecraft/client/resource/language/TranslationStorage;",
            at = @At("HEAD"))
    private static void onLoad(class_3300 resourceManager, List<String> definitions, boolean rightToLeft, CallbackInfoReturnable<class_1078> cir) {
        separateTranslationsOnLoad = Maps.newHashMap();
    }

    @Redirect(method = "load(Ljava/lang/String;Ljava/util/List;Ljava/util/Map;)V", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/util/Language;load(Ljava/io/InputStream;Ljava/util/function/BiConsumer;)V"))
    private static void onInternalLoad$saveSeparately(InputStream inputStream, BiConsumer<String, String> entryConsumer, String langCode) {
        if (Config.getInstance().multilingualItemSearch) {
            class_2477.method_29425(inputStream, entryConsumer.andThen((key, value) ->
                    separateTranslationsOnLoad.computeIfAbsent(langCode, k -> Maps.newHashMap()).put(key, value)));
        } else class_2477.method_29425(inputStream, entryConsumer);
    }

    @Override
    public String languagereload_get(String key) {
        var targetLanguage = languagereload_getTargetLanguage();
        if (targetLanguage != null) {
            var targetTranslations = separateTranslations.get(targetLanguage);
            return targetTranslations == null ? "" : targetTranslations.getOrDefault(key, "");
        }
        return this.method_48307(key);
    }

    @Override
    public @Nullable String languagereload_getTargetLanguage() {
        return targetLanguageByThread.get(Thread.currentThread().threadId());
    }

    @Override
    public void languagereload_setTargetLanguage(@Nullable String value) {
        var threadId = Thread.currentThread().threadId();
        if (value == null) targetLanguageByThread.remove(threadId);
        else targetLanguageByThread.put(threadId, value);
    }
}
