package jerozgen.languagereload.gui;

import jerozgen.languagereload.access.ILanguageOptionsScreen;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_426;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_8012;
import org.jetbrains.annotations.Nullable;

import static org.lwjgl.glfw.GLFW.GLFW_KEY_DOWN;
import static org.lwjgl.glfw.GLFW.GLFW_KEY_ENTER;
import static org.lwjgl.glfw.GLFW.GLFW_KEY_SPACE;
import static org.lwjgl.glfw.GLFW.GLFW_KEY_UP;

public class LanguageListWidget extends class_4280<LanguageEntry> {
    private final class_2561 title;
    private final class_426 screen;

    public LanguageListWidget(class_310 client, class_426 screen, int width, int height, class_2561 title) {
        super(client, width, height - 83 - 16, 32 + 16, 24, (int) (9f * 1.5f));
        this.title = title;
        this.screen = screen;
        field_22744 = false;
    }

    @Override
    protected void method_25312(class_332 context, int x, int y) {
        var headerText = title.method_27661().method_27695(class_124.field_1073, class_124.field_1067);
        int headerPosX = x + field_22758 / 2 - field_22740.field_1772.method_27525(headerText) / 2;
        int headerPosY = Math.min(this.method_46427() + 3, y);
        context.method_27535(field_22740.field_1772, headerText, headerPosX, headerPosY, class_8012.field_42973);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        var selectedEntry = this.method_25334();
        if (selectedEntry == null) return super.method_25404(keyCode, scanCode, modifiers);

        if (keyCode == GLFW_KEY_SPACE || keyCode == GLFW_KEY_ENTER) {
            selectedEntry.toggle();
            this.method_25395(null);
            ((ILanguageOptionsScreen) screen).languagereload_focusEntry(selectedEntry);
            return true;
        }

        if (class_437.method_25442()) {
            if (keyCode == GLFW_KEY_DOWN) {
                selectedEntry.moveDown();
                return true;
            }
            if (keyCode == GLFW_KEY_UP) {
                selectedEntry.moveUp();
                return true;
            }
        }

        return super.method_25404(keyCode, scanCode, modifiers);
    }

    // Remove hovering in scrollbar area
    @Override
    @Nullable
    protected LanguageEntry method_25308(double x, double y) {
        var entry = super.method_25308(x, y);
        return entry != null && this.method_44392() && x >= this.method_65507()
                ? null
                : entry;
    }

    @Override
    protected void method_44398(class_332 context, int y, int entryWidth, int entryHeight, int borderColor, int fillColor) {
        if (this.method_44392()) {
            var x1 = this.method_25342() - 2;
            var x2 = this.method_65507();
            var y1 = y - 2;
            var y2 = y + entryHeight + 2;
            context.method_25294(x1, y1, x2, y2, borderColor);
            context.method_25294(x1 + 1, y1 + 1, x2 - 1, y2 - 1, fillColor);
        } else {
            super.method_44398(context, y, entryWidth, entryHeight, borderColor, fillColor);
        }
    }

    public int getHoveredSelectionRight() {
        return this.method_44392()
                ? this.method_65507()
                : this.method_31383() - 2;
    }

    public class_426 getScreen() {
        return screen;
    }

    public int getRowHeight() {
        return field_22741;
    }

    @Override
    public int method_25322() {
        return field_22758;
    }

    @Override
    protected int method_65507() {
        return this.method_55442() - 6;
    }
}
