package jerozgen.languagereload.mixin;

import jerozgen.languagereload.LanguageReload;
import jerozgen.languagereload.access.ILanguageOptionsScreen;
import jerozgen.languagereload.gui.LanguageEntry;
import jerozgen.languagereload.gui.LanguageListWidget;
import net.minecraft.class_1076;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_315;
import net.minecraft.class_342;
import net.minecraft.class_426;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_7842;
import net.minecraft.class_8016;
import net.minecraft.class_8667;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.*;
import java.util.stream.Stream;

@Mixin(class_426.class)
public abstract class LanguageOptionsScreenMixin extends class_4667 implements ILanguageOptionsScreen {
    @Unique private LanguageListWidget availableLanguageList;
    @Unique private LanguageListWidget selectedLanguageList;
    @Unique private class_342 searchBox;
    @Unique private final LinkedList<String> selectedLanguages = new LinkedList<>();
    @Unique private final Map<String, LanguageEntry> languageEntries = new LinkedHashMap<>();

    @Shadow private class_426.class_4195 languageSelectionList;

    @Inject(method = "<init>", at = @At("TAIL"))
    void onConstructed(class_437 parent, class_315 options, class_1076 languageManager, CallbackInfo ci) {
        selectedLanguages.addAll(LanguageReload.getLanguages());

        var languages = languageManager.method_4665();
        if (languages.isEmpty()) {
            var defaultLanguage = LanguageManagerAccessor.languagereload_getEnglishUs();
            languageEntries.put(class_2477.field_33187, new LanguageEntry(this::refresh, class_2477.field_33187, defaultLanguage, selectedLanguages));
        } else {
            languages.forEach((code, language) -> languageEntries.put(code, new LanguageEntry(this::refresh, code, language, selectedLanguages)));
        }

        field_49503.method_48995(48);
        field_49503.method_48991(53);
    }

    @Inject(method = "initBody", at = @At("HEAD"), cancellable = true)
    void onInitBody(CallbackInfo ci) {
        languageSelectionList = LanguageSelectionListWidgetAccessor.languagereload_init(it(), field_22787);

        var listWidth = Math.min(field_22789 / 2 - 4, 200);
        availableLanguageList = new LanguageListWidget(field_22787, it(), listWidth, field_22790, class_2561.method_43471("pack.available.title"));
        selectedLanguageList = new LanguageListWidget(field_22787, it(), listWidth, field_22790, class_2561.method_43471("pack.selected.title"));
        availableLanguageList.method_46421(field_22789 / 2 - 4 - listWidth);
        selectedLanguageList.method_46421(field_22789 / 2 + 4);
        field_49503.method_48999(availableLanguageList);
        field_49503.method_48999(selectedLanguageList);
        refresh();

        ci.cancel();
    }

    @Override
    protected void method_57732() {
        searchBox = new class_342(field_22793, field_22789 / 2 - 100, 22, 200, 20, searchBox, class_2561.method_43473()) {
            @Override
            public void method_25365(boolean focused) {
                if (!method_25370() && focused) {
                    super.method_25365(true);
                    focusSearch();
                } else super.method_25365(focused);
            }
        };
        searchBox.method_1863(__ -> refresh());

        var header = field_49503.method_48992(class_8667.method_52741().method_52735(5));
        header.method_52740().method_46467();
        header.method_52736(new class_7842(field_22785, field_22793));
        header.method_52736(searchBox);
    }

    @Inject(method = "refreshWidgetPositions", at = @At("HEAD"), cancellable = true)
    protected void onRefreshWidgetPositions(CallbackInfo ci) {
        super.method_48640();

        var listWidth = Math.min(field_22789 / 2 - 4, 200);
        availableLanguageList.method_57712(listWidth, field_49503);
        selectedLanguageList.method_57712(listWidth, field_49503);
        availableLanguageList.method_46421(field_22789 / 2 - 4 - listWidth);
        selectedLanguageList.method_46421(field_22789 / 2 + 4);
        availableLanguageList.method_65506();
        selectedLanguageList.method_65506();

        ci.cancel();
    }

    @Inject(method = "onDone", at = @At("HEAD"), cancellable = true)
    private void onDone(CallbackInfo ci) {
        if (field_22787 == null) return;
        field_22787.method_1507(field_21335);

        var language = selectedLanguages.peekFirst();
        if (language == null) {
            LanguageReload.setLanguage(null);
        } else {
            var fallbacks = new LinkedList<>(selectedLanguages);
            fallbacks.removeFirst();
            LanguageReload.setLanguage(language, fallbacks);
        }

        ci.cancel();
    }

    @Unique
    private void refresh() {
        refreshList(selectedLanguageList, selectedLanguages.stream().map(languageEntries::get).filter(Objects::nonNull));
        refreshList(availableLanguageList, languageEntries.values().stream()
                .filter(entry -> {
                    if (selectedLanguageList.method_25396().contains(entry)) return false;
                    var query = searchBox.method_1882().toLowerCase(Locale.ROOT);
                    var langCode = entry.getCode().toLowerCase(Locale.ROOT);
                    var langName = entry.getLanguage().method_48303().getString().toLowerCase(Locale.ROOT);
                    return langCode.contains(query) || langName.contains(query);
                }));
    }

    @Unique
    private void refreshList(LanguageListWidget list, Stream<? extends LanguageEntry> entries) {
        var selectedEntry = list.method_25334();
        list.method_25313(null);
        list.method_25396().clear();
        entries.forEach(entry -> {
            list.method_25396().add(entry);
            entry.setParent(list);
            if (entry == selectedEntry) {
                list.method_25313(entry);
            }
        });
        list.method_65506();
    }

    @Override
    protected void method_56131() {
        focusSearch();
    }

    @Unique
    private void focusSearch() {
        method_48263(class_8016.method_48194(searchBox, this));
    }

    @Override
    public void languagereload_focusList(LanguageListWidget list) {
        method_48263(class_8016.method_48194(list, this));
    }

    @Override
    public void languagereload_focusEntry(LanguageEntry entry) {
        method_48263(class_8016.method_48194(entry, entry.getParent(), this));
    }

    @Unique
    class_426 it() {
        return (class_426) (Object) this;
    }

    LanguageOptionsScreenMixin(class_437 parent, class_315 options, class_2561 title) {
        super(parent, options, title);
    }
}
