package jerozgen.languagereload.gui;

import jerozgen.languagereload.LanguageReload;
import jerozgen.languagereload.access.ILanguageOptionsScreen;
import jerozgen.languagereload.config.Config;
import net.minecraft.class_1077;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_8000;
import net.minecraft.class_8012;
import net.minecraft.class_8666;
import org.joml.Vector2i;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class LanguageEntry extends LanguageListWidget.Entry {
    private static final class_2561 DEFAULT_LANGUAGE_TOOLTIP = class_2561.method_43471("language.default.tooltip");

    private static final class_8666 ADD_TEXTURES = new class_8666(
            class_2960.method_60655(LanguageReload.MOD_ID, "language_selection/add"),
            class_2960.method_60655(LanguageReload.MOD_ID, "language_selection/add_highlighted"));
    private static final class_8666 REMOVE_TEXTURES = new class_8666(
            class_2960.method_60655(LanguageReload.MOD_ID, "language_selection/remove"),
            class_2960.method_60655(LanguageReload.MOD_ID, "language_selection/remove_highlighted"));
    private static final class_8666 MOVE_UP_TEXTURES = new class_8666(
            class_2960.method_60655(LanguageReload.MOD_ID, "language_selection/move_up"),
            class_2960.method_60655(LanguageReload.MOD_ID, "language_selection/move_up_highlighted"));
    private static final class_8666 MOVE_DOWN_TEXTURES = new class_8666(
            class_2960.method_60655(LanguageReload.MOD_ID, "language_selection/move_down"),
            class_2960.method_60655(LanguageReload.MOD_ID, "language_selection/move_down_highlighted"));

    private final class_310 client = class_310.method_1551();

    private final String code;
    private final class_1077 language;
    private final LinkedList<String> selectedLanguages;
    private final Runnable refreshListsAction;

    private final List<class_339> buttons = new ArrayList<>();
    private final class_4185 addButton = addButton(15, 24, ADD_TEXTURES, __ -> toggle());
    private final class_4185 removeButton = addButton(15, 24, REMOVE_TEXTURES, __ -> toggle());
    private final class_4185 moveUpButton = addButton(11, 11, MOVE_UP_TEXTURES, __ -> moveUp());
    private final class_4185 moveDownButton = addButton(11, 11, MOVE_DOWN_TEXTURES, __ -> moveDown());

    public LanguageEntry(Runnable refreshListsAction, String code, class_1077 language, LinkedList<String> selectedLanguages) {
        this.code = code;
        this.language = language;
        this.selectedLanguages = selectedLanguages;
        this.refreshListsAction = refreshListsAction;
    }

    protected class_4185 addButton(int width, int height, class_8666 textures, class_4185.class_4241 action) {
        var button = new LanguageEntryButtonWidget(width, height, textures, action);
        button.field_22764 = false;
        buttons.add(button);
        return button;
    }

    private boolean isDefault() {
        return code.equals(class_2477.field_33187);
    }

    private boolean isSelected() {
        return selectedLanguages.contains(code);
    }

    private boolean isFirst() {
        return code.equals(selectedLanguages.peekFirst());
    }

    private boolean isLast() {
        return code.equals(selectedLanguages.peekLast());
    }

    public void toggle() {
        if (method_25370()) {
            parentList.method_25395(null);
        }
        if (isSelected()) {
            selectedLanguages.remove(code);
        } else {
            selectedLanguages.addFirst(code);
        }
        refreshListsAction.run();
        ((ILanguageOptionsScreen) parentList.getScreen()).languagereload_focusEntry(this);
    }

    public void moveUp() {
        if (!isSelected()) return;
        if (isFirst()) return;
        var index = selectedLanguages.indexOf(code);
        selectedLanguages.add(index - 1, selectedLanguages.remove(index));
        refreshListsAction.run();
    }

    public void moveDown() {
        if (!isSelected()) return;
        if (isLast()) return;
        var index = selectedLanguages.indexOf(code);
        selectedLanguages.add(index + 1, selectedLanguages.remove(index));
        refreshListsAction.run();
    }

    @Override
    public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
        var x = this.method_46426();
        var y = this.method_46427();
        if (hovered || method_25370() || client.field_1690.method_42446().method_41753()) {
            var x1 = x + 1;
            var y1 = y + 1;
            var x2 = parentList.getHoveredSelectionRight() - 1;
            var y2 = y + this.method_25364() - 1;
            context.method_25294(x1, y1, x2, y2, (hovered || method_25370()) ? 0xA0909090 : 0x50909090);
            buttons.forEach(button -> button.field_22764 = false);
            renderButtons((button, buttonX, buttonY) -> {
                button.method_46421(buttonX);
                button.method_46419(buttonY);
                button.field_22764 = true;
                button.method_25394(context, mouseX, mouseY, deltaTicks);
            }, x, y);
            if ((hovered || method_25370()) && isDefault()) {
                renderDefaultLanguageTooltip(context, x, y);
            }
        }
        context.method_25303(client.field_1772, language.comp_1199(), x + 29, y + 3, class_8012.field_42973);
        context.method_25303(client.field_1772, language.comp_1198(), x + 29, y + 14, class_8012.field_44941);
    }

    private void renderButtons(ButtonRenderer renderer, int x, int y) {
        if (isSelected()) {
            if (!isDefault() || Config.getInstance().removableDefaultLanguage) renderer.render(removeButton, x, y);
            if (!isFirst()) renderer.render(moveUpButton, x + removeButton.method_25368() + 1, y);
            if (!isLast()) renderer.render(moveDownButton, x + removeButton.method_25368() + 1, y + moveUpButton.method_25364() + 2);
        } else renderer.render(addButton, x + 7, y);
    }

    private void renderDefaultLanguageTooltip(class_332 context, int x, int y) {
        var tooltip = client.field_1772.method_1728(DEFAULT_LANGUAGE_TOOLTIP, parentList.method_25322() - 6);
        class_8000 positioner = (screenWidth, screenHeight, mouseX, mouseY, width, height) -> {
            var pos = new Vector2i(
                    x + 3 + (parentList.method_25322() - width - 6) / 2,
                    y + parentList.getRowHeight() + 4);
            if (pos.y > parentList.method_55443() + 2 || pos.y + height + 5 > screenHeight)
                pos.y = y - height - 6;
            return pos;
        };
        context.method_51436(client.field_1772, tooltip, positioner, 0, 0, true);
    }

    @Override
    public boolean method_25404(class_11908 input) {
        if (input.method_74230() && (!isDefault() || Config.getInstance().removableDefaultLanguage)) {
            this.toggle();
            return true;
        }
        if (input.method_74239()) {
            if (input.method_74234()) {
                this.moveUp();
                return true;
            }
            if (input.method_74235()) {
                this.moveDown();
                return true;
            }
        }
        return super.method_25404(input);
    }

    @Override
    public class_2561 method_37006() {
        return class_2561.method_43469("narrator.select", language.method_48303());
    }

    @Override
    public boolean method_25402(class_11909 click, boolean doubled) {
        for (var widget : buttons)
            if (widget.method_25402(click, doubled)) {
                return true;
            }
        return false;
    }

    @Override
    public String getCode() {
        return code;
    }

    public class_1077 getLanguage() {
        return language;
    }

    @FunctionalInterface
    private interface ButtonRenderer {
        void render(class_4185 button, int x, int y);
    }
}
