package jerozgen.languagereload.gui;

import org.jetbrains.annotations.Nullable;

import java.util.stream.Stream;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_426;
import net.minecraft.class_4280;
import net.minecraft.class_8012;

public class LanguageListWidget extends class_4280<LanguageListWidget.Entry> {
    private final HeaderEntry headerEntry;
    private final class_426 screen;

    public LanguageListWidget(class_310 client, class_426 screen, int width, int height, class_2561 title) {
        super(client, width, height - 83 - 16, 32 + 16, 24);
        this.screen = screen;
        this.headerEntry = new HeaderEntry(
                client.field_1772,
                class_2561.method_43473().method_10852(title).method_27695(class_124.field_1073, class_124.field_1067)
        );
        field_22744 = false;
    }

    public void set(Stream<? extends Entry> entries) {
        this.method_25339();
        this.addEntry(headerEntry, (int) (9f * 1.5f));
        entries.forEach(this::method_25321);
        this.method_65506();
    }

    @Override
    protected int addEntry(Entry entry, int entryHeight) {
        entry.setParent(this);
        return super.method_73370(entry, entryHeight);
    }

    // Remove hovering in scrollbar area
    @Override
    @Nullable
    protected Entry method_25308(double x, double y) {
        var entry = super.method_25308(x, y);
        return entry != null && this.method_44392() && x >= this.method_65507()
                ? null
                : entry;
    }

    @Override
    protected void drawSelectionHighlight(class_332 context, Entry entry, int color) {
        if (this.method_44392()) {
            var x1 = entry.method_46426();
            var y1 = entry.method_46427();
            var x2 = this.method_65507();
            var y2 = y1 + entry.method_25364();
            context.method_25294(x1, y1, x2, y2, color);
            context.method_25294(x1 + 1, y1 + 1, x2 - 1, y2 - 1, class_8012.field_42974);
        } else {
            super.method_44398(context, entry, color);
        }
    }

    public int getHoveredSelectionRight() {
        return this.method_44392()
                ? this.method_65507()
                : this.method_31383();
    }

    public class_426 getScreen() {
        return screen;
    }

    public int getRowHeight() {
        return field_62109;
    }

    @Override
    public int method_25322() {
        return field_22758;
    }

    @Override
    protected int method_65507() {
        return this.method_55442() - 6;
    }

    @Override
    public boolean method_25404(class_11908 input) {
        var selectedEntry = this.method_25334();
        return selectedEntry != null
                ? selectedEntry.method_25404(input)
                : super.method_25404(input);
    }

    public abstract static class Entry extends class_4280.class_4281<LanguageListWidget.Entry> {
        protected LanguageListWidget parentList;

        public void setParent(LanguageListWidget list) {
            this.parentList = list;
        }

        public LanguageListWidget getParent() {
            return parentList;
        }

        public abstract String getCode();
    }
}
