package jerozgen.languagereload.mixin;

import jerozgen.languagereload.LanguageReload;
import jerozgen.languagereload.config.Config;
import net.minecraft.class_1077;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_309;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.Objects;

@Mixin(class_309.class)
public abstract class KeyboardMixin {
    @Shadow @Final private class_310 client;
    @Shadow private boolean switchF3State;

    @Shadow protected abstract void sendMessage(class_2561 message);
    @Shadow protected abstract void debugError(class_2561 message);
    @Shadow protected abstract void debugLog(class_2561 text);
    @Shadow protected abstract void debugLog(String key);

    @Unique
    private void processLanguageReloadKeys(class_11908 input) {
        if (input.method_74239()) {
            var config = Config.getInstance();
            var languageManager = client.method_1526();

            var language = languageManager.method_4668(config.previousLanguage);
            if (language == null && config.previousLanguage.equals(class_2477.field_33187)) {
                language = LanguageManagerAccessor.languagereload_getEnglishUs();
            }
            var noLanguage = config.previousLanguage.equals(LanguageReload.NO_LANGUAGE);
            if (language == null && !noLanguage) {
                this.debugError(class_2561.method_43471("debug.reload_languages.switch.failure"));
            } else {
                LanguageReload.setLanguage(config.previousLanguage, config.previousFallbacks);
                var languages = new ArrayList<class_2561>();
                if (noLanguage) {
                    languages.add(class_2561.method_30163("∅"));
                }
                if (language != null) {
                    languages.add(language.method_48303());
                }
                languages.addAll(config.fallbacks.stream()
                        .map(languageManager::method_4668)
                        .filter(Objects::nonNull)
                        .map(class_1077::method_48303)
                        .toList());
                this.debugLog(class_2561.method_43469("debug.reload_languages.switch.success", class_2564.method_37112(languages, class_2561.method_30163(", "))));
            }
        } else {
            LanguageReload.reloadLanguages();
            this.debugLog("debug.reload_languages.message");
        }
    }

    @Inject(method = "processF3", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/client/Keyboard;sendMessage(Lnet/minecraft/text/Text;)V",
            ordinal = 6, shift = At.Shift.AFTER))
    private void onProcessF3$addHelp(class_11908 keyInput, CallbackInfoReturnable<Boolean> cir) {
        this.sendMessage(class_2561.method_43471("debug.reload_languages.help"));
    }

    @Inject(method = "processF3", at = @At("RETURN"), cancellable = true)
    private void onProcessF3(class_11908 keyInput, CallbackInfoReturnable<Boolean> cir) {
        if (keyInput.comp_4795() == GLFW.GLFW_KEY_J) {
            processLanguageReloadKeys(keyInput);
            cir.setReturnValue(true);
        }
    }

    @Inject(method = "onKey", at = @At(value = "FIELD", target = "Lnet/minecraft/client/Keyboard;debugCrashStartTime:J", ordinal = 0), cancellable = true)
    private void onOnKey(long window, int action, class_11908 input, CallbackInfo ci) {
        var clientWindow = client.method_22683();
        if (client.field_1755 != null && class_3675.method_15987(clientWindow, GLFW.GLFW_KEY_F3) && input.comp_4795() == GLFW.GLFW_KEY_J) {
            this.switchF3State = true;
            if (action != class_3675.field_31998) {
                processLanguageReloadKeys(input);
            }
            ci.cancel();
        }
    }

    @Inject(method = "onChar", at = @At("HEAD"), cancellable = true)
    private void onOnChar(long window, class_11905 input, CallbackInfo ci) {
        var clientWindow = client.method_22683();
        if (class_3675.method_15987(clientWindow, GLFW.GLFW_KEY_F3) && class_3675.method_15987(clientWindow, GLFW.GLFW_KEY_J)) {
            ci.cancel();
        }
    }
}
