package jerozgen.languagereload;

import jerozgen.languagereload.access.IAdvancementsScreen;
import jerozgen.languagereload.config.Config;
import jerozgen.languagereload.mixin.*;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1076;
import net.minecraft.class_1124;
import net.minecraft.class_1297;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3872;
import net.minecraft.class_457;
import net.minecraft.class_8113;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import Z;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReferenceArray;

@Environment(EnvType.CLIENT)
public class LanguageReload {
    public static final Logger LOGGER = LogManager.getLogger("Language Reload");
    public static final String MOD_ID = "languagereload";

    public static final String NO_LANGUAGE = "*";

    public static boolean shouldSetSystemLanguage = false;

    public static void reloadLanguages() {
        var client = class_310.method_1551();

        // Reload language and search managers
        client.method_1526().method_14491(client.method_1478());
        reloadSearch();

        // Update window title and chat
        client.method_24288();
        client.field_1705.method_1743().method_1817();

        // Update book and advancements screens
        if (client.field_1755 instanceof class_3872 bookScreen) {
            ((BookScreenAccessor) bookScreen).languagereload_setCachedPageIndex(-1);
        } else if (client.field_1755 instanceof class_457 advancementsScreen) {
            ((IAdvancementsScreen) advancementsScreen).languagereload_recreateWidgets();
        }

        if (client.field_1687 != null) {
            // Update signs
            var chunkManager = (ClientChunkManagerAccessor) client.field_1687.method_2935();
            var chunks = ((ClientChunkMapAccessor) chunkManager.languagereload_getChunks()).languagereload_getChunks();
            for (int i = 0; i < chunks.length(); i++) {
                var chunk = chunks.get(i);
                if (chunk == null) continue;
                for (var blockEntity : chunk.method_12214().values()) {
                    if (!(blockEntity instanceof class_2625 sign)) continue;
                    ((SignTextAccessor) sign.method_49853()).languagereload_setOrderedMessages(null);
                    ((SignTextAccessor) sign.method_49854()).languagereload_setOrderedMessages(null);
                }
            }

            // Update text displays
            for (var entity : client.field_1687.method_18112()) {
                if (entity instanceof class_8113.class_8123 textDisplay) {
                    ((TextDisplayEntityAccessor) textDisplay).languagereload_setTextLines(null);
                }
            }
        }
    }

    public static void reloadSearch() {
        var client = class_310.method_1551();
        var searchManager = ((MinecraftClientAccessor) client).languagereload_getSearchManager();
        searchManager.method_14491(client.method_1478());
    }

    public static void setLanguage(String language, LinkedList<String> fallbacks) {
        var client = class_310.method_1551();
        var languageManager = client.method_1526();
        var config = Config.getInstance();

        var languageIsSame = languageManager.method_4669().equals(language);
        var fallbacksAreSame = config.fallbacks.equals(fallbacks);
        if (languageIsSame && fallbacksAreSame) return;

        config.previousLanguage = languageManager.method_4669();
        config.previousFallbacks = config.fallbacks;
        config.language = language;
        config.fallbacks = fallbacks;
        Config.save();

        languageManager.method_4667(language);
        client.field_1690.field_1883 = language;
        client.field_1690.method_1640();

        reloadLanguages();
    }
}