package jerozgen.languagereload.mixin;

import I;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import jerozgen.languagereload.LanguageReload;
import jerozgen.languagereload.access.ILanguageOptionsScreen;
import jerozgen.languagereload.config.Config;
import jerozgen.languagereload.gui.LanguageEntry;
import jerozgen.languagereload.gui.LanguageListWidget;
import net.minecraft.class_1076;
import net.minecraft.class_2561;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_426;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_5244;
import net.minecraft.class_8016;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.*;
import java.util.stream.Stream;

@Mixin(class_426.class)
public abstract class LanguageOptionsScreenMixin extends class_4667 implements ILanguageOptionsScreen {
    @Shadow @Final private static class_2561 LANGUAGE_WARNING_TEXT;
    @Shadow private class_426.class_4195 languageSelectionList;

    @Unique private LanguageListWidget availableLanguageList;
    @Unique private LanguageListWidget selectedLanguageList;
    @Unique private class_342 searchBox;
    @Unique private final LinkedList<String> selectedLanguages = new LinkedList<>();
    @Unique private final Map<String, LanguageEntry> languageEntries = new LinkedHashMap<>();

    LanguageOptionsScreenMixin(class_437 parent, class_315 options, class_2561 title) {
        super(parent, options, title);
    }

    @Unique
    private class_426 it() {
        return (class_426) (Object) this;
    }

    @Inject(method = "<init>", at = @At("TAIL"))
    void onConstructed(class_437 parent, class_315 options, class_1076 languageManager, CallbackInfo ci) {
        var currentLangCode = languageManager.method_4669();
        if (!currentLangCode.equals(LanguageReload.NO_LANGUAGE))
            selectedLanguages.add(currentLangCode);
        selectedLanguages.addAll(Config.getInstance().fallbacks);
        languageManager.method_4665().forEach((code, language) ->
                languageEntries.put(code, new LanguageEntry(this::refresh, code, language, selectedLanguages)));
    }

    @Inject(method = "init", at = @At("HEAD"), cancellable = true)
    void onInit(CallbackInfo ci) {
        languageSelectionList = LanguageSelectionListWidgetAccessor.languagereload_init(it(), field_22787);

        searchBox = new class_342(field_22793, field_22789 / 2 - 100, 22, 200, 20, searchBox, class_2561.method_43473()) {
            @Override
            public void method_25365(boolean focused) {
                if (!method_25370() && focused) {
                    super.method_25365(true);
                    focusSearch();
                } else super.method_25365(focused);
            }
        };
        searchBox.method_1863(__ -> refresh());
        method_25429(searchBox);
        method_48265(searchBox);

        var listWidth = Math.min(field_22789 / 2 - 4, 200);
        availableLanguageList = new LanguageListWidget(field_22787, it(), listWidth, field_22790, class_2561.method_43471("pack.available.title"));
        selectedLanguageList = new LanguageListWidget(field_22787, it(), listWidth, field_22790, class_2561.method_43471("pack.selected.title"));
        availableLanguageList.method_25333(field_22789 / 2 - 4 - listWidth);
        selectedLanguageList.method_25333(field_22789 / 2 + 4);
        method_25429(availableLanguageList);
        method_25429(selectedLanguageList);
        refresh();

        method_37063(field_21336.method_42437().method_18520(field_21336, field_22789 / 2 - 155, field_22790 - 28, 150));
        method_37063(class_4185.method_46430(class_5244.field_24334, this::onDone)
                .method_46434(field_22789 / 2 - 155 + 160, field_22790 - 28, 150, 20)
                .method_46431());

        super.method_25426();
        ci.cancel();
    }

    @Unique
    private void onDone(class_4185 button) {
        if (field_22787 == null) return;
        field_22787.method_1507(field_21335);

        var language = selectedLanguages.peekFirst();
        if (language == null) {
            LanguageReload.setLanguage(LanguageReload.NO_LANGUAGE, new LinkedList<>());
        } else {
            var fallbacks = new LinkedList<>(selectedLanguages);
            fallbacks.removeFirst();
            LanguageReload.setLanguage(language, fallbacks);
        }
    }

    @Override
    public void languagereload_focusList(LanguageListWidget list) {
        method_48263(class_8016.method_48194(list, this));
    }

    @Override
    public void languagereload_focusEntry(LanguageEntry entry) {
        method_48263(class_8016.method_48194(entry, entry.getParent(), this));
    }

    @Unique
    private void focusSearch() {
        method_48263(class_8016.method_48194(searchBox, this));
    }

    @Unique
    private void refresh() {
        refreshList(selectedLanguageList, selectedLanguages.stream().map(languageEntries::get).filter(Objects::nonNull));
        refreshList(availableLanguageList, languageEntries.values().stream()
                .filter(entry -> {
                    if (selectedLanguageList.method_25396().contains(entry)) return false;
                    var query = searchBox.method_1882().toLowerCase(Locale.ROOT);
                    var langCode = entry.getCode().toLowerCase(Locale.ROOT);
                    var langName = entry.getLanguage().method_48303().getString().toLowerCase(Locale.ROOT);
                    return langCode.contains(query) || langName.contains(query);
                }));
    }

    @Unique
    private void refreshList(LanguageListWidget list, Stream<? extends LanguageEntry> entries) {
        var selectedEntry = list.method_25334();
        list.method_25313(null);
        list.method_25396().clear();
        entries.forEach(entry -> {
            list.method_25396().add(entry);
            entry.setParent(list);
            if (entry == selectedEntry) {
                list.method_25313(entry);
            }
        });
        list.method_25307(list.method_25341());
    }

    @Inject(method = "render", at = @At("HEAD"), cancellable = true)
    void onRender(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        method_25434(context);

        availableLanguageList.method_25394(context, mouseX, mouseY, delta);
        selectedLanguageList.method_25394(context, mouseX, mouseY, delta);
        searchBox.method_25394(context, mouseX, mouseY, delta);

        context.method_27534(field_22793, field_22785, field_22789 / 2, 8, 0xFFFFFF);
        context.method_27534(field_22793, LANGUAGE_WARNING_TEXT, field_22789 / 2, field_22790 - 46, 0x808080);

        super.method_25394(context, mouseX, mouseY, delta);
        ci.cancel();
    }

    @Override
    public void method_25393() {
        searchBox.method_1865();
    }

    @ModifyExpressionValue(method = "keyPressed", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/input/KeyCodes;isToggle(I)Z"))
    boolean disableVanillaSelectWithToggleKeys(boolean ignoredOriginal) {
        return false;
    }
}
