package jerozgen.languagereload.mixin;

import jerozgen.languagereload.LanguageReload;
import jerozgen.languagereload.config.Config;
import net.minecraft.class_1076;
import net.minecraft.class_1077;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_309;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import Z;
import java.util.ArrayList;
import java.util.Objects;

@Mixin(class_309.class)
public abstract class KeyboardMixin {
    @Shadow @Final private class_310 client;

    @Shadow
    protected abstract void debugLog(String key, Object... args);

    @Shadow
    protected abstract void debugError(String key, Object... args);

    @Unique
    private void processLanguageReloadKeys() {
        if (class_437.method_25442()) {
            var config = Config.getInstance();
            var languageManager = client.method_1526();

            var language = languageManager.method_4668(config.previousLanguage);
            if (language == null && config.previousLanguage.equals(class_2477.field_33187)) {
                language = LanguageManagerAccessor.languagereload_getEnglishUs();
            }
            var noLanguage = config.previousLanguage.equals(LanguageReload.NO_LANGUAGE);
            if (language == null && !noLanguage) {
                debugError("debug.reload_languages.switch.failure");
            } else {
                LanguageReload.setLanguage(config.previousLanguage, config.previousFallbacks);
                var languages = new ArrayList<class_2561>();
                if (noLanguage) {
                    languages.add(class_2561.method_30163("∅"));
                }
                if (language != null) {
                    languages.add(language.method_48303());
                }
                languages.addAll(config.fallbacks.stream()
                        .map(languageManager::method_4668)
                        .filter(Objects::nonNull)
                        .map(class_1077::method_48303)
                        .toList());
                debugLog("debug.reload_languages.switch.success", class_2564.method_37112(languages, class_2561.method_30163(", ")));
            }
        } else {
            LanguageReload.reloadLanguages();
            debugLog("debug.reload_languages.message");
        }
    }

    @Inject(method = "processF3", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/client/gui/hud/ChatHud;addMessage(Lnet/minecraft/text/Text;)V",
            ordinal = 6, shift = At.Shift.AFTER))
    private void onProcessF3$addHelp(int key, CallbackInfoReturnable<Boolean> cir) {
        client.field_1705.method_1743().method_1812(class_2561.method_43471("debug.reload_languages.help"));
    }

    @Inject(method = "processF3", at = @At("RETURN"), cancellable = true)
    private void onProcessF3(int key, CallbackInfoReturnable<Boolean> cir) {
        if (key == GLFW.GLFW_KEY_J) {
            processLanguageReloadKeys();
            cir.setReturnValue(true);
        }
    }

    @Inject(method = "onKey", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/client/gui/screen/Screen;wrapScreenError(Ljava/lang/Runnable;Ljava/lang/String;Ljava/lang/String;)V"),
            cancellable = true)
    private void onOnKey(long window, int key, int scancode, int action, int modifiers, CallbackInfo ci) {
        if (class_3675.method_15987(window, GLFW.GLFW_KEY_F3) && key == GLFW.GLFW_KEY_J) {
            if (action != 0)
                processLanguageReloadKeys();
            ci.cancel();
        }
    }

    @Inject(method = "onChar", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/client/gui/screen/Screen;wrapScreenError(Ljava/lang/Runnable;Ljava/lang/String;Ljava/lang/String;)V",
            ordinal = 0), cancellable = true)
    private void onOnChar(long window, int codePoint, int modifiers, CallbackInfo ci) {
        if (class_3675.method_15987(window, GLFW.GLFW_KEY_F3) && class_3675.method_15987(window, GLFW.GLFW_KEY_J)) {
            ci.cancel();
        }
    }
}
