package jerozgen.languagereload;

import jerozgen.languagereload.access.IAdvancementsScreen;
import jerozgen.languagereload.config.Config;
import jerozgen.languagereload.mixin.*;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1076;
import net.minecraft.class_1124;
import net.minecraft.class_1297;
import net.minecraft.class_2477;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3872;
import net.minecraft.class_457;
import net.minecraft.class_8113;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import Z;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReferenceArray;

@Environment(EnvType.CLIENT)
public class LanguageReload {
    public static final Logger LOGGER = LogManager.getLogger("Language Reload");
    public static final String MOD_ID = "languagereload";

    public static final String NO_LANGUAGE = "*";

    public static boolean shouldSetSystemLanguage = false;

    public static void reloadLanguages() {
        var client = class_310.method_1551();

        // Reload language and search managers
        client.method_1526().method_14491(client.method_1478());
        reloadSearch();

        // Update window title and chat
        client.method_24288();
        client.field_1705.method_1743().method_1817();

        // Update book and advancements screens
        if (client.field_1755 instanceof class_3872 bookScreen) {
            ((BookScreenAccessor) bookScreen).languagereload_setCachedPageIndex(-1);
        } else if (client.field_1755 instanceof class_457 advancementsScreen) {
            ((IAdvancementsScreen) advancementsScreen).languagereload_recreateWidgets();
        }

        if (client.field_1687 != null) {
            // Update signs
            var chunkManager = (ClientChunkManagerAccessor) client.field_1687.method_2935();
            var chunks = ((ClientChunkMapAccessor) chunkManager.languagereload_getChunks()).languagereload_getChunks();
            for (int i = 0; i < chunks.length(); i++) {
                var chunk = chunks.get(i);
                if (chunk == null) continue;
                for (var blockEntity : chunk.method_12214().values()) {
                    if (!(blockEntity instanceof class_2625 sign)) continue;
                    ((SignTextAccessor) sign.method_49853()).languagereload_setOrderedMessages(null);
                    ((SignTextAccessor) sign.method_49854()).languagereload_setOrderedMessages(null);
                }
            }

            // Update text displays
            for (var entity : client.field_1687.method_18112()) {
                if (entity instanceof class_8113.class_8123 textDisplay) {
                    ((TextDisplayEntityAccessor) textDisplay).languagereload_setTextLines(null);
                }
            }
        }
    }

    public static void reloadSearch() {
        var client = class_310.method_1551();
        var searchManager = ((MinecraftClientAccessor) client).languagereload_getSearchManager();
        searchManager.method_14491(client.method_1478());
    }

    public static void setLanguage(@Nullable String language) {
        if (language == null || language.equals(NO_LANGUAGE)) {
            setLanguage(NO_LANGUAGE, null);
        } else if (language.equals(class_2477.field_33187)) {
            setLanguage(class_2477.field_33187, null);
        } else {
            setLanguage(language, new LinkedList<>() {{ add(class_2477.field_33187); }});
        }
    }

    public static void setLanguage(
            @Nullable String language,
            @Nullable LinkedList<@NotNull String> fallbacks
    ) {
        var newLanguage = language == null ? NO_LANGUAGE : language;
        var newFallbacks = fallbacks == null ? new LinkedList<String>() : fallbacks;
        var client = class_310.method_1551();
        var languageManager = client.method_1526();
        var config = Config.getInstance();

        var languageIsSame = languageManager.method_4669().equals(newLanguage);
        var fallbacksAreSame = config.fallbacks.equals(newFallbacks);
        if (languageIsSame && fallbacksAreSame) return;

        config.previousLanguage = languageManager.method_4669();
        config.previousFallbacks = config.fallbacks;
        config.language = newLanguage;
        config.fallbacks = newFallbacks;
        Config.save();

        languageManager.method_4667(newLanguage);
        client.field_1690.field_1883 = newLanguage;
        client.field_1690.method_1640();

        reloadLanguages();
    }

    public static @NotNull LinkedList<@NotNull String> getLanguages() {
        var list = new LinkedList<String>();
        var language = class_310.method_1551().method_1526().method_4669();
        if (!language.equals(LanguageReload.NO_LANGUAGE)) {
            list.add(language);
        }
        list.addAll(Config.getInstance().fallbacks);
        return list;
    }
}