/*
 * Decompiled with CFR 0.152.
 */
package jerozgen.languagereload.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.stream.Stream;
import jerozgen.languagereload.LanguageReload;
import jerozgen.languagereload.access.ILanguageOptionsScreen;
import jerozgen.languagereload.gui.LanguageEntry;
import jerozgen.languagereload.gui.LanguageListWidget;
import jerozgen.languagereload.mixin.LanguageManagerAccessor;
import jerozgen.languagereload.mixin.LanguageSelectionListWidgetAccessor;
import net.minecraft.class_1076;
import net.minecraft.class_1077;
import net.minecraft.class_2561;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_4185;
import net.minecraft.class_426;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_5244;
import net.minecraft.class_8016;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_426.class})
public abstract class LanguageOptionsScreenMixin
extends class_4667
implements ILanguageOptionsScreen {
    @Shadow
    @Final
    private static class_2561 field_26543;
    @Shadow
    private class_426.class_4195 field_2486;
    @Unique
    private LanguageListWidget availableLanguageList;
    @Unique
    private LanguageListWidget selectedLanguageList;
    @Unique
    private class_342 searchBox;
    @Unique
    private final LinkedList<String> selectedLanguages = new LinkedList();
    @Unique
    private final Map<String, LanguageEntry> languageEntries = new LinkedHashMap<String, LanguageEntry>();

    LanguageOptionsScreenMixin(class_437 parent, class_315 options, class_2561 title) {
        super(parent, options, title);
    }

    @Unique
    private class_426 it() {
        return (class_426)this;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    void onConstructed(class_437 parent, class_315 options, class_1076 languageManager, CallbackInfo ci) {
        this.selectedLanguages.addAll(LanguageReload.getLanguages());
        SortedMap languages = languageManager.method_4665();
        if (languages.isEmpty()) {
            class_1077 defaultLanguage = LanguageManagerAccessor.languagereload_getEnglishUs();
            this.languageEntries.put("en_us", new LanguageEntry(this::refresh, "en_us", defaultLanguage, this.selectedLanguages));
        } else {
            languages.forEach((code, language) -> this.languageEntries.put((String)code, new LanguageEntry(this::refresh, (String)code, (class_1077)language, this.selectedLanguages)));
        }
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    void onInit(CallbackInfo ci) {
        this.field_2486 = LanguageSelectionListWidgetAccessor.languagereload_init(this.it(), this.field_22787);
        this.searchBox = new class_342(this.field_22793, this.field_22789 / 2 - 100, 22, 200, 20, this.searchBox, (class_2561)class_2561.method_43473()){

            public void method_25365(boolean focused) {
                if (!this.method_25370() && focused) {
                    super.method_25365(true);
                    LanguageOptionsScreenMixin.this.focusSearch();
                } else {
                    super.method_25365(focused);
                }
            }
        };
        this.searchBox.method_1863(__ -> this.refresh());
        this.method_25429((class_364)this.searchBox);
        this.method_48265((class_364)this.searchBox);
        int listWidth = Math.min(this.field_22789 / 2 - 4, 200);
        this.availableLanguageList = new LanguageListWidget(this.field_22787, this.it(), listWidth, this.field_22790, (class_2561)class_2561.method_43471((String)"pack.available.title"));
        this.selectedLanguageList = new LanguageListWidget(this.field_22787, this.it(), listWidth, this.field_22790, (class_2561)class_2561.method_43471((String)"pack.selected.title"));
        this.availableLanguageList.method_25333(this.field_22789 / 2 - 4 - listWidth);
        this.selectedLanguageList.method_25333(this.field_22789 / 2 + 4);
        this.method_25429((class_364)this.availableLanguageList);
        this.method_25429((class_364)this.selectedLanguageList);
        this.refresh();
        this.method_37063((class_364)this.field_21336.method_42437().method_18520(this.field_21336, this.field_22789 / 2 - 155, this.field_22790 - 28, 150));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, this::onDone).method_46434(this.field_22789 / 2 - 155 + 160, this.field_22790 - 28, 150, 20).method_46431());
        super.method_25426();
        ci.cancel();
    }

    @Unique
    private void onDone(class_4185 button) {
        if (this.field_22787 == null) {
            return;
        }
        this.field_22787.method_1507(this.field_21335);
        String language = this.selectedLanguages.peekFirst();
        if (language == null) {
            LanguageReload.setLanguage(null);
        } else {
            LinkedList<String> fallbacks = new LinkedList<String>(this.selectedLanguages);
            fallbacks.remove(0);
            LanguageReload.setLanguage(language, fallbacks);
        }
    }

    @Override
    public void languagereload_focusList(LanguageListWidget list) {
        this.method_48263(class_8016.method_48194((class_364)list, (class_4069[])new class_4069[]{this}));
    }

    @Override
    public void languagereload_focusEntry(LanguageEntry entry) {
        this.method_48263(class_8016.method_48194((class_364)entry, (class_4069[])new class_4069[]{entry.getParent(), this}));
    }

    @Unique
    private void focusSearch() {
        this.method_48263(class_8016.method_48194((class_364)this.searchBox, (class_4069[])new class_4069[]{this}));
    }

    @Unique
    private void refresh() {
        this.refreshList(this.selectedLanguageList, this.selectedLanguages.stream().map(this.languageEntries::get).filter(Objects::nonNull));
        this.refreshList(this.availableLanguageList, this.languageEntries.values().stream().filter(entry -> {
            if (this.selectedLanguageList.method_25396().contains(entry)) {
                return false;
            }
            String query = this.searchBox.method_1882().toLowerCase(Locale.ROOT);
            String langCode = entry.getCode().toLowerCase(Locale.ROOT);
            String langName = entry.getLanguage().method_48303().getString().toLowerCase(Locale.ROOT);
            return langCode.contains(query) || langName.contains(query);
        }));
    }

    @Unique
    private void refreshList(LanguageListWidget list, Stream<? extends LanguageEntry> entries) {
        LanguageEntry selectedEntry = (LanguageEntry)list.method_25334();
        list.method_25313(null);
        list.method_25396().clear();
        entries.forEach(entry -> {
            list.method_25396().add(entry);
            entry.setParent(list);
            if (entry == selectedEntry) {
                list.method_25313((class_350.class_351)entry);
            }
        });
        list.method_25307(list.method_25341());
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    void onRender(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.availableLanguageList.method_25394(context, mouseX, mouseY, delta);
        this.selectedLanguageList.method_25394(context, mouseX, mouseY, delta);
        this.searchBox.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
        context.method_27534(this.field_22793, field_26543, this.field_22789 / 2, this.field_22790 - 46, 0x808080);
        ci.cancel();
    }

    @ModifyExpressionValue(method={"keyPressed"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/input/KeyCodes;isToggle(I)Z")})
    boolean disableVanillaSelectWithToggleKeys(boolean ignoredOriginal) {
        return false;
    }
}

