package jerozgen.languagereload.gui;

import jerozgen.languagereload.access.ILanguageOptionsScreen;
import jerozgen.languagereload.mixin.EntryListWidgetAccessor;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4069;
import net.minecraft.class_426;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

import static org.lwjgl.glfw.GLFW.*;

public class LanguageListWidget extends class_4280<LanguageEntry> {
    private final class_2561 title;
    private final class_426 screen;

    public LanguageListWidget(class_310 client, class_426 screen, int width, int height, class_2561 title) {
        super(client, width, height - 83 - 16, 32 + 16, 24);
        this.title = title;
        this.screen = screen;

        method_25315(true, (int) (9f * 1.5f));
        field_22744 = false;
    }

    @Override
    protected void method_25312(class_332 context, int x, int y) {
        var headerText = title.method_27661().method_27695(class_124.field_1073, class_124.field_1067);
        int headerPosX = x + field_22758 / 2 - field_22740.field_1772.method_27525(headerText) / 2;
        int headerPosY = Math.min(this.method_46427() + 3, y);
        context.method_51439(field_22740.field_1772, headerText, headerPosX, headerPosY, 0xFFFFFF, false);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        var selectedEntry = this.method_25334();
        if (selectedEntry == null) return super.method_25404(keyCode, scanCode, modifiers);

        if (keyCode == GLFW_KEY_SPACE || keyCode == GLFW_KEY_ENTER) {
            selectedEntry.toggle();
            this.method_25395(null);
            ((ILanguageOptionsScreen) screen).languagereload_focusEntry(selectedEntry);
            return true;
        }

        if (class_437.method_25442()) {
            if (keyCode == GLFW_KEY_DOWN) {
                selectedEntry.moveDown();
                return true;
            }
            if (keyCode == GLFW_KEY_UP) {
                selectedEntry.moveUp();
                return true;
            }
        }

        return super.method_25404(keyCode, scanCode, modifiers);
    }

    // Remove focusing on entry click
    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.method_25318(mouseX, mouseY, button);
        if (!this.method_25405(mouseX, mouseY)) return false;

        var entry = this.method_25308(mouseX, mouseY);
        if (entry == null && button == 0) return true;

        if (entry != null && entry.method_25402(mouseX, mouseY, button)) {
            var focusedEntry = this.method_25336();
            if (focusedEntry != entry && focusedEntry instanceof class_4069 parentElement)
                parentElement.method_25395(null);
            this.method_25398(true);
            return true;
        }

        return ((EntryListWidgetAccessor) this).languagereload_isScrolling();
    }

    @Override
    @Nullable
    protected LanguageEntry method_25308(double x, double y) {
        int halfRowWidth = this.method_25322() / 2;
        int center = this.method_46426() + field_22758 / 2;
        int minX = center - halfRowWidth;
        int maxX = center + halfRowWidth;
        int m = class_3532.method_15357(y - this.method_46427()) - field_22748 + (int) this.method_25341() - 4 + 2;
        int entryIndex = m / field_22741;
        var hasScrollbar = this.method_57717();
        var scrollbarX = this.method_25329();
        var entryCount = this.method_25340();
        return x >= minX && x <= maxX && (!hasScrollbar || x < scrollbarX) && entryIndex >= 0 && m >= 0 && entryIndex < entryCount
                ? this.method_25396().get(entryIndex)
                : null;
    }

    public class_426 getScreen() {
        return screen;
    }

    public int getRowHeight() {
        return field_22741;
    }

    @Override
    public int method_25322() {
        return field_22758;
    }

    @Override
    protected int method_25329() {
        return this.method_55442() - 6;
    }

    public void updateScroll() {
        this.method_25307(this.method_25341());
    }
}
