package jerozgen.languagereload.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import jerozgen.languagereload.access.ILanguage;
import jerozgen.languagereload.access.ITranslationStorage;
import jerozgen.languagereload.config.Config;
import net.minecraft.class_1124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.ArrayList;
import java.util.List;

@Mixin(value = class_1124.class, priority = 990)
abstract class SearchManagerMixin {
    @WrapOperation(method = {"method_60365"},
            at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;getTooltip(Lnet/minecraft/item/Item$TooltipContext;Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/item/tooltip/TooltipType;)Ljava/util/List;"))
    private static List<class_2561> addFallbackTranslationsToSearchTooltips(class_1799 instance, class_1792.class_9635 context, @Nullable class_1657 player, class_1836 type, Operation<List<class_2561>> operation) {
        var original = operation.call(instance, context, player, type);

        if (Config.getInstance() == null) return original;
        if (!Config.getInstance().multilingualItemSearch) return original;

        var language = class_2477.method_10517();
        if (language == null) return original;

        var translationStorage = ((ILanguage) language).languagereload_getTranslationStorage();
        if (translationStorage == null) return original;

        var result = new ArrayList<>(original);
        for (var fallbackCode : Config.getInstance().fallbacks) {
            ((ITranslationStorage) translationStorage).languagereload_setTargetLanguage(fallbackCode);
            operation.call(instance, context, player, type)
                    .stream()
                    .map(class_2561::getString)
                    .map(class_2561::method_43470)
                    .forEach(result::add);
        }

        ((ITranslationStorage) translationStorage).languagereload_setTargetLanguage(null);
        return result;
    }
}
