package jerozgen.languagereload.mixin;

import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import jerozgen.languagereload.access.ILanguage;
import jerozgen.languagereload.access.ITranslationStorage;
import jerozgen.languagereload.config.Config;
import net.minecraft.class_2477;
import net.minecraft.class_2588;
import net.minecraft.class_2590;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

import java.util.List;
import java.util.function.Consumer;

@Mixin(class_2588.class)
abstract class TranslatableTextContentMixin implements class_7417 {
    @Shadow @Final private String key;

    @WrapOperation(method = "visit(Lnet/minecraft/text/StringVisitable$Visitor;)Ljava/util/Optional;",
            at = @At(value = "FIELD", target = "Lnet/minecraft/text/TranslatableTextContent;translations:Ljava/util/List;"))
    List<class_5348> onVisit(class_2588 instance, Operation<List<class_5348>> translationsGetter) {
        var overriddenTranslations = getOverriddenTranslations();
        if (overriddenTranslations != null) return overriddenTranslations;
        return translationsGetter.call(instance);
    }

    @WrapOperation(method = "visit(Lnet/minecraft/text/StringVisitable$StyledVisitor;Lnet/minecraft/text/Style;)Ljava/util/Optional;",
            at = @At(value = "FIELD", target = "Lnet/minecraft/text/TranslatableTextContent;translations:Ljava/util/List;"))
    List<class_5348> onVisitStyled(class_2588 instance, Operation<List<class_5348>> translationsGetter) {
        var overriddenTranslations = getOverriddenTranslations();
        if (overriddenTranslations != null) return overriddenTranslations;
        return translationsGetter.call(instance);
    }

    @Unique
    List<class_5348> getOverriddenTranslations() {
        if (!Config.getInstance().multilingualItemSearch) return null;

        var language = class_2477.method_10517();
        if (language == null) return null;

        var translationStorage = ((ILanguage) language).languagereload_getTranslationStorage();
        if (translationStorage == null) return null;

        var targetLanguage = ((ITranslationStorage) translationStorage).languagereload_getTargetLanguage();
        if (targetLanguage == null) return null;

        var string = ((ITranslationStorage) translationStorage).languagereload_get(key);
        try {
            var builder = new ImmutableList.Builder<class_5348>();
            this.forEachPart(string, builder::add);
            return builder.build();
        } catch (class_2590 e) {
            return ImmutableList.of(class_5348.method_29430(string));
        }
    }

    @Shadow protected abstract void forEachPart(String translation, Consumer<class_5348> partsConsumer);
}
