package jerozgen.languagereload.gui;

import jerozgen.languagereload.LanguageReload;
import jerozgen.languagereload.access.ILanguageOptionsScreen;
import jerozgen.languagereload.config.Config;
import net.minecraft.class_1077;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_8666;
import org.joml.Vector2i;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class LanguageEntry extends class_4280.class_4281<LanguageEntry> {
    private static final class_2561 DEFAULT_LANGUAGE_TOOLTIP = class_2561.method_43471("language.default.tooltip");

    private static final class_8666 ADD_TEXTURES = new class_8666(
            class_2960.method_60655(LanguageReload.MOD_ID, "language_selection/add"),
            class_2960.method_60655(LanguageReload.MOD_ID, "language_selection/add_highlighted"));
    private static final class_8666 REMOVE_TEXTURES = new class_8666(
            class_2960.method_60655(LanguageReload.MOD_ID, "language_selection/remove"),
            class_2960.method_60655(LanguageReload.MOD_ID, "language_selection/remove_highlighted"));
    private static final class_8666 MOVE_UP_TEXTURES = new class_8666(
            class_2960.method_60655(LanguageReload.MOD_ID, "language_selection/move_up"),
            class_2960.method_60655(LanguageReload.MOD_ID, "language_selection/move_up_highlighted"));
    private static final class_8666 MOVE_DOWN_TEXTURES = new class_8666(
            class_2960.method_60655(LanguageReload.MOD_ID, "language_selection/move_down"),
            class_2960.method_60655(LanguageReload.MOD_ID, "language_selection/move_down_highlighted"));

    private final class_310 client = class_310.method_1551();

    private final String code;
    private final class_1077 language;
    private final LinkedList<String> selectedLanguages;
    private final Runnable refreshListsAction;

    private final List<class_339> buttons = new ArrayList<>();
    private final class_4185 addButton = addButton(15, 24, ADD_TEXTURES, __ -> add());
    private final class_4185 removeButton = addButton(15, 24, REMOVE_TEXTURES, __ -> remove());
    private final class_4185 moveUpButton = addButton(11, 11, MOVE_UP_TEXTURES, __ -> moveUp());
    private final class_4185 moveDownButton = addButton(11, 11, MOVE_DOWN_TEXTURES, __ -> moveDown());

    private LanguageListWidget parentList;

    public LanguageEntry(Runnable refreshListsAction, String code, class_1077 language, LinkedList<String> selectedLanguages) {
        this.code = code;
        this.language = language;
        this.selectedLanguages = selectedLanguages;
        this.refreshListsAction = refreshListsAction;
    }

    protected class_4185 addButton(int width, int height, class_8666 textures, class_4185.class_4241 action) {
        var button = new class_344(0, 0, width, height, textures, action);
        button.field_22764 = false;
        buttons.add(button);
        return button;
    }

    private boolean isDefault() {
        return code.equals(class_2477.field_33187);
    }

    private boolean isSelected() {
        return selectedLanguages.contains(code);
    }

    private boolean isFirst() {
        return code.equals(selectedLanguages.peekFirst());
    }

    private boolean isLast() {
        return code.equals(selectedLanguages.peekLast());
    }

    private void add() {
        if (method_25370())
            parentList.method_25395(null);
        selectedLanguages.addFirst(code);
        refreshListsAction.run();
    }

    private void remove() {
        if (method_25370())
            parentList.method_25395(null);
        selectedLanguages.remove(code);
        refreshListsAction.run();
    }

    public void toggle() {
        if (!isSelected()) add();
        else remove();
    }

    public void moveUp() {
        if (!isSelected()) return;
        if (isFirst()) return;
        var index = selectedLanguages.indexOf(code);
        selectedLanguages.add(index - 1, selectedLanguages.remove(index));
        refreshListsAction.run();
    }

    public void moveDown() {
        if (!isSelected()) return;
        if (isLast()) return;
        var index = selectedLanguages.indexOf(code);
        selectedLanguages.add(index + 1, selectedLanguages.remove(index));
        refreshListsAction.run();
    }

    @Override
    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        x -= 2;
        y -= 2;
        if (hovered || method_25370() || client.field_1690.method_42446().method_41753()) {
            context.method_25294(x + 1, y + 1, x + entryWidth - 1, y + entryHeight + 3,
                    (hovered || method_25370()) ? 0xA0909090 : 0x50909090);
            buttons.forEach(button -> button.field_22764 = false);
            renderButtons((button, buttonX, buttonY) -> {
                button.method_46421(buttonX);
                button.method_46419(buttonY);
                button.field_22764 = true;
                button.method_25394(context, mouseX, mouseY, tickDelta);
            }, x, y);
            if ((hovered || method_25370()) && isDefault())
                renderDefaultLanguageTooltip(x, y);
        }
        context.method_25303(client.field_1772, language.comp_1199(), x + 29, y + 3, 0xFFFFFF);
        context.method_25303(client.field_1772, language.comp_1198(), x + 29, y + 14, 0x808080);
    }

    private void renderButtons(ButtonRenderer renderer, int x, int y) {
        if (isSelected()) {
            if (!isDefault() || Config.getInstance().removableDefaultLanguage) renderer.render(removeButton, x, y);
            if (!isFirst()) renderer.render(moveUpButton, x + removeButton.method_25368() + 1, y);
            if (!isLast()) renderer.render(moveDownButton, x + removeButton.method_25368() + 1, y + moveUpButton.method_25364() + 2);
        } else renderer.render(addButton, x + 7, y);
    }

    private void renderDefaultLanguageTooltip(int x, int y) {
        var tooltip = client.field_1772.method_1728(DEFAULT_LANGUAGE_TOOLTIP, parentList.method_25322() - 6);
        parentList.getScreen().method_47942(tooltip, (screenWidth, screenHeight, mouseX, mouseY, width, height) -> {
            var pos = new Vector2i(
                    x + 3 + (parentList.method_25322() - width - 6) / 2,
                    y + parentList.getRowHeight() + 4);
            if (pos.y > parentList.method_55443() + 2 || pos.y + height + 5 > screenHeight)
                pos.y = y - height - 6;
            return pos;
        }, true);
    }

    @Override
    public class_2561 method_37006() {
        return class_2561.method_43469("narrator.select", language.method_48303());
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (var widget : buttons)
            if (widget.method_25402(mouseX, mouseY, button)) {
                ((ILanguageOptionsScreen) parentList.getScreen()).languagereload_focusList(parentList);
                return true;
            }
        return false;
    }

    public void setParent(LanguageListWidget list) {
        this.parentList = list;
    }

    public LanguageListWidget getParent() {
        return parentList;
    }

    public String getCode() {
        return code;
    }

    public class_1077 getLanguage() {
        return language;
    }

    @FunctionalInterface
    private interface ButtonRenderer {
        void render(class_4185 button, int x, int y);
    }
}
