package jerozgen.languagereload.mixin;

import jerozgen.languagereload.access.ILanguage;
import net.minecraft.class_1078;
import net.minecraft.class_2477;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

// Fixes Server Translation API incompatibility (#56)
@Mixin(value = class_2477.class, priority = 990)
public class LanguageMixin implements ILanguage {
    @Unique private @Nullable class_1078 translationStorage = null;
    @Unique private static @Nullable class_1078 translationStorageOnSetInstance = null;


    @Inject(method = "setInstance", at = @At("HEAD"))
    private static void onSetInstance(class_2477 language, CallbackInfo ci) {
        if (language instanceof class_1078 translationStorage) {
            translationStorageOnSetInstance = translationStorage;
        }
    }

    @Inject(method = "setInstance", at = @At("TAIL"))
    private static void afterSetInstance(class_2477 language, CallbackInfo ci) {
        ((ILanguage) language).languagereload_setTranslationStorage(translationStorageOnSetInstance);
        translationStorageOnSetInstance = null;
    }

    @Override
    public void languagereload_setTranslationStorage(class_1078 translationStorage) {
        this.translationStorage = translationStorage;
    }

    @Override
    public class_1078 languagereload_getTranslationStorage() {
        return translationStorage;
    }
}
