/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.mcwquark;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.bridges.Bridges;
import fr.samlegamer.addonslib.client.APIRenderTypes;
import fr.samlegamer.addonslib.data.ModType;
import fr.samlegamer.addonslib.fences.Fences;
import fr.samlegamer.addonslib.generation.loot_tables.McwLootTables;
import fr.samlegamer.addonslib.generation.tags.McwBlockTags;
import fr.samlegamer.addonslib.generation.tags.McwItemTags;
import fr.samlegamer.addonslib.roofs.Roofs;
import fr.samlegamer.addonslib.tab.NewIconRandom;
import fr.samlegamer.addonslib.util.McwMod;
import fr.samlegamer.mcwquark.Recipes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mcwquark")
@Mod.EventBusSubscriber(modid="mcwquark", bus=Mod.EventBusSubscriber.Bus.MOD)
public class McwQuark
extends McwMod {
    public static final String MODID = "mcwquark";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final List<String> stone = Arrays.asList("andesite_bricks", "basalt_bricks", "biotite_bricks", "diorite_bricks", "elder_prismarine_bricks", "granite_bricks", "jasper_bricks", "limestone_bricks", "magma_bricks", "marble_bricks", "permafrost_bricks", "red_sandstone_bricks", "sandstone_bricks", "slate_bricks", "soul_sandstone_bricks");
    public static final List<String> leaves = Arrays.asList("blue_blossom", "lavender_blossom", "orange_blossom", "pink_blossom", "red_blossom", "yellow_blossom");
    public static final ItemGroup MCWQUARK_TAB = new ItemGroup("mcwquark.tab"){

        @Nonnull
        public ItemStack func_78016_d() {
            NewIconRandom.NewProperties propIcon = new NewIconRandom.NewProperties(Finder.findBlock((String)McwQuark.MODID, (String)"limestone_bricks_roof"), Finder.findBlock((String)McwQuark.MODID, (String)"orange_blossom_hedge"), Blocks.field_150462_ai, Finder.findBlock((String)McwQuark.MODID, (String)"marble_bricks_bridge"), Blocks.field_150462_ai, Blocks.field_150462_ai, Blocks.field_150462_ai, Blocks.field_150462_ai, Blocks.field_150462_ai);
            propIcon.addType(NewIconRandom.BlockType.BRIDGES).addType(NewIconRandom.BlockType.ROOFS).addType(NewIconRandom.BlockType.FENCES);
            Block icon = propIcon.buildIcon(new NewIconRandom.BlockType[]{NewIconRandom.BlockType.BRIDGES, NewIconRandom.BlockType.ROOFS, NewIconRandom.BlockType.FENCES});
            return new ItemStack((IItemProvider)icon);
        }
    };

    public McwQuark() {
        LOGGER.info("Macaw's Quark Loading...");
        this.bus().addListener(this::clientSetup);
        this.bus().addListener(this::commonSetup);
        this.bus().addListener(this::dataSetup);
        LOGGER.info("Macaw's Quark Is Charged !");
    }

    public void commonSetup(FMLCommonSetupEvent fmlCommonSetupEvent) {
        fmlCommonSetupEvent.enqueueWork(() -> {
            McwLootTables.addBlockAllStone((String)MODID, stone);
            McwLootTables.addBlockHedges((String)MODID, leaves);
        });
    }

    public void dataSetup(GatherDataEvent gatherDataEvent) {
        DataGenerator generator = gatherDataEvent.getGenerator();
        ExistingFileHelper existingFileHelper = gatherDataEvent.getExistingFileHelper();
        if (gatherDataEvent.includeServer()) {
            McwBlockTags mcwBlockTags = new McwBlockTags(generator, MODID, existingFileHelper){

                protected void func_200432_c() {
                    this.addAllMcwTags(McwQuark.MODID, new ArrayList(), stone, leaves);
                }
            };
            generator.func_200390_a((IDataProvider)mcwBlockTags);
            generator.func_200390_a((IDataProvider)new McwItemTags(generator, (BlockTagsProvider)mcwBlockTags, MODID, existingFileHelper){

                protected void func_200432_c() {
                    this.addAllMcwTags(McwQuark.MODID, new ArrayList(), stone, leaves);
                }
            });
            generator.func_200390_a((IDataProvider)new Recipes(generator));
        }
    }

    public void clientSetup(FMLClientSetupEvent event) {
        APIRenderTypes.initAllLeave((FMLClientSetupEvent)event, (String)MODID, leaves);
        APIRenderTypes.initAllStone((FMLClientSetupEvent)event, (String)MODID, stone, (ModType[])Registration.getAllModTypeStone());
    }

    @SubscribeEvent
    public static void registry(RegistryEvent.Register<Block> e) {
        Bridges.registryStone(e, (String)MODID, stone, (ItemGroup)MCWQUARK_TAB);
        Fences.registryStone(e, (String)MODID, stone, (ItemGroup)MCWQUARK_TAB);
        Fences.registryHedges(e, (String)MODID, leaves, (ItemGroup)MCWQUARK_TAB);
        Roofs.registryStone(e, (String)MODID, stone, (ItemGroup)MCWQUARK_TAB);
    }
}

