/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest;

import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.KonquestAPI;
import com.github.rumsfield.konquest.api.event.KonquestEvent;
import com.github.rumsfield.konquest.api.model.KonquestDiplomacyType;
import com.github.rumsfield.konquest.api.model.KonquestKingdom;
import com.github.rumsfield.konquest.api.model.KonquestOfflinePlayer;
import com.github.rumsfield.konquest.api.model.KonquestRelationshipType;
import com.github.rumsfield.konquest.api.model.KonquestTerritory;
import com.github.rumsfield.konquest.command.CommandHandler;
import com.github.rumsfield.konquest.database.DatabaseThread;
import com.github.rumsfield.konquest.listener.TNTListener;
import com.github.rumsfield.konquest.manager.AccomplishmentManager;
import com.github.rumsfield.konquest.manager.CampManager;
import com.github.rumsfield.konquest.manager.ConfigManager;
import com.github.rumsfield.konquest.manager.DirectiveManager;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.manager.GlobalEventManager;
import com.github.rumsfield.konquest.manager.IntegrationManager;
import com.github.rumsfield.konquest.manager.KingdomManager;
import com.github.rumsfield.konquest.manager.LanguageManager;
import com.github.rumsfield.konquest.manager.LootManager;
import com.github.rumsfield.konquest.manager.PlaceholderManager;
import com.github.rumsfield.konquest.manager.PlayerManager;
import com.github.rumsfield.konquest.manager.PlotManager;
import com.github.rumsfield.konquest.manager.RuinManager;
import com.github.rumsfield.konquest.manager.SanctuaryManager;
import com.github.rumsfield.konquest.manager.ShieldManager;
import com.github.rumsfield.konquest.manager.TerritoryManager;
import com.github.rumsfield.konquest.manager.TravelManager;
import com.github.rumsfield.konquest.manager.UpgradeManager;
import com.github.rumsfield.konquest.map.MapHandler;
import com.github.rumsfield.konquest.model.KonBarDisplayer;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.model.KonUpgrade;
import com.github.rumsfield.konquest.nms.Handler_1_16_R3;
import com.github.rumsfield.konquest.nms.Handler_1_17_R1;
import com.github.rumsfield.konquest.nms.Handler_1_18_R1;
import com.github.rumsfield.konquest.nms.Handler_1_18_R2;
import com.github.rumsfield.konquest.nms.Handler_1_19_R1;
import com.github.rumsfield.konquest.nms.VersionHandler;
import com.github.rumsfield.konquest.shop.ShopHandler;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.CustomCommandPath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import com.github.rumsfield.konquest.utility.Timeable;
import com.github.rumsfield.konquest.utility.Timer;
import com.github.rumsfield.konquest.utility.Version;
import com.google.common.collect.MapMaker;
import java.awt.Point;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class Konquest
implements KonquestAPI,
Timeable {
    private final KonquestPlugin plugin;
    private static Konquest instance;
    private static String chatTag;
    private static String chatMessage;
    private static String chatDivider;
    public static String friendColor1;
    public static String friendColor2;
    public static String enemyColor1;
    public static String enemyColor2;
    public static String tradeColor1;
    public static String tradeColor2;
    public static String peacefulColor1;
    public static String peacefulColor2;
    public static String alliedColor1;
    public static String alliedColor2;
    public static String barbarianColor1;
    public static String barbarianColor2;
    public static String neutralColor1;
    public static String neutralColor2;
    public static ChatColor blockedProtectionColor;
    public static ChatColor blockedShieldColor;
    public static ChatColor blockedFlagColor;
    public static String metaTntOwnerId;
    public static String healthModName;
    public NamespacedKey healthModKey;
    private final DatabaseThread databaseThread;
    private final AccomplishmentManager accomplishmentManager;
    private final DirectiveManager directiveManager;
    private final PlayerManager playerManager;
    private final KingdomManager kingdomManager;
    private final CampManager campManager;
    private final ConfigManager configManager;
    private final IntegrationManager integrationManager;
    private final LootManager lootManager;
    private final CommandHandler commandHandler;
    private final DisplayManager displayManager;
    private final UpgradeManager upgradeManager;
    private final ShieldManager shieldManager;
    private final RuinManager ruinManager;
    private final LanguageManager languageManager;
    private final MapHandler mapHandler;
    private final ShopHandler shopHandler;
    private final PlaceholderManager placeholderManager;
    private final PlotManager plotManager;
    private final TravelManager travelManager;
    private final SanctuaryManager sanctuaryManager;
    private final TerritoryManager territoryManager;
    private final GlobalEventManager globalEventManager;
    private Scoreboard scoreboard;
    private Team friendlyTeam;
    private Team enemyTeam;
    private Team tradeTeam;
    private Team peacefulTeam;
    private Team alliedTeam;
    private Team barbarianTeam;
    private VersionHandler versionHandler;
    private boolean isVersionSupported;
    private boolean isVersionHandlerEnabled;
    private EventPriority chatPriority;
    private static final EventPriority defaultChatPriority;
    private final List<World> worlds;
    private final List<World> ignoredWorlds;
    private boolean isWhitelist;
    public List<String> opStatusMessages;
    private final Timer saveTimer;
    private final Timer compassTimer;
    private final Timer pingTimer;
    private int saveIntervalSeconds;
    private long offlineTimeoutSeconds;
    public ConcurrentMap<Player, Location> lastPlaced = new MapMaker().weakKeys().weakValues().makeMap();
    private final ConcurrentMap<UUID, ItemStack> headCache = new MapMaker().makeMap();
    private final HashMap<Player, Location> teleportLocationQueue;

    public Konquest(KonquestPlugin plugin) {
        this.plugin = plugin;
        instance = this;
        chatTag = "\u00a77[\u00a76Konquest\u00a77]\u00a7f ";
        chatMessage = "%PREFIX% %KINGDOM% \u00a77| %TITLE% %NAME% %SUFFIX% ";
        chatDivider = "\u00a78\u00bb\u00a7r ";
        this.healthModKey = new NamespacedKey((Plugin)plugin, "health_upgrade");
        this.databaseThread = new DatabaseThread(this);
        this.accomplishmentManager = new AccomplishmentManager(this);
        this.directiveManager = new DirectiveManager(this);
        this.playerManager = new PlayerManager(this);
        this.kingdomManager = new KingdomManager(this);
        this.campManager = new CampManager(this);
        this.configManager = new ConfigManager(this);
        this.integrationManager = new IntegrationManager(this);
        this.lootManager = new LootManager(this);
        this.commandHandler = new CommandHandler(this);
        this.displayManager = new DisplayManager(this);
        this.upgradeManager = new UpgradeManager(this);
        this.shieldManager = new ShieldManager(this);
        this.ruinManager = new RuinManager(this);
        this.languageManager = new LanguageManager(this);
        this.mapHandler = new MapHandler(this);
        this.shopHandler = new ShopHandler(this);
        this.plotManager = new PlotManager(this);
        this.travelManager = new TravelManager(this);
        this.sanctuaryManager = new SanctuaryManager(this);
        this.territoryManager = new TerritoryManager(this);
        this.placeholderManager = new PlaceholderManager(this);
        this.globalEventManager = new GlobalEventManager(this);
        this.versionHandler = null;
        this.chatPriority = defaultChatPriority;
        this.worlds = new ArrayList<World>();
        this.ignoredWorlds = new ArrayList<World>();
        this.isWhitelist = false;
        this.opStatusMessages = new ArrayList<String>();
        this.saveTimer = new Timer(this);
        this.compassTimer = new Timer(this);
        this.pingTimer = new Timer(this);
        this.saveIntervalSeconds = 0;
        this.offlineTimeoutSeconds = 0L;
        this.isVersionSupported = false;
        this.isVersionHandlerEnabled = false;
        this.teleportLocationQueue = new HashMap();
    }

    public void initialize() {
        this.configManager.initialize();
        this.checkCorePaths();
        boolean debug = this.getCore().getBoolean(CorePath.DEBUG.getPath());
        ChatUtil.printDebug("Beginning core Konquest initialization");
        ChatUtil.printDebug("Debug is " + debug);
        String worldName = this.getCore().getString(CorePath.WORLD_NAME.getPath());
        ChatUtil.printDebug("Primary world is " + worldName);
        this.initColors();
        this.languageManager.initialize();
        this.kingdomManager.loadCriticalBlocks();
        this.sanctuaryManager.initialize();
        this.kingdomManager.initialize();
        this.sanctuaryManager.refresh();
        this.ruinManager.initialize();
        this.globalEventManager.initialize();
        this.initManagers();
        this.initWorlds();
        this.kingdomManager.updateKingdomOfflineProtection(true);
        this.printConfigFeatures();
        this.databaseThread.setSleepSeconds(this.saveIntervalSeconds);
        if (!this.databaseThread.isRunning()) {
            ChatUtil.printDebug("Starting database thread");
            this.databaseThread.getThread().start();
        } else {
            ChatUtil.printDebug("Database thread is already running");
        }
        this.initScoreboard();
        this.initVersionHandlers();
        this.mapHandler.initialize();
        boolean isTNTListenerEnabled = this.getCore().getBoolean(CorePath.ENABLE_ADVANCED_TNT_PROTECTION.getPath(), true);
        if (isTNTListenerEnabled) {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)new TNTListener(this.plugin), (Plugin)this.plugin);
            ChatUtil.printDebug("Enabled TNT Listener");
        }
        ChatUtil.printDebug("Finished core Konquest initialization");
    }

    public void initializePostDB() {
        this.accomplishmentManager.loadCustomPrefixes();
        this.databaseThread.getDatabase().spawnTables();
        this.playerManager.initAllSavedPlayers();
        this.kingdomManager.loadLegacyKingdomMemberships();
        this.campManager.initCamps();
        this.mapHandler.drawAllTerritories();
        this.initOnlinePlayers();
        this.refreshPlayerHeads();
        this.integrationManager.getDiscordSrv().setKonquestReady();
        this.integrationManager.getDiscordSrv().refreshRoles();
    }

    public void disable() {
        this.integrationManager.disable();
        this.globalEventManager.shutdown();
        this.globalEventManager.saveEvents();
        this.sanctuaryManager.saveSanctuaries();
        this.kingdomManager.saveKingdoms();
        this.campManager.saveCamps();
        this.ruinManager.saveRuins();
        this.ruinManager.regenAllRuins();
        this.ruinManager.removeAllGolems();
        this.playerManager.clearAllMobTargets();
        this.configManager.saveConfigs();
        this.databaseThread.flushDatabase();
        this.databaseThread.getDatabase().getDatabaseConnection().disconnect();
    }

    private void initVersionHandlers() {
        ChatUtil.printConsoleAlert("Your server version is " + Bukkit.getServer().getBukkitVersion());
        boolean isProtocolLibEnabled = this.integrationManager.getProtocolLib().isEnabled();
        try {
            if (CompatibilityUtil.apiVersion.compareTo(new Version("1.16")) < 0) {
                this.isVersionSupported = false;
            } else if (CompatibilityUtil.apiVersion.compareTo(new Version("1.16.5")) <= 0) {
                this.isVersionSupported = true;
                if (isProtocolLibEnabled) {
                    this.versionHandler = new Handler_1_16_R3();
                }
            } else if (CompatibilityUtil.apiVersion.compareTo(new Version("1.17.1")) <= 0) {
                this.isVersionSupported = true;
                if (isProtocolLibEnabled) {
                    this.versionHandler = new Handler_1_17_R1();
                }
            } else if (CompatibilityUtil.apiVersion.compareTo(new Version("1.18.1")) <= 0) {
                this.isVersionSupported = true;
                if (isProtocolLibEnabled) {
                    this.versionHandler = new Handler_1_18_R1();
                }
            } else if (CompatibilityUtil.apiVersion.compareTo(new Version("1.18.2")) <= 0) {
                this.isVersionSupported = true;
                if (isProtocolLibEnabled) {
                    this.versionHandler = new Handler_1_18_R2();
                }
            } else if (CompatibilityUtil.apiVersion.compareTo(new Version("1.21.8")) <= 0) {
                this.isVersionSupported = true;
                if (isProtocolLibEnabled) {
                    this.versionHandler = new Handler_1_19_R1();
                }
            } else {
                this.isVersionSupported = false;
                if (isProtocolLibEnabled) {
                    this.versionHandler = new Handler_1_19_R1();
                }
            }
        }
        catch (Exception | NoClassDefFoundError e) {
            ChatUtil.printConsoleError("Failed to setup a version handler, ProtocolLib is probably missing. ");
            e.printStackTrace();
        }
        if (!this.isVersionSupported) {
            ChatUtil.printConsoleError("This version of Minecraft is not supported by Konquest! Some features may not work correctly.");
        }
        if (isProtocolLibEnabled) {
            if (this.versionHandler != null) {
                this.isVersionHandlerEnabled = true;
                ChatUtil.printConsoleAlert("Successfully registered name color packets for this server version");
            }
        } else {
            ChatUtil.printConsoleError("Failed to register name color packets, ProtocolLib is missing or disabled! Check version.");
        }
        if (!this.isVersionHandlerEnabled) {
            ChatUtil.printConsoleError("Some Konquest features are disabled. See previous error messages.");
        }
    }

    public void reload() {
        ChatUtil.printConsoleAlert("Reloading config files");
        this.configManager.reloadConfigs();
        this.initManagers();
        this.integrationManager.getDiscordSrv().reloadSettings();
        this.initWorlds();
        this.printConfigFeatures();
        ChatUtil.printConsoleAlert("Finished reload");
    }

    private void initManagers() {
        String configTag = this.getCore().getString(CorePath.CHAT_TAG.getPath(), "");
        chatTag = ChatUtil.parseHex(configTag);
        ChatUtil.printDebug("Chat tag is " + chatTag);
        String configMessage = this.getCore().getString(CorePath.CHAT_MESSAGE.getPath(), "");
        if (!configMessage.equals("")) {
            chatMessage = ChatUtil.parseHex(configMessage);
        }
        ChatUtil.printDebug("Chat message is " + chatMessage);
        String configDivider = this.getCore().getString(CorePath.CHAT_DIVIDER.getPath(), "");
        chatDivider = ChatUtil.parseHex(configDivider);
        ChatUtil.printDebug("Chat divider is " + chatDivider);
        this.kingdomManager.loadOptions();
        this.integrationManager.initialize();
        this.lootManager.initialize();
        this.displayManager.initialize();
        this.playerManager.initialize();
        this.accomplishmentManager.initialize();
        this.directiveManager.initialize();
        this.upgradeManager.initialize();
        this.shieldManager.initialize();
        this.placeholderManager.initialize();
        this.plotManager.initialize();
        this.lootManager.refreshCustomTableAssignments();
        this.offlineTimeoutSeconds = (long)this.getCore().getInt(CorePath.KINGDOMS_OFFLINE_TIMEOUT_DAYS.getPath(), 0) * 86400L;
        if (this.offlineTimeoutSeconds > 0L && this.offlineTimeoutSeconds < 86400L) {
            this.offlineTimeoutSeconds = 86400L;
            ChatUtil.printConsoleError("Offline timeout setting is less than 1 day, overriding to 1 day to prevent data loss.");
        }
        this.saveIntervalSeconds = this.getCore().getInt(CorePath.SAVE_INTERVAL.getPath(), 60) * 60;
        if (this.saveIntervalSeconds > 0) {
            this.saveTimer.stopTimer();
            this.saveTimer.setTime(this.saveIntervalSeconds);
            this.saveTimer.startLoopTimer();
        }
        this.compassTimer.stopTimer();
        this.compassTimer.setTime(30);
        this.compassTimer.startLoopTimer();
        this.pingTimer.stopTimer();
        this.pingTimer.setTime(3600);
        this.pingTimer.startLoopTimer();
        this.chatPriority = Konquest.getEventPriority(this.getCore().getString(CorePath.CHAT_PRIORITY.getPath(), "HIGH"));
        this.kingdomManager.loadArmorBlacklist();
        this.kingdomManager.loadJoinExileCooldowns();
        this.kingdomManager.updateSmallestKingdom();
        this.kingdomManager.updateAllTownDisabledUpgrades();
        this.kingdomManager.updateKingdomOfflineProtection();
    }

    private void initWorlds() {
        List worldNameList = this.getCore().getStringList(CorePath.WORLD_BLACKLIST.getPath());
        this.isWhitelist = this.getCore().getBoolean(CorePath.WORLD_BLACKLIST_REVERSE.getPath(), false);
        for (String name : worldNameList) {
            boolean matches = false;
            for (World world : Bukkit.getServer().getWorlds()) {
                if (!world.getName().equals(name)) continue;
                matches = true;
                this.worlds.add(world);
                break;
            }
            if (matches) continue;
            ChatUtil.printConsoleError("core.world_blacklist name \"" + name + "\" does not match any server worlds, check spelling and case.");
        }
        List ignoredWorldNameList = this.getCore().getStringList(CorePath.WORLD_IGNORELIST.getPath());
        for (String name : ignoredWorldNameList) {
            boolean matches = false;
            for (World world : Bukkit.getServer().getWorlds()) {
                if (!world.getName().equals(name)) continue;
                matches = true;
                this.ignoredWorlds.add(world);
                break;
            }
            if (matches) continue;
            ChatUtil.printConsoleError("core.world_ignorelist name \"" + name + "\" does not match any server worlds, check spelling and case.");
        }
    }

    private void initScoreboard() {
        boolean useRelationSuffix = this.getCore().getBoolean(CorePath.PLAYER_NAMETAG_SUFFIX_RELATION.getPath());
        this.scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        this.friendlyTeam = this.scoreboard.registerNewTeam("friendlies");
        this.friendlyTeam.setColor(ChatUtil.lookupChatColor(friendColor1));
        this.enemyTeam = this.scoreboard.registerNewTeam("enemies");
        this.enemyTeam.setColor(ChatUtil.lookupChatColor(enemyColor1));
        this.tradeTeam = this.scoreboard.registerNewTeam("traders");
        this.tradeTeam.setColor(ChatUtil.lookupChatColor(tradeColor1));
        this.peacefulTeam = this.scoreboard.registerNewTeam("peaceful");
        this.peacefulTeam.setColor(ChatUtil.lookupChatColor(peacefulColor1));
        this.alliedTeam = this.scoreboard.registerNewTeam("allied");
        this.alliedTeam.setColor(ChatUtil.lookupChatColor(alliedColor1));
        this.barbarianTeam = this.scoreboard.registerNewTeam("barbarians");
        this.barbarianTeam.setColor(ChatUtil.lookupChatColor(barbarianColor1));
        if (useRelationSuffix) {
            String separator = " ";
            this.friendlyTeam.setSuffix(separator + friendColor2 + MessagePath.RELATIONSHIP_FRIENDLY.getMessage(new Object[0]));
            this.enemyTeam.setSuffix(separator + enemyColor2 + MessagePath.RELATIONSHIP_ENEMY.getMessage(new Object[0]));
            this.tradeTeam.setSuffix(separator + tradeColor2 + MessagePath.RELATIONSHIP_TRADER.getMessage(new Object[0]));
            this.peacefulTeam.setSuffix(separator + peacefulColor2 + MessagePath.RELATIONSHIP_PEACEFUL.getMessage(new Object[0]));
            this.alliedTeam.setSuffix(separator + alliedColor2 + MessagePath.RELATIONSHIP_ALLY.getMessage(new Object[0]));
            this.barbarianTeam.setSuffix(separator + barbarianColor2 + MessagePath.RELATIONSHIP_BARBARIAN.getMessage(new Object[0]));
        }
    }

    private void initColors() {
        ChatColor namedColor;
        String configColor;
        HashMap<CorePath, Object> colorMapPrimary = new HashMap<CorePath, Object>();
        HashMap<CorePath, Object> colorMapSecondary = new HashMap<CorePath, Object>();
        colorMapPrimary.put(CorePath.COLORS_PRIMARY_FRIENDLY, String.valueOf(ChatColor.GREEN));
        colorMapPrimary.put(CorePath.COLORS_PRIMARY_ENEMY, String.valueOf(ChatColor.RED));
        colorMapPrimary.put(CorePath.COLORS_PRIMARY_TRADE, String.valueOf(ChatColor.LIGHT_PURPLE));
        colorMapPrimary.put(CorePath.COLORS_PRIMARY_PEACEFUL, String.valueOf(ChatColor.WHITE));
        colorMapPrimary.put(CorePath.COLORS_PRIMARY_ALLY, String.valueOf(ChatColor.AQUA));
        colorMapPrimary.put(CorePath.COLORS_PRIMARY_BARBARIAN, String.valueOf(ChatColor.YELLOW));
        colorMapPrimary.put(CorePath.COLORS_PRIMARY_NEUTRAL, String.valueOf(ChatColor.GRAY));
        colorMapSecondary.put(CorePath.COLORS_SECONDARY_FRIENDLY, String.valueOf(ChatColor.DARK_GREEN));
        colorMapSecondary.put(CorePath.COLORS_SECONDARY_ENEMY, String.valueOf(ChatColor.DARK_RED));
        colorMapSecondary.put(CorePath.COLORS_SECONDARY_TRADE, String.valueOf(ChatColor.DARK_PURPLE));
        colorMapSecondary.put(CorePath.COLORS_SECONDARY_PEACEFUL, String.valueOf(ChatColor.GRAY));
        colorMapSecondary.put(CorePath.COLORS_SECONDARY_ALLY, String.valueOf(ChatColor.DARK_AQUA));
        colorMapSecondary.put(CorePath.COLORS_SECONDARY_BARBARIAN, String.valueOf(ChatColor.GOLD));
        colorMapSecondary.put(CorePath.COLORS_SECONDARY_NEUTRAL, String.valueOf(ChatColor.DARK_GRAY));
        HashMap<CorePath, CallSite> updateMap = new HashMap<CorePath, CallSite>();
        for (CorePath colorPath : colorMapPrimary.keySet()) {
            configColor = this.getCore().getString(colorPath.getPath(), "");
            namedColor = ChatUtil.parseColorCode(configColor);
            if (namedColor == null) {
                ChatUtil.printConsoleError("Invalid ChatColor name " + String.valueOf((Object)colorPath) + ": " + configColor + ", primary colors require ChatColor names.");
                continue;
            }
            updateMap.put(colorPath, (CallSite)((Object)String.valueOf(namedColor)));
        }
        for (CorePath colorPath : colorMapSecondary.keySet()) {
            configColor = this.getCore().getString(colorPath.getPath(), "");
            namedColor = ChatUtil.parseColorCode(configColor);
            if (namedColor == null) {
                String formatColor = ChatUtil.parseHex(configColor);
                updateMap.put(colorPath, (CallSite)((Object)formatColor));
                continue;
            }
            updateMap.put(colorPath, (CallSite)((Object)String.valueOf(namedColor)));
        }
        for (CorePath colorPath : updateMap.keySet()) {
            if (colorMapPrimary.containsKey((Object)colorPath)) {
                colorMapPrimary.put(colorPath, (String)updateMap.get((Object)colorPath));
                continue;
            }
            if (!colorMapSecondary.containsKey((Object)colorPath)) continue;
            colorMapSecondary.put(colorPath, (String)updateMap.get((Object)colorPath));
        }
        friendColor1 = (String)colorMapPrimary.get((Object)CorePath.COLORS_PRIMARY_FRIENDLY);
        friendColor2 = (String)colorMapSecondary.get((Object)CorePath.COLORS_SECONDARY_FRIENDLY);
        enemyColor1 = (String)colorMapPrimary.get((Object)CorePath.COLORS_PRIMARY_ENEMY);
        enemyColor2 = (String)colorMapSecondary.get((Object)CorePath.COLORS_SECONDARY_ENEMY);
        tradeColor1 = (String)colorMapPrimary.get((Object)CorePath.COLORS_PRIMARY_TRADE);
        tradeColor2 = (String)colorMapSecondary.get((Object)CorePath.COLORS_SECONDARY_TRADE);
        peacefulColor1 = (String)colorMapPrimary.get((Object)CorePath.COLORS_PRIMARY_PEACEFUL);
        peacefulColor2 = (String)colorMapSecondary.get((Object)CorePath.COLORS_SECONDARY_PEACEFUL);
        alliedColor1 = (String)colorMapPrimary.get((Object)CorePath.COLORS_PRIMARY_ALLY);
        alliedColor2 = (String)colorMapSecondary.get((Object)CorePath.COLORS_SECONDARY_ALLY);
        barbarianColor1 = (String)colorMapPrimary.get((Object)CorePath.COLORS_PRIMARY_BARBARIAN);
        barbarianColor2 = (String)colorMapSecondary.get((Object)CorePath.COLORS_SECONDARY_BARBARIAN);
        neutralColor1 = (String)colorMapPrimary.get((Object)CorePath.COLORS_PRIMARY_NEUTRAL);
        neutralColor2 = (String)colorMapSecondary.get((Object)CorePath.COLORS_SECONDARY_NEUTRAL);
    }

    private void checkCorePaths() {
        for (CorePath testPath : CorePath.values()) {
            if (this.getCore().contains(testPath.getPath())) continue;
            ChatUtil.printConsoleError("Internal error, core path " + testPath.getPath() + " does not exist within core.yml file.");
        }
    }

    private void printConfigFeatures() {
        String lineTemplate = "%-30s -> %s";
        String[] status = new String[]{String.format(lineTemplate, "Accomplishment Prefixes", ChatUtil.boolean2enable(this.getCore().getBoolean(CorePath.ACCOMPLISHMENT_PREFIX.getPath()))), String.format(lineTemplate, "Tutorial Quests", ChatUtil.boolean2enable(this.getCore().getBoolean(CorePath.DIRECTIVE_QUESTS.getPath()))), String.format(lineTemplate, "Chat Formatting", ChatUtil.boolean2enable(this.getCore().getBoolean(CorePath.CHAT_ENABLE_FORMAT.getPath()))), String.format(lineTemplate, "Combat Tag", ChatUtil.boolean2enable(this.getCore().getBoolean(CorePath.COMBAT_PREVENT_COMMAND_ON_DAMAGE.getPath()))), String.format(lineTemplate, "Admin Kingdoms Only", ChatUtil.boolean2enable(this.getCore().getBoolean(CorePath.KINGDOMS_CREATE_ADMIN_ONLY.getPath()))), String.format(lineTemplate, "Kingdom Capital Swap", ChatUtil.boolean2enable(this.getCore().getBoolean(CorePath.KINGDOMS_CAPITAL_SWAP_ENABLE.getPath()))), String.format(lineTemplate, "Kingdom Allied Building", ChatUtil.boolean2enable(this.getCore().getBoolean(CorePath.KINGDOMS_ALLY_BUILD.getPath()))), String.format(lineTemplate, "Kingdom Town Purchases", ChatUtil.boolean2enable(this.getCore().getBoolean(CorePath.KINGDOMS_PURCHASE_TOWNS.getPath()))), String.format(lineTemplate, "Town Upgrades", ChatUtil.boolean2enable(this.getCore().getBoolean(CorePath.TOWNS_ENABLE_UPGRADES.getPath()))), String.format(lineTemplate, "Town Shields", ChatUtil.boolean2enable(this.getCore().getBoolean(CorePath.TOWNS_ENABLE_SHIELDS.getPath()))), String.format(lineTemplate, "Town Armor", ChatUtil.boolean2enable(this.getCore().getBoolean(CorePath.TOWNS_ENABLE_ARMOR.getPath()))), String.format(lineTemplate, "Town Specializations", ChatUtil.boolean2enable(this.getCore().getBoolean(CorePath.TOWNS_DISCOUNT_ENABLE.getPath()))), String.format(lineTemplate, "Town Plots", ChatUtil.boolean2enable(this.getCore().getBoolean(CorePath.PLOTS_ENABLE.getPath()))), String.format(lineTemplate, "Barbarian Camps", ChatUtil.boolean2enable(this.getCore().getBoolean(CorePath.CAMPS_ENABLE.getPath()))), String.format(lineTemplate, "Barbarian Clans", ChatUtil.boolean2enable(this.getCore().getBoolean(CorePath.CAMPS_CLAN_ENABLE.getPath()))), String.format(lineTemplate, "Global Events", ChatUtil.boolean2enable(this.getCore().getInt(CorePath.EVENT_INTERVAL.getPath()) != 0))};
        ChatUtil.printConsoleAlert("Feature Summary...");
        for (String row : status) {
            String line = String.valueOf(ChatColor.GOLD) + "> " + String.valueOf(ChatColor.RESET) + row;
            Bukkit.getServer().getConsoleSender().sendMessage(line);
        }
    }

    public void initOnlinePlayers() {
        for (Player bukkitPlayer : Bukkit.getServer().getOnlinePlayers()) {
            this.initPlayer(bukkitPlayer);
            ChatUtil.printConsole("Loaded online player " + bukkitPlayer.getName());
        }
    }

    public KonPlayer initPlayer(Player bukkitPlayer) {
        Location loginLoc;
        boolean isTitleAlwaysShown;
        double baseHealth;
        AttributeInstance playerHealth;
        Attribute maxHealth;
        boolean isExistingPlayer = this.databaseThread.getDatabase().fetchPlayerData(bukkitPlayer);
        if (!this.playerManager.isOnlinePlayer(bukkitPlayer)) {
            ChatUtil.printDebug("Failed to init a non-existent player!");
            return null;
        }
        KonPlayer player = this.playerManager.getPlayer(bukkitPlayer);
        if (player == null) {
            ChatUtil.printDebug("Failed to init a null player!");
            return null;
        }
        ChatUtil.printDebug("Initializing Konquest player " + bukkitPlayer.getName());
        boolean isPlayerNametagFormatEnabled = this.getCore().getBoolean(CorePath.PLAYER_NAMETAG_FORMAT.getPath(), false);
        if (isPlayerNametagFormatEnabled) {
            bukkitPlayer.setScoreboard(this.getScoreboard());
            this.updateNamePackets(player);
        }
        this.kingdomManager.checkPlayerMemberships(player);
        this.kingdomManager.updateKingdomOfflineProtection();
        this.campManager.deactivateCampProtection(player);
        this.kingdomManager.updatePlayerMembershipStats(player);
        this.kingdomManager.clearTownHearts(player);
        boolean doReset = this.getCore().getBoolean(CorePath.RESET_LEGACY_HEALTH.getPath(), false);
        if (doReset && (maxHealth = CompatibilityUtil.getAttribute("health")) != null && (playerHealth = bukkitPlayer.getAttribute(maxHealth)) != null && (baseHealth = playerHealth.getBaseValue()) > 20.0) {
            playerHealth.setBaseValue(20.0);
        }
        if (isTitleAlwaysShown = this.getCore().getBoolean(CorePath.CHAT_ALWAYS_SHOW_TITLE.getPath(), false)) {
            player.getPlayerPrefix().setEnable(true);
        }
        if (this.territoryManager.isChunkClaimed(loginLoc = bukkitPlayer.getLocation())) {
            KonTerritory loginTerritory = this.territoryManager.getChunkTerritory(loginLoc);
            if (loginTerritory instanceof KonBarDisplayer) {
                ((KonBarDisplayer)((Object)loginTerritory)).addBarPlayer(player);
            }
            if (loginTerritory instanceof KonRuin) {
                ((KonRuin)loginTerritory).spawnAllGolems();
            }
            if (loginTerritory instanceof KonTown) {
                KonTown town = (KonTown)loginTerritory;
                KonquestRelationshipType playerRole = this.kingdomManager.getRelationRole(player.getKingdom(), loginTerritory.getKingdom());
                if (playerRole.equals((Object)KonquestRelationshipType.FRIENDLY)) {
                    this.kingdomManager.applyTownHearts(player, town);
                } else {
                    this.kingdomManager.clearTownHearts(player);
                }
                if (playerRole.equals((Object)KonquestRelationshipType.ENEMY)) {
                    this.kingdomManager.applyTownNerf(player, town);
                } else {
                    this.kingdomManager.clearTownNerf(player);
                }
                if (playerRole.equals((Object)KonquestRelationshipType.ENEMY) || playerRole.equals((Object)KonquestRelationshipType.BARBARIAN)) {
                    town.sendRaidAlert(player);
                }
            }
        } else {
            this.kingdomManager.clearTownNerf(player);
        }
        this.territoryManager.updatePlayerBorderParticles(player);
        ChatUtil.resetTitle(bukkitPlayer);
        if (!isExistingPlayer) {
            this.getPlayerHead((OfflinePlayer)bukkitPlayer);
        }
        return player;
    }

    public void save() {
        this.globalEventManager.saveEvents();
        this.sanctuaryManager.saveSanctuaries();
        this.kingdomManager.saveKingdoms();
        this.campManager.saveCamps();
        this.ruinManager.saveRuins();
        this.configManager.saveConfigs();
    }

    @Override
    public String getFriendlyPrimaryColor() {
        return friendColor1;
    }

    @Override
    public String getFriendlySecondaryColor() {
        return friendColor2;
    }

    @Override
    public String getEnemyPrimaryColor() {
        return enemyColor1;
    }

    @Override
    public String getEnemySecondaryColor() {
        return enemyColor2;
    }

    @Override
    public String getTradePrimaryColor() {
        return tradeColor1;
    }

    @Override
    public String getTradeSecondaryColor() {
        return tradeColor2;
    }

    @Override
    public String getPeacefulPrimaryColor() {
        return peacefulColor1;
    }

    @Override
    public String getPeacefulSecondaryColor() {
        return peacefulColor2;
    }

    @Override
    public String getAlliedPrimaryColor() {
        return alliedColor1;
    }

    @Override
    public String getAlliedSecondaryColor() {
        return alliedColor2;
    }

    @Override
    public String getBarbarianPrimaryColor() {
        return barbarianColor1;
    }

    @Override
    public String getBarbarianSecondaryColor() {
        return barbarianColor2;
    }

    @Override
    public String getNeutralPrimaryColor() {
        return neutralColor1;
    }

    @Override
    public String getNeutralSecondaryColor() {
        return neutralColor2;
    }

    public static Konquest getInstance() {
        return instance;
    }

    public KonquestPlugin getPlugin() {
        return this.plugin;
    }

    public VersionHandler getVersionHandler() {
        return this.versionHandler;
    }

    public boolean isVersionSupported() {
        return this.isVersionSupported;
    }

    public boolean isVersionHandlerEnabled() {
        return this.isVersionHandlerEnabled;
    }

    public AccomplishmentManager getAccomplishmentManager() {
        return this.accomplishmentManager;
    }

    public DirectiveManager getDirectiveManager() {
        return this.directiveManager;
    }

    @Override
    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public SanctuaryManager getSanctuaryManager() {
        return this.sanctuaryManager;
    }

    @Override
    public KingdomManager getKingdomManager() {
        return this.kingdomManager;
    }

    @Override
    public TerritoryManager getTerritoryManager() {
        return this.territoryManager;
    }

    @Override
    public CampManager getCampManager() {
        return this.campManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public FileConfiguration getCore() {
        return this.configManager.getConfig("core");
    }

    public IntegrationManager getIntegrationManager() {
        return this.integrationManager;
    }

    public LootManager getLootManager() {
        return this.lootManager;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    @Override
    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public DatabaseThread getDatabaseThread() {
        return this.databaseThread;
    }

    public DisplayManager getDisplayManager() {
        return this.displayManager;
    }

    @Override
    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    @Override
    public ShieldManager getShieldManager() {
        return this.shieldManager;
    }

    @Override
    public RuinManager getRuinManager() {
        return this.ruinManager;
    }

    public LanguageManager lang() {
        return this.languageManager;
    }

    public MapHandler getMapHandler() {
        return this.mapHandler;
    }

    public ShopHandler getShopHandler() {
        return this.shopHandler;
    }

    public PlaceholderManager getPlaceholderManager() {
        return this.placeholderManager;
    }

    @Override
    public PlotManager getPlotManager() {
        return this.plotManager;
    }

    public TravelManager getTravelManager() {
        return this.travelManager;
    }

    public GlobalEventManager getGlobalEventManager() {
        return this.globalEventManager;
    }

    public long getOfflineTimeoutSeconds() {
        return this.offlineTimeoutSeconds;
    }

    public EventPriority getChatPriority() {
        return this.chatPriority;
    }

    public static String getChatTag() {
        return chatTag;
    }

    public static String getChatMessage() {
        return chatMessage;
    }

    public static String getChatDivider() {
        return chatDivider;
    }

    @Override
    public boolean isWorldValid(Location loc) {
        if (loc != null && loc.getWorld() != null) {
            return this.isWorldValid(loc.getWorld());
        }
        return false;
    }

    @Override
    public boolean isWorldValid(World world) {
        if (world != null) {
            boolean isWorldInBlacklist = this.worlds.contains(world);
            boolean isWorldInIgnorelist = this.ignoredWorlds.contains(world);
            if (this.isWhitelist) {
                return !isWorldInIgnorelist && isWorldInBlacklist;
            }
            return !isWorldInIgnorelist && !isWorldInBlacklist;
        }
        return false;
    }

    @Override
    public boolean isWorldIgnored(Location loc) {
        if (loc != null && loc.getWorld() != null) {
            return this.isWorldIgnored(loc.getWorld());
        }
        return true;
    }

    @Override
    public boolean isWorldIgnored(World world) {
        if (world != null) {
            return this.ignoredWorlds.contains(world);
        }
        return true;
    }

    @Override
    public int validateNameConstraints(String name) {
        if (name == null || name.equals("") || name.contains(" ") || !StringUtils.isAlphanumeric((CharSequence)name.replace("_", ""))) {
            return 1;
        }
        if (name.length() > 20) {
            return 2;
        }
        if (this.playerManager.isPlayerNameExist(name)) {
            return 3;
        }
        if (this.kingdomManager.isKingdom(name)) {
            return 4;
        }
        for (KonKingdom kingdom : this.kingdomManager.getKingdoms()) {
            if (!kingdom.hasTown(name)) continue;
            return 5;
        }
        if (this.ruinManager.isRuin(name)) {
            return 6;
        }
        if (this.sanctuaryManager.isSanctuary(name)) {
            return 8;
        }
        if (this.sanctuaryManager.isTemplate(name)) {
            return 9;
        }
        if (this.globalEventManager.isEvent(name)) {
            return 10;
        }
        for (TravelManager.TravelDestination keyword : TravelManager.TravelDestination.values()) {
            if (!name.equalsIgnoreCase(keyword.toString())) continue;
            return 11;
        }
        ArrayList<String> reservedWords = new ArrayList<String>();
        reservedWords.add("konquest");
        reservedWords.add("kingdom");
        reservedWords.add("town");
        reservedWords.add("camp");
        reservedWords.add("ruin");
        reservedWords.add("sanctuary");
        reservedWords.add("templates");
        reservedWords.add("template");
        reservedWords.add("monument");
        reservedWords.add("event");
        reservedWords.add("all");
        for (String word : reservedWords) {
            if (!name.equalsIgnoreCase(word)) continue;
            return 12;
        }
        return 0;
    }

    public int validateName(String name, CommandSender sender) {
        int result = this.validateNameConstraints(name);
        if (sender != null) {
            if (result == 1) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_FORMAT_NAME.getMessage(new Object[0]));
            } else if (result == 2) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_LENGTH_NAME.getMessage(new Object[0]));
            } else if (result >= 3) {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_TAKEN_NAME.getMessage(new Object[0]));
            }
        }
        return result;
    }

    @Override
    public void onEndTimer(int taskID) {
        boolean status;
        if (taskID == 0) {
            ChatUtil.printDebug("Save Timer ended with null taskID!");
        } else if (taskID == this.saveTimer.getTaskID()) {
            if (this.offlineTimeoutSeconds != 0L) {
                Date now = new Date();
                for (KonOfflinePlayer player : this.playerManager.getAllKonquestOfflinePlayers()) {
                    long lastPlayedTime = player.getOfflineBukkitPlayer().getLastPlayed();
                    if (lastPlayedTime <= 0L || !now.after(new Date(lastPlayedTime + this.offlineTimeoutSeconds * 1000L))) continue;
                    boolean doExile = this.getCore().getBoolean(CorePath.KINGDOMS_OFFLINE_TIMEOUT_EXILE.getPath(), false);
                    if (!player.isBarbarian()) {
                        boolean bl;
                        if (doExile) {
                            UUID id = player.getOfflineBukkitPlayer().getUniqueId();
                            String kingdomName = player.getKingdom().getName();
                            bl = this.getKingdomManager().exilePlayerBarbarian(id, false, false, true, true);
                            ChatUtil.printDebug("Pruned player " + player.getOfflineBukkitPlayer().getName() + " by exile from kingdom " + kingdomName + ", status " + (int)(bl ? 1 : 0));
                            continue;
                        }
                        for (KonTown town : player.getKingdom().getTowns()) {
                            if (!town.getPlayerResidents().contains(player.getOfflineBukkitPlayer())) continue;
                            bl = town.removePlayerResident(player.getOfflineBukkitPlayer());
                            ChatUtil.printDebug("Pruned player " + player.getOfflineBukkitPlayer().getName() + " from town " + town.getName() + " in kingdom " + player.getKingdom().getName() + ", status " + bl);
                        }
                        continue;
                    }
                    if (!this.campManager.isCampSet(player)) continue;
                    this.campManager.removeCamp(player);
                    ChatUtil.printDebug("Pruned player " + player.getOfflineBukkitPlayer().getName() + " from camp");
                }
            }
            this.save();
            this.saveTimer.setTime(this.saveIntervalSeconds);
            ChatUtil.sendAdminBroadcast("Saved all config files");
        } else if (taskID == this.compassTimer.getTaskID()) {
            for (KonPlayer player : this.playerManager.getPlayersOnline()) {
                if (!player.getBukkitPlayer().hasPermission("konquest.compass") || !this.isWorldValid(player.getBukkitPlayer().getWorld()) || !player.getBukkitPlayer().getInventory().contains(Material.COMPASS)) continue;
                List<KonKingdom> enemyKingdoms = player.getKingdom().getActiveRelationKingdoms(KonquestDiplomacyType.WAR);
                KonTerritory nearestTerritory = null;
                int minDistance = Integer.MAX_VALUE;
                for (KonKingdom kingdom : enemyKingdoms) {
                    for (KonTown konTown : kingdom.getCapitalTowns()) {
                        int townDist;
                        int upgradeLevel = this.upgradeManager.getTownUpgradeLevel(konTown, KonUpgrade.COUNTER);
                        if (upgradeLevel >= 2 || (townDist = HelperUtil.chunkDistance(player.getBukkitPlayer().getLocation(), konTown.getCenterLoc())) == -1 || townDist >= minDistance) continue;
                        minDistance = townDist;
                        nearestTerritory = konTown;
                    }
                }
                if (nearestTerritory == null) continue;
                Location nearestEnemyTownLoc = nearestTerritory.getCenterLoc();
                player.getBukkitPlayer().setCompassTarget(nearestEnemyTownLoc);
            }
        } else if (taskID == this.pingTimer.getTaskID() && (status = this.databaseThread.getDatabase().getDatabaseConnection().pingDatabase())) {
            ChatUtil.printDebug("Database ping success!");
        }
    }

    @Override
    public Location getRandomWildLocation(World world) {
        Location wildLoc = null;
        int MAX_ATTEMPTS = 100;
        int radius = this.getCore().getInt(CorePath.TRAVEL_WILD_RADIUS.getPath(), 500);
        int offsetX = this.getCore().getInt(CorePath.TRAVEL_WILD_CENTER_X.getPath(), 0);
        int offsetZ = this.getCore().getInt(CorePath.TRAVEL_WILD_CENTER_Z.getPath(), 0);
        radius = radius > 0 ? radius : 2;
        ChatUtil.printDebug("Generating random wilderness location at center " + offsetX + "," + offsetZ + " in radius " + radius);
        boolean foundValidLoc = false;
        int timeout = 0;
        int numClaimed = 0;
        int numWater = 0;
        while (!foundValidLoc) {
            int randomNumZ;
            Block randomBlock;
            int randomNumY;
            if (timeout > 100) {
                ChatUtil.printDebug("Failed to get a random wilderness location. Claimed attempts: " + numClaimed + "; Water attempts: " + numWater);
                return null;
            }
            int randomNumX = ThreadLocalRandom.current().nextInt(-1 * radius, radius + 1) + offsetX;
            wildLoc = new Location(world, (double)randomNumX, (double)(randomNumY = (randomBlock = world.getHighestBlockAt(randomNumX, randomNumZ = ThreadLocalRandom.current().nextInt(-1 * radius, radius + 1) + offsetZ)).getY() + 2), (double)randomNumZ);
            if (this.territoryManager.isChunkClaimed(wildLoc)) {
                ++numClaimed;
                ++timeout;
                continue;
            }
            if (!randomBlock.getType().isSolid()) {
                ++numWater;
                ++timeout;
                continue;
            }
            foundValidLoc = true;
        }
        ChatUtil.printDebug("Got wilderness location " + wildLoc.getX() + "," + wildLoc.getY() + "," + wildLoc.getZ() + ". Claimed attempts: " + numClaimed + "; Water attempts: " + numWater);
        return wildLoc;
    }

    @Override
    public Location getSafeRandomCenteredLocation(Location center, int radius) {
        Location randLoc = null;
        ChatUtil.printDebug("Generating random centered location for radius " + radius);
        boolean foundValidLoc = false;
        int timeout = 0;
        ArrayList<Chunk> chunkList = HelperUtil.getSurroundingChunks(center, radius);
        while (!foundValidLoc) {
            int randomChunkIdx = ThreadLocalRandom.current().nextInt(0, chunkList.size());
            int randomNumX = ThreadLocalRandom.current().nextInt(0, 16);
            int randomNumZ = ThreadLocalRandom.current().nextInt(0, 16);
            int randomNumY = chunkList.get(randomChunkIdx).getChunkSnapshot(true, false, false).getHighestBlockYAt(randomNumX, randomNumZ);
            Block randBlock = chunkList.get(randomChunkIdx).getBlock(randomNumX, randomNumY, randomNumZ);
            Block randBlockDown = chunkList.get(randomChunkIdx).getBlock(randomNumX, randomNumY - 1, randomNumZ);
            randLoc = randBlock.getLocation();
            randLoc.add(0.5, 2.0, 0.5);
            ChatUtil.printDebug("Checking block material target: " + String.valueOf(randBlock.getType()));
            ChatUtil.printDebug("Checking block material down: " + String.valueOf(randBlockDown.getType()));
            if (!randBlockDown.getType().equals((Object)Material.LAVA) && randBlockDown.getType().isSolid()) {
                foundValidLoc = true;
            } else {
                ++timeout;
                ChatUtil.printDebug("Got dangerous location, trying again...");
            }
            if (timeout <= 100) continue;
            ChatUtil.printDebug("There was a problem getting a safe centered location: timeout");
            return null;
        }
        ChatUtil.printDebug("Got safe centered location " + randLoc.getX() + "," + randLoc.getY() + "," + randLoc.getZ());
        double x0 = randLoc.getX();
        double x1 = center.getX();
        double z0 = randLoc.getZ();
        double z1 = center.getZ();
        float yaw = (float)(180.0 - Math.atan2(x0 - x1, z0 - z1) * 180.0 / Math.PI);
        randLoc.setYaw(yaw);
        return randLoc;
    }

    public void updateNamePackets(KonPlayer player) {
        if (!this.isVersionHandlerEnabled) {
            return;
        }
        ArrayList<String> friendlyNames = new ArrayList<String>();
        ArrayList<String> enemyNames = new ArrayList<String>();
        ArrayList<String> tradeNames = new ArrayList<String>();
        ArrayList<String> peacefulNames = new ArrayList<String>();
        ArrayList<String> alliedNames = new ArrayList<String>();
        ArrayList<String> barbarianNames = new ArrayList<String>();
        for (KonPlayer onlinePlayer : this.playerManager.getPlayersOnline()) {
            boolean status;
            Team onlinePacketTeam;
            KonquestRelationshipType otherPlayerRole = this.kingdomManager.getRelationRole(player.getKingdom(), onlinePlayer.getKingdom());
            switch (otherPlayerRole) {
                case BARBARIAN: {
                    barbarianNames.add(onlinePlayer.getBukkitPlayer().getName());
                    break;
                }
                case FRIENDLY: {
                    friendlyNames.add(onlinePlayer.getBukkitPlayer().getName());
                    break;
                }
                case ENEMY: {
                    enemyNames.add(onlinePlayer.getBukkitPlayer().getName());
                    break;
                }
                case TRADE: {
                    tradeNames.add(onlinePlayer.getBukkitPlayer().getName());
                    break;
                }
                case ALLY: {
                    alliedNames.add(onlinePlayer.getBukkitPlayer().getName());
                    break;
                }
                default: {
                    peacefulNames.add(onlinePlayer.getBukkitPlayer().getName());
                }
            }
            KonquestRelationshipType thisPlayerRole = this.kingdomManager.getRelationRole(onlinePlayer.getKingdom(), player.getKingdom());
            switch (thisPlayerRole) {
                case BARBARIAN: {
                    onlinePacketTeam = this.barbarianTeam;
                    break;
                }
                case FRIENDLY: {
                    onlinePacketTeam = this.friendlyTeam;
                    break;
                }
                case ENEMY: {
                    onlinePacketTeam = this.enemyTeam;
                    break;
                }
                case TRADE: {
                    onlinePacketTeam = this.tradeTeam;
                    break;
                }
                case ALLY: {
                    onlinePacketTeam = this.alliedTeam;
                    break;
                }
                default: {
                    onlinePacketTeam = this.peacefulTeam;
                }
            }
            if (status = this.versionHandler.sendPlayerTeamPacket(onlinePlayer.getBukkitPlayer(), Collections.singletonList(player.getBukkitPlayer().getName()), onlinePacketTeam)) continue;
            ChatUtil.printConsoleError("Failed to send Team Update packet, make sure ProtocolLib is updated and works for this Minecraft version.");
        }
        if (!barbarianNames.isEmpty()) {
            this.versionHandler.sendPlayerTeamPacket(player.getBukkitPlayer(), barbarianNames, this.barbarianTeam);
        }
        if (!friendlyNames.isEmpty()) {
            this.versionHandler.sendPlayerTeamPacket(player.getBukkitPlayer(), friendlyNames, this.friendlyTeam);
        }
        if (!enemyNames.isEmpty()) {
            this.versionHandler.sendPlayerTeamPacket(player.getBukkitPlayer(), enemyNames, this.enemyTeam);
        }
        if (!tradeNames.isEmpty()) {
            this.versionHandler.sendPlayerTeamPacket(player.getBukkitPlayer(), tradeNames, this.tradeTeam);
        }
        if (!alliedNames.isEmpty()) {
            this.versionHandler.sendPlayerTeamPacket(player.getBukkitPlayer(), alliedNames, this.alliedTeam);
        }
        if (!peacefulNames.isEmpty()) {
            this.versionHandler.sendPlayerTeamPacket(player.getBukkitPlayer(), peacefulNames, this.peacefulTeam);
        }
    }

    public void updateNamePackets(KonKingdom kingdom) {
        for (KonPlayer player : this.playerManager.getPlayersInKingdom(kingdom)) {
            this.updateNamePackets(player);
        }
    }

    public void telePlayerLocation(Player player, Location travelLocation) {
        Point locPoint = HelperUtil.toPoint(travelLocation);
        Location destination = new Location(travelLocation.getWorld(), (double)travelLocation.getBlockX() + 0.5, (double)travelLocation.getBlockY() + 0.5, (double)travelLocation.getBlockZ() + 0.5, travelLocation.getYaw(), travelLocation.getPitch());
        if (travelLocation.getWorld().isChunkLoaded(locPoint.x, locPoint.y)) {
            ChatUtil.printDebug("Teleporting player " + player.getName() + " to loaded chunk");
            player.teleport(destination, PlayerTeleportEvent.TeleportCause.PLUGIN);
            Konquest.playTravelSound(player);
        } else {
            this.teleportLocationQueue.put(player, destination);
            ChatUtil.printDebug("Queueing player " + player.getName() + " for unloaded chunk destination");
            travelLocation.getWorld().loadChunk(locPoint.x, locPoint.y);
        }
    }

    public void applyQueuedTeleports(Chunk chunk) {
        Point cPoint = HelperUtil.toPoint(chunk);
        if (!this.teleportLocationQueue.isEmpty()) {
            for (Player qPlayer : this.teleportLocationQueue.keySet()) {
                Location qLoc = this.teleportLocationQueue.get(qPlayer);
                Point qPoint = HelperUtil.toPoint(qLoc);
                if (!qPoint.equals(cPoint) || !chunk.getWorld().equals((Object)qLoc.getWorld())) continue;
                qPlayer.teleport(qLoc, PlayerTeleportEvent.TeleportCause.PLUGIN);
                Konquest.playTravelSound(qPlayer);
                ChatUtil.printDebug("Teleporting chunk queued player " + qPlayer.getName());
                this.teleportLocationQueue.remove(qPlayer);
            }
        }
    }

    public void refreshPlayerHeads() {
        for (OfflinePlayer player : this.playerManager.getAllOfflinePlayers()) {
            this.getPlayerHead(player);
        }
    }

    public ItemStack getPlayerHead(OfflinePlayer bukkitOfflinePlayer) {
        UUID playerId = bukkitOfflinePlayer.getUniqueId();
        if (!this.headCache.containsKey(playerId)) {
            ChatUtil.printDebug("Missing " + bukkitOfflinePlayer.getName() + " player head in the cache, creating...");
            ItemStack item = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)item.getItemMeta();
            meta.setOwningPlayer(bukkitOfflinePlayer);
            item.setItemMeta((ItemMeta)meta);
            this.headCache.put(playerId, item);
        }
        return (ItemStack)this.headCache.get(playerId);
    }

    @Override
    public String getDisplayPrimaryColor(KonquestKingdom displayKingdom, KonquestKingdom contextKingdom) {
        String result = neutralColor1;
        KonquestRelationshipType role = this.kingdomManager.getRelationRole(displayKingdom, contextKingdom);
        switch (role) {
            case BARBARIAN: {
                result = barbarianColor1;
                break;
            }
            case NEUTRAL: {
                result = neutralColor1;
                break;
            }
            case ENEMY: {
                result = enemyColor1;
                break;
            }
            case FRIENDLY: {
                result = friendColor1;
                break;
            }
            case ALLY: {
                result = alliedColor1;
                break;
            }
            case TRADE: {
                result = tradeColor1;
                break;
            }
            case PEACEFUL: {
                result = peacefulColor1;
                break;
            }
        }
        return result;
    }

    @Override
    public String getDisplayPrimaryColor(KonquestOfflinePlayer displayPlayer, KonquestOfflinePlayer contextPlayer) {
        return this.getDisplayPrimaryColor(displayPlayer.getKingdom(), contextPlayer.getKingdom());
    }

    @Override
    public String getDisplayPrimaryColor(KonquestOfflinePlayer displayPlayer, KonquestTerritory contextTerritory) {
        return this.getDisplayPrimaryColor(displayPlayer.getKingdom(), contextTerritory.getKingdom());
    }

    @Override
    public String getDisplaySecondaryColor(KonquestKingdom displayKingdom, KonquestKingdom contextKingdom) {
        String result = neutralColor2;
        KonquestRelationshipType role = this.kingdomManager.getRelationRole(displayKingdom, contextKingdom);
        switch (role) {
            case BARBARIAN: {
                result = barbarianColor2;
                break;
            }
            case NEUTRAL: {
                result = neutralColor2;
                break;
            }
            case ENEMY: {
                result = enemyColor2;
                break;
            }
            case FRIENDLY: {
                result = friendColor2;
                break;
            }
            case ALLY: {
                result = alliedColor2;
                break;
            }
            case TRADE: {
                result = tradeColor2;
                break;
            }
            case PEACEFUL: {
                result = peacefulColor2;
                break;
            }
        }
        return result;
    }

    @Override
    public String getDisplaySecondaryColor(KonquestOfflinePlayer displayPlayer, KonquestOfflinePlayer contextPlayer) {
        return this.getDisplaySecondaryColor(displayPlayer.getKingdom(), contextPlayer.getKingdom());
    }

    @Override
    public String getDisplaySecondaryColor(KonquestOfflinePlayer displayPlayer, KonquestTerritory contextTerritory) {
        return this.getDisplaySecondaryColor(displayPlayer.getKingdom(), contextTerritory.getKingdom());
    }

    public static void playSuccessSound(Player bukkitPlayer) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)instance.getPlugin(), () -> bukkitPlayer.playSound(bukkitPlayer.getLocation(), Sound.BLOCK_NOTE_BLOCK_FLUTE, 1.0f, 1.3f), 1L);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)instance.getPlugin(), () -> bukkitPlayer.playSound(bukkitPlayer.getLocation(), Sound.BLOCK_NOTE_BLOCK_FLUTE, 1.0f, 1.7f), 4L);
    }

    public static void playFailSound(Player bukkitPlayer) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)instance.getPlugin(), () -> bukkitPlayer.playSound(bukkitPlayer.getLocation(), Sound.BLOCK_GLASS_BREAK, 0.5f, 1.4f), 1L);
    }

    public static void playDiscountSound(Player bukkitPlayer) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)instance.getPlugin(), () -> bukkitPlayer.playSound(bukkitPlayer.getLocation(), Sound.ENTITY_VILLAGER_CELEBRATE, 1.0f, 1.0f), 1L);
    }

    public static void playTownArmorSound(Player bukkitPlayer) {
        Konquest.playTownArmorSound(bukkitPlayer.getLocation());
    }

    public static void playTownArmorSound(Location loc) {
        loc.getWorld().playSound(loc, Sound.ENTITY_SHULKER_SHOOT, 1.0f, 2.0f);
    }

    public static void playTownSettleSound(Location loc) {
        loc.getWorld().playSound(loc, Sound.BLOCK_ANVIL_USE, 0.5f, 1.0f);
    }

    public static void playCampGroupSound(Location loc) {
        loc.getWorld().playSound(loc, Sound.BLOCK_FENCE_GATE_OPEN, 1.0f, 0.7f);
    }

    public static void playTravelSound(Player bukkitPlayer) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)instance.getPlugin(), () -> bukkitPlayer.playSound(bukkitPlayer.getLocation(), Sound.ENTITY_EGG_THROW, 1.0f, 0.1f), 1L);
    }

    public static void playNotificationGoodSound(Player bukkitPlayer) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)instance.getPlugin(), () -> bukkitPlayer.playSound(bukkitPlayer.getLocation(), Sound.BLOCK_BELL_USE, 1.0f, 1.0f), 1L);
    }

    public static void playNotificationBadSound(Player bukkitPlayer) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)instance.getPlugin(), () -> bukkitPlayer.playSound(bukkitPlayer.getLocation(), Sound.BLOCK_BELL_USE, 1.0f, 0.1f), 1L);
    }

    public static EventPriority getEventPriority(String priority) {
        EventPriority result = defaultChatPriority;
        if (priority != null) {
            try {
                result = EventPriority.valueOf((String)priority.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    public static void callKonquestEvent(KonquestEvent event) {
        if (event != null) {
            try {
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
            }
            catch (IllegalStateException e) {
                ChatUtil.printConsoleError("Failed to call Konquest event!");
                e.printStackTrace();
            }
        } else {
            ChatUtil.printDebug("Could not call null Konquest event");
        }
    }

    public void executeCustomCommand(CustomCommandPath command, Player bukkitPlayer) {
        String commandPath = command.getPath();
        FileConfiguration customCommandConfig = this.configManager.getConfig("commands");
        String customCommand = customCommandConfig.getString(commandPath, "");
        ChatUtil.printDebug("Running command \"" + customCommand + "\" for " + commandPath);
        if (!customCommand.isEmpty()) {
            customCommand = customCommand.replace("%PLAYER%", bukkitPlayer.getName());
            try {
                boolean result = Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)customCommand);
                if (!result) {
                    ChatUtil.printConsoleWarning("Could not run command \"" + customCommand + "\" from commands.yml entry " + commandPath);
                    if (customCommand.matches("^/.+")) {
                        ChatUtil.printConsoleWarning("Custom command starts with a forward slash \"/\". Remove the slash from the command in commands.yml.");
                    }
                }
            }
            catch (CommandException me) {
                ChatUtil.printConsoleError("Failed to execute custom command \"" + customCommand + "\" from commands.yml entry " + commandPath);
                ChatUtil.printConsole(me.getMessage());
                me.printStackTrace();
            }
        }
    }

    static {
        friendColor1 = "\u00a77";
        friendColor2 = "\u00a77";
        enemyColor1 = "\u00a77";
        enemyColor2 = "\u00a77";
        tradeColor1 = "\u00a77";
        tradeColor2 = "\u00a77";
        peacefulColor1 = "\u00a77";
        peacefulColor2 = "\u00a77";
        alliedColor1 = "\u00a77";
        alliedColor2 = "\u00a77";
        barbarianColor1 = "\u00a77";
        barbarianColor2 = "\u00a77";
        neutralColor1 = "\u00a77";
        neutralColor2 = "\u00a77";
        blockedProtectionColor = ChatColor.DARK_RED;
        blockedShieldColor = ChatColor.DARK_AQUA;
        blockedFlagColor = ChatColor.DARK_GRAY;
        metaTntOwnerId = "konquest-tnt-owner";
        healthModName = "konquest.health_buff";
        defaultChatPriority = EventPriority.HIGH;
    }
}

