/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest;

import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.manager.PlaceholderManager;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Relational;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class KonquestPlaceholderExpansion
extends PlaceholderExpansion
implements Relational {
    private final KonquestPlugin plugin;
    private final PlaceholderManager placeholderManager;

    public KonquestPlaceholderExpansion(KonquestPlugin plugin) {
        this.plugin = plugin;
        this.placeholderManager = plugin.getKonquestInstance().getPlaceholderManager();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    @NotNull
    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    @NotNull
    public String getIdentifier() {
        return "konquest";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        String identifierLower;
        if (player == null) {
            return "";
        }
        String result = null;
        switch (identifierLower = identifier.toLowerCase()) {
            case "events": {
                result = this.placeholderManager.getActiveEvents();
                break;
            }
            case "event_effects": {
                result = this.placeholderManager.getActiveEventEffects();
                break;
            }
            case "timer_loot": {
                result = this.placeholderManager.getTimerLoot(player);
                break;
            }
            case "timer_payment": {
                result = this.placeholderManager.getTimerPayment(player);
                break;
            }
            case "kingdom": {
                result = this.placeholderManager.getKingdom(player);
                break;
            }
            case "exile": {
                result = this.placeholderManager.getExile(player);
                break;
            }
            case "barbarian": {
                result = this.placeholderManager.getBarbarian(player);
                break;
            }
            case "num_town_lord": {
                result = this.placeholderManager.getTownsLord(player);
                break;
            }
            case "num_town_knight": {
                result = this.placeholderManager.getTownsKnight(player);
                break;
            }
            case "num_town_resident": {
                result = this.placeholderManager.getTownsResident(player);
                break;
            }
            case "num_town_all": {
                result = this.placeholderManager.getTownsAll(player);
                break;
            }
            case "territory": {
                result = this.placeholderManager.getTerritory(player);
                break;
            }
            case "land": {
                result = this.placeholderManager.getLand(player);
                break;
            }
            case "claimed": {
                result = this.placeholderManager.getClaimed(player);
                break;
            }
            case "score": {
                result = this.placeholderManager.getScore(player);
                break;
            }
            case "prefix": {
                result = this.placeholderManager.getPrefix(player);
                break;
            }
            case "rank": {
                result = this.placeholderManager.getRank(player);
                break;
            }
            case "lordships": {
                result = this.placeholderManager.getLordships(player);
                break;
            }
            case "residencies": {
                result = this.placeholderManager.getResidencies(player);
                break;
            }
            case "chat": {
                result = this.placeholderManager.getChat(player);
                break;
            }
            case "combat": {
                result = this.placeholderManager.getCombat(player);
                break;
            }
            case "combat_tag": {
                result = this.placeholderManager.getCombatTag(player);
                break;
            }
            case "top_score_1": {
                result = this.placeholderManager.getTopScore(1);
                break;
            }
            case "top_score_2": {
                result = this.placeholderManager.getTopScore(2);
                break;
            }
            case "top_score_3": {
                result = this.placeholderManager.getTopScore(3);
                break;
            }
            case "top_score_4": {
                result = this.placeholderManager.getTopScore(4);
                break;
            }
            case "top_score_5": {
                result = this.placeholderManager.getTopScore(5);
                break;
            }
            case "top_score_6": {
                result = this.placeholderManager.getTopScore(6);
                break;
            }
            case "top_score_7": {
                result = this.placeholderManager.getTopScore(7);
                break;
            }
            case "top_score_8": {
                result = this.placeholderManager.getTopScore(8);
                break;
            }
            case "top_score_9": {
                result = this.placeholderManager.getTopScore(9);
                break;
            }
            case "top_score_10": {
                result = this.placeholderManager.getTopScore(10);
                break;
            }
            case "top_town_1": {
                result = this.placeholderManager.getTopTown(1);
                break;
            }
            case "top_town_2": {
                result = this.placeholderManager.getTopTown(2);
                break;
            }
            case "top_town_3": {
                result = this.placeholderManager.getTopTown(3);
                break;
            }
            case "top_town_4": {
                result = this.placeholderManager.getTopTown(4);
                break;
            }
            case "top_town_5": {
                result = this.placeholderManager.getTopTown(5);
                break;
            }
            case "top_town_6": {
                result = this.placeholderManager.getTopTown(6);
                break;
            }
            case "top_town_7": {
                result = this.placeholderManager.getTopTown(7);
                break;
            }
            case "top_town_8": {
                result = this.placeholderManager.getTopTown(8);
                break;
            }
            case "top_town_9": {
                result = this.placeholderManager.getTopTown(9);
                break;
            }
            case "top_town_10": {
                result = this.placeholderManager.getTopTown(10);
                break;
            }
            case "top_land_1": {
                result = this.placeholderManager.getTopLand(1);
                break;
            }
            case "top_land_2": {
                result = this.placeholderManager.getTopLand(2);
                break;
            }
            case "top_land_3": {
                result = this.placeholderManager.getTopLand(3);
                break;
            }
            case "top_land_4": {
                result = this.placeholderManager.getTopLand(4);
                break;
            }
            case "top_land_5": {
                result = this.placeholderManager.getTopLand(5);
                break;
            }
            case "top_land_6": {
                result = this.placeholderManager.getTopLand(6);
                break;
            }
            case "top_land_7": {
                result = this.placeholderManager.getTopLand(7);
                break;
            }
            case "top_land_8": {
                result = this.placeholderManager.getTopLand(8);
                break;
            }
            case "top_land_9": {
                result = this.placeholderManager.getTopLand(9);
                break;
            }
            case "top_land_10": {
                result = this.placeholderManager.getTopLand(10);
                break;
            }
            case "kingdom_players": {
                result = this.placeholderManager.getPlayerKingdomPlayers(player);
                break;
            }
            case "kingdom_online": {
                result = this.placeholderManager.getPlayerKingdomOnline(player);
                break;
            }
            case "kingdom_towns": {
                result = this.placeholderManager.getPlayerKingdomTowns(player);
                break;
            }
            case "kingdom_land": {
                result = this.placeholderManager.getPlayerKingdomLand(player);
                break;
            }
            case "kingdom_favor": {
                result = this.placeholderManager.getPlayerKingdomFavor(player);
                break;
            }
            case "kingdom_score": {
                result = this.placeholderManager.getPlayerKingdomScore(player);
                break;
            }
            default: {
                if (identifierLower.matches("^players_.+$")) {
                    try {
                        String kingdomName = identifierLower.substring(8);
                        result = this.placeholderManager.getKingdomPlayers(kingdomName);
                    }
                    catch (IndexOutOfBoundsException kingdomName) {}
                    break;
                }
                if (identifierLower.matches("^online_.+$")) {
                    try {
                        String kingdomName = identifierLower.substring(7);
                        result = this.placeholderManager.getKingdomOnline(kingdomName);
                    }
                    catch (IndexOutOfBoundsException kingdomName) {}
                    break;
                }
                if (identifierLower.matches("^towns_.+$")) {
                    try {
                        String kingdomName = identifierLower.substring(6);
                        result = this.placeholderManager.getKingdomTowns(kingdomName);
                    }
                    catch (IndexOutOfBoundsException kingdomName) {}
                    break;
                }
                if (identifierLower.matches("^land_.+$")) {
                    try {
                        String kingdomName = identifierLower.substring(5);
                        result = this.placeholderManager.getKingdomLand(kingdomName);
                    }
                    catch (IndexOutOfBoundsException kingdomName) {}
                    break;
                }
                if (identifierLower.matches("^favor_.+$")) {
                    try {
                        String kingdomName = identifierLower.substring(6);
                        result = this.placeholderManager.getKingdomFavor(kingdomName);
                    }
                    catch (IndexOutOfBoundsException kingdomName) {}
                    break;
                }
                if (identifierLower.matches("^score_.+$")) {
                    try {
                        String kingdomName = identifierLower.substring(6);
                        result = this.placeholderManager.getKingdomScore(kingdomName);
                    }
                    catch (IndexOutOfBoundsException kingdomName) {}
                    break;
                }
                if (identifierLower.matches("^ruin_cooldown_.+$")) {
                    try {
                        String ruinName = identifierLower.substring(14);
                        result = this.placeholderManager.getRuinCooldown(ruinName);
                    }
                    catch (IndexOutOfBoundsException ruinName) {}
                    break;
                }
                if (identifierLower.matches("^ruin_capture_.+$")) {
                    try {
                        String ruinName = identifierLower.substring(13);
                        result = this.placeholderManager.getRuinCapture(ruinName);
                    }
                    catch (IndexOutOfBoundsException ruinName) {}
                    break;
                }
                if (identifierLower.matches("^ruin_criticals_.+$")) {
                    try {
                        String ruinName = identifierLower.substring(15);
                        result = this.placeholderManager.getRuinCriticals(ruinName);
                    }
                    catch (IndexOutOfBoundsException ruinName) {}
                    break;
                }
                if (!identifierLower.matches("^ruin_spawns_.+$")) break;
                try {
                    String ruinName = identifierLower.substring(12);
                    result = this.placeholderManager.getRuinSpawns(ruinName);
                    break;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public String onPlaceholderRequest(Player playerOne, Player playerTwo, String identifier) {
        if (playerOne == null || playerTwo == null) {
            return "";
        }
        String result = null;
        switch (identifier.toLowerCase()) {
            case "relation": {
                result = this.placeholderManager.getRelation(playerOne, playerTwo);
                break;
            }
            case "relation_color": {
                result = this.placeholderManager.getRelationPrimaryColor(playerOne, playerTwo);
                break;
            }
            case "relation2_color": {
                result = this.placeholderManager.getRelationSecondaryColor(playerOne, playerTwo);
                break;
            }
            case "kingdom_webcolor": {
                result = this.placeholderManager.getRelationKingdomWebColor(playerTwo);
                break;
            }
        }
        return result;
    }
}

