/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlaceholderExpansion;
import com.github.rumsfield.konquest.api.KonquestAPI;
import com.github.rumsfield.konquest.hook.WorldGuardExec;
import com.github.rumsfield.konquest.listener.BlockListener;
import com.github.rumsfield.konquest.listener.EntityListener;
import com.github.rumsfield.konquest.listener.HangingListener;
import com.github.rumsfield.konquest.listener.InventoryListener;
import com.github.rumsfield.konquest.listener.PlayerListener;
import com.github.rumsfield.konquest.listener.WorldListener;
import com.github.rumsfield.konquest.manager.GlobalEventManager;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import com.github.rumsfield.konquest.utility.Metrics;
import com.github.rumsfield.konquest.utility.Updater;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class KonquestPlugin
extends JavaPlugin {
    private static final String vaultEconomyWarning = "There is a problem with the economy plugin, %s! Attempting to work around...";
    private static final String vaultEconomyError = "Failed to access the economy plugin %s using Vault API. This is an error in the economy plugin, NOT Konquest.\nSteps to troubleshoot:\n  1. Check for console errors from the economy plugin, did it enable correctly?\n  2. Make sure you only have one economy plugin. Having multiple may cause issues.\n  3. Contact the economy plugin developer to make them aware of this issue.\n  4. Use another economy plugin.\nEconomy Error Message: %s\n";
    private Konquest konquest;
    private PluginManager pluginManager;
    private static Economy econ = null;
    private boolean enableSuccess = false;
    boolean isSetupEconomy = false;
    boolean isSetupMetrics = false;
    boolean isSetupPlaceholders = false;
    boolean isCompatibiltyValidated = false;

    public void onLoad() {
        Plugin worldGuard = Bukkit.getPluginManager().getPlugin("WorldGuard");
        if (worldGuard == null) {
            return;
        }
        boolean registerStatus = WorldGuardExec.load();
        if (registerStatus) {
            ChatUtil.printConsoleAlert("Successfully registered WorldGuard flags.");
        }
    }

    public void onEnable() {
        this.pluginManager = this.getServer().getPluginManager();
        this.konquest = new Konquest(this);
        KonquestPlugin.printLogo();
        this.isSetupEconomy = this.setupEconomy();
        if (!this.isSetupEconomy) {
            this.getLogger().severe(String.format("%s disabled due to bad or missing economy plugin.", this.getDescription().getName()));
            this.pluginManager.disablePlugin((Plugin)this);
            return;
        }
        if (CompatibilityUtil.apiVersion == null) {
            this.getLogger().severe(String.format("%s disabled due to invalid Bukkit API version.", this.getDescription().getName()));
            this.pluginManager.disablePlugin((Plugin)this);
            return;
        }
        this.isSetupMetrics = this.loadMetrics();
        this.registerListeners();
        this.konquest.initialize();
        this.registerApi(this.konquest);
        this.isSetupPlaceholders = this.registerPlaceholders();
        this.isCompatibiltyValidated = CompatibilityUtil.runBIT();
        this.checkForUpdates();
        this.enableSuccess = true;
        this.printEnableStatus();
        ChatUtil.printConsoleAlert("Successfully enabled");
    }

    public void onDisable() {
        if (this.enableSuccess) {
            this.konquest.disable();
        }
    }

    public Konquest getKonquestInstance() {
        return this.konquest;
    }

    private void registerListeners() {
        PluginCommand konquestCommand = this.getCommand("konquest");
        assert (konquestCommand != null);
        konquestCommand.setExecutor((CommandExecutor)this.konquest.getCommandHandler());
        this.pluginManager.registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new EntityListener(this), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new BlockListener(this), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new InventoryListener(this), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new HangingListener(this), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new WorldListener(this), (Plugin)this);
    }

    private void registerApi(KonquestAPI api) {
        this.getServer().getServicesManager().register(KonquestAPI.class, (Object)api, (Plugin)this, ServicePriority.Normal);
    }

    private boolean loadMetrics() {
        try {
            return new Metrics(this, 11980).isEnabled();
        }
        catch (Exception e) {
            ChatUtil.printConsoleError("Failed to load plugin metrics with bStats:");
            ChatUtil.printConsoleError(e.getMessage());
            return false;
        }
    }

    private void checkForUpdates() {
        new Updater(this, 92220).getVersion(version -> {
            if (this.getDescription().getVersion().equalsIgnoreCase((String)version)) {
                ChatUtil.printConsoleAlert("Konquest version is up to date.");
            } else {
                String message = "Konquest version " + version + " is available to download! --> https://www.spigotmc.org/resources/konquest.92220/";
                ChatUtil.printConsoleWarning(message);
                this.konquest.opStatusMessages.add(message);
            }
        });
    }

    private boolean registerPlaceholders() {
        if (this.konquest.getIntegrationManager().getPlaceholderAPI().isEnabled()) {
            new KonquestPlaceholderExpansion(this).register();
            return true;
        }
        return false;
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            ChatUtil.printConsoleError("No Vault dependency found! Include the Vault plugin.");
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            ChatUtil.printConsoleError("No economy service found! Include an economy plugin, like EssentialsX.");
            return false;
        }
        econ = (Economy)rsp.getProvider();
        ChatUtil.printConsoleAlert("Using Economy: " + econ.getName());
        return true;
    }

    public void printVersion() {
        String[] versionInfo;
        String pluginVersion = this.getDescription().getVersion();
        String serverVersion = Bukkit.getServer().getBukkitVersion();
        String lineTemplate = "%-30s -> %s";
        for (String row : versionInfo = new String[]{String.format(lineTemplate, "Konquest Version", String.valueOf(ChatColor.AQUA) + pluginVersion), String.format(lineTemplate, "Server Version", String.valueOf(ChatColor.AQUA) + serverVersion), String.format(lineTemplate, "Server Version Supported", ChatUtil.boolean2status(this.konquest.isVersionSupported()))}) {
            String line = String.valueOf(ChatColor.GOLD) + "> " + String.valueOf(ChatColor.RESET) + row;
            Bukkit.getServer().getConsoleSender().sendMessage(line);
        }
    }

    public static void printLogo() {
        String[] logo;
        for (String row : logo = new String[]{String.valueOf(ChatColor.GOLD) + " _  __                                 _   ", String.valueOf(ChatColor.GOLD) + "| |/ /___  _ __   __ _ _   _  ___  ___| |_ ", String.valueOf(ChatColor.GOLD) + "| ' // _ \\| '_ \\ / _` | | | |/ _ \\/ __| __|", String.valueOf(ChatColor.GOLD) + "| . \\ (_) | | | | (_| | |_| |  __/\\__ \\ |_ ", String.valueOf(ChatColor.GOLD) + "|_|\\_\\___/|_| |_|\\__, |\\__,_|\\___||___/\\__|", String.valueOf(ChatColor.GOLD) + "                    |_|                    ", String.valueOf(ChatColor.GOLD) + "========== Konquest by Rumsfield =========="}) {
            String line = "    " + row;
            Bukkit.getServer().getConsoleSender().sendMessage(line);
        }
    }

    private void printEnableStatus() {
        String lineTemplate = "%-30s -> %s";
        String[] status = new String[]{String.format(lineTemplate, "Anonymous Metrics", ChatUtil.boolean2status(this.isSetupMetrics)), String.format(lineTemplate, "Economy Linked", ChatUtil.boolean2status(this.isSetupEconomy)), String.format(lineTemplate, "Placeholders Registered", ChatUtil.boolean2status(this.isSetupPlaceholders)), String.format(lineTemplate, "Team Colors Registered", ChatUtil.boolean2status(this.konquest.isVersionHandlerEnabled())), String.format(lineTemplate, "Minecraft Version Supported", ChatUtil.boolean2status(this.konquest.isVersionSupported())), String.format(lineTemplate, "API Compatibility Validated", ChatUtil.boolean2status(this.isCompatibiltyValidated))};
        ChatUtil.printConsoleAlert("Final Status...");
        for (String row : status) {
            String line = String.valueOf(ChatColor.GOLD) + "> " + String.valueOf(ChatColor.RESET) + row;
            Bukkit.getServer().getConsoleSender().sendMessage(line);
        }
    }

    public static String getCurrencyFormat(double amount) {
        return econ.format(amount);
    }

    public static double getBalance(OfflinePlayer offlineBukkitPlayer) {
        double result;
        try {
            result = econ.getBalance(offlineBukkitPlayer);
        }
        catch (Exception ignored) {
            ChatUtil.printConsoleWarning(String.format(vaultEconomyWarning, econ.getName()));
            try {
                result = econ.getBalance(offlineBukkitPlayer.getName());
            }
            catch (Exception x) {
                ChatUtil.printConsoleError(String.format(vaultEconomyError, econ.getName(), x.getMessage()));
                x.printStackTrace();
                result = 0.0;
            }
        }
        return result;
    }

    public static boolean withdrawPlayer(OfflinePlayer offlineBukkitPlayer, double amount) {
        return KonquestPlugin.withdrawPlayer(offlineBukkitPlayer, amount, false);
    }

    public static boolean withdrawPlayer(OfflinePlayer offlineBukkitPlayer, double amount, boolean ignoreDiscounts) {
        boolean result = false;
        boolean isOnlinePlayer = offlineBukkitPlayer instanceof Player;
        int discount = 0;
        if (!ignoreDiscounts && isOnlinePlayer) {
            for (PermissionAttachmentInfo p : ((Player)offlineBukkitPlayer).getEffectivePermissions()) {
                String perm = p.getPermission();
                if (!perm.contains("konquest.discount")) continue;
                String[] permArr = perm.split("\\.", 3);
                if (permArr.length == 3) {
                    String valStr = permArr[2];
                    ChatUtil.printDebug("Withdraw discount found: " + valStr);
                    int valNum = 0;
                    try {
                        valNum = Integer.parseInt(valStr);
                    }
                    catch (NumberFormatException e) {
                        ChatUtil.printDebug("Failed to parse discount value");
                    }
                    if (valNum <= discount) continue;
                    discount = valNum;
                    continue;
                }
                ChatUtil.printDebug("Failed to parse malformed discount permission: " + perm);
            }
        }
        double permissionDiscount = (100.0 - (double)discount) / 100.0;
        double eventDiscount = GlobalEventManager.favorDiscountMultiplier;
        double totalDiscountMultiplier = permissionDiscount * eventDiscount;
        double totalDiscountPercent = Math.round(100.0 - totalDiscountMultiplier * 100.0);
        double amountMod = amount;
        if (totalDiscountPercent > 0.0 && totalDiscountPercent <= 100.0) {
            double amountOff = (double)Math.round(amount * totalDiscountPercent) / 100.0;
            amountMod = (double)Math.round((amount - amountOff) * 100.0) / 100.0;
            if (amountOff > 0.0) {
                String percentF = String.format("%.1f", totalDiscountPercent);
                String amountF = econ.format(amountOff);
                if (offlineBukkitPlayer.isOnline()) {
                    ChatUtil.sendNotice((CommandSender)((Player)offlineBukkitPlayer), MessagePath.GENERIC_NOTICE_DISCOUNT_FAVOR.getMessage(percentF, amountF), ChatColor.DARK_AQUA);
                }
            }
        } else if (totalDiscountPercent != 0.0) {
            ChatUtil.printDebug("Failed to apply invalid discount of " + totalDiscountPercent + "%");
        }
        EconomyResponse resp = null;
        try {
            resp = econ.withdrawPlayer(offlineBukkitPlayer, amountMod);
        }
        catch (Exception ignored) {
            ChatUtil.printConsoleWarning(String.format(vaultEconomyWarning, econ.getName()));
            try {
                resp = econ.withdrawPlayer(offlineBukkitPlayer.getName(), amountMod);
            }
            catch (Exception x) {
                ChatUtil.printConsoleError(String.format(vaultEconomyError, econ.getName(), x.getMessage()));
            }
        }
        if (resp != null) {
            if (resp.transactionSuccess()) {
                if (resp.amount > 0.0) {
                    String balanceF = econ.format(resp.balance);
                    String amountF = econ.format(resp.amount);
                    if (isOnlinePlayer) {
                        ChatUtil.sendNotice((CommandSender)((Player)offlineBukkitPlayer), MessagePath.GENERIC_NOTICE_REDUCE_FAVOR.getMessage(amountF, balanceF), ChatColor.DARK_AQUA);
                    }
                    result = true;
                }
            } else if (isOnlinePlayer) {
                ChatUtil.sendError((CommandSender)((Player)offlineBukkitPlayer), MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage(resp.errorMessage));
            }
        } else if (isOnlinePlayer) {
            ChatUtil.sendError((CommandSender)((Player)offlineBukkitPlayer), MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
        }
        return result;
    }

    public static boolean depositPlayer(OfflinePlayer offlineBukkitPlayer, double amount) {
        boolean result = false;
        boolean isOnlinePlayer = offlineBukkitPlayer instanceof Player;
        EconomyResponse resp = null;
        try {
            resp = econ.depositPlayer(offlineBukkitPlayer, amount);
        }
        catch (Exception ignored) {
            ChatUtil.printConsoleWarning(String.format(vaultEconomyWarning, econ.getName()));
            try {
                resp = econ.depositPlayer(offlineBukkitPlayer.getName(), amount);
            }
            catch (Exception x) {
                ChatUtil.printConsoleError(String.format(vaultEconomyError, econ.getName(), x.getMessage()));
            }
        }
        if (resp != null) {
            if (resp.transactionSuccess()) {
                if (resp.amount > 0.0) {
                    String balanceF = econ.format(resp.balance);
                    String amountF = econ.format(resp.amount);
                    if (isOnlinePlayer) {
                        ChatUtil.sendNotice((CommandSender)((Player)offlineBukkitPlayer), MessagePath.GENERIC_NOTICE_REWARD_FAVOR.getMessage(amountF, balanceF), ChatColor.DARK_GREEN);
                    }
                    result = true;
                }
            } else if (isOnlinePlayer) {
                ChatUtil.sendError((CommandSender)((Player)offlineBukkitPlayer), MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage(resp.errorMessage));
            }
        } else if (isOnlinePlayer) {
            ChatUtil.sendError((CommandSender)((Player)offlineBukkitPlayer), MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
        }
        return result;
    }
}

