/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.api.event.server;

import com.github.rumsfield.konquest.api.KonquestAPI;
import com.github.rumsfield.konquest.api.event.KonquestEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import org.bukkit.event.HandlerList;

public class KonquestGlobalEventEndEvent
extends KonquestEvent {
    private static final HandlerList handlers = new HandlerList();
    private final String eventName;
    private final double repetitionDays;
    private final List<String> effectNames;
    private final List<String> effectDescriptions;

    public KonquestGlobalEventEndEvent(KonquestAPI konquest, String eventName, double repetitionDays, List<String> effectNames, List<String> effectDescriptions) {
        super(konquest);
        this.eventName = eventName;
        this.repetitionDays = repetitionDays;
        this.effectNames = effectNames;
        this.effectDescriptions = effectDescriptions;
    }

    public String getGlobalEventName() {
        return this.eventName;
    }

    public double getRepetitionDays() {
        return this.repetitionDays;
    }

    public String getRepetitionDaysFormat() {
        return String.format("%.2f", this.repetitionDays);
    }

    public List<String> getEffectNames() {
        return new ArrayList<String>(this.effectNames);
    }

    public String getEffectNamesFormat() {
        StringBuilder message = new StringBuilder();
        ListIterator<String> listIter = this.effectNames.listIterator();
        while (listIter.hasNext()) {
            String currentValue = listIter.next();
            message.append(currentValue);
            if (!listIter.hasNext()) continue;
            message.append(", ");
        }
        return message.toString();
    }

    public List<String> getEffectDescriptions() {
        return new ArrayList<String>(this.effectDescriptions);
    }

    public String getEffectDescriptionsFormat() {
        StringBuilder message = new StringBuilder();
        ListIterator<String> listIter = this.effectDescriptions.listIterator();
        while (listIter.hasNext()) {
            String currentValue = listIter.next();
            message.append(currentValue);
            if (!listIter.hasNext()) continue;
            message.append(", ");
        }
        return message.toString();
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Override
    @Nonnull
    public HandlerList getHandlers() {
        return handlers;
    }
}

