/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.api.event.server;

import com.github.rumsfield.konquest.api.KonquestAPI;
import com.github.rumsfield.konquest.api.event.KonquestEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import org.bukkit.event.HandlerList;

public class KonquestGlobalEventStartEvent
extends KonquestEvent {
    private static final HandlerList handlers = new HandlerList();
    private final String eventName;
    private final double durationHours;
    private final List<String> effectNames;
    private final List<String> effectDescriptions;

    public KonquestGlobalEventStartEvent(KonquestAPI konquest, String eventName, double durationHours, List<String> effectNames, List<String> effectDescriptions) {
        super(konquest);
        this.eventName = eventName;
        this.durationHours = durationHours;
        this.effectNames = effectNames;
        this.effectDescriptions = effectDescriptions;
    }

    public String getGlobalEventName() {
        return this.eventName;
    }

    public double getDurationHours() {
        return this.durationHours;
    }

    public String getDurationHoursFormat() {
        return String.format("%.2f", this.durationHours);
    }

    public List<String> getEffectNames() {
        return new ArrayList<String>(this.effectNames);
    }

    public String getEffectNamesFormat() {
        StringBuilder message = new StringBuilder();
        ListIterator<String> listIter = this.effectNames.listIterator();
        while (listIter.hasNext()) {
            String currentValue = listIter.next();
            message.append(currentValue);
            if (!listIter.hasNext()) continue;
            message.append(", ");
        }
        return message.toString();
    }

    public List<String> getEffectDescriptions() {
        return new ArrayList<String>(this.effectDescriptions);
    }

    public String getEffectDescriptionsFormat() {
        StringBuilder message = new StringBuilder();
        ListIterator<String> listIter = this.effectDescriptions.listIterator();
        while (listIter.hasNext()) {
            String currentValue = listIter.next();
            message.append(currentValue);
            if (!listIter.hasNext()) continue;
            message.append(", ");
        }
        return message.toString();
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Override
    @Nonnull
    public HandlerList getHandlers() {
        return handlers;
    }
}

