/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;

public class BorderCommand
extends CommandBase {
    public BorderCommand() {
        super("border", true, false);
        this.setOptionalArgs(true);
        List<String> argNames = Arrays.asList("on", "off");
        this.addArgument(this.newArg(argNames, true, false));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        if (args.isEmpty()) {
            if (player.isBorderDisplay()) {
                ChatUtil.sendNotice(player, MessagePath.COMMAND_BORDER_NOTICE_DISABLE.getMessage(new Object[0]));
                player.setIsBorderDisplay(false);
            } else {
                ChatUtil.sendNotice(player, MessagePath.COMMAND_BORDER_NOTICE_ENABLE.getMessage(new Object[0]));
                player.setIsBorderDisplay(true);
            }
        } else {
            String borderMode = args.get(0);
            switch (borderMode.toLowerCase()) {
                case "off": {
                    ChatUtil.sendNotice(player, MessagePath.COMMAND_BORDER_NOTICE_DISABLE.getMessage(new Object[0]));
                    player.setIsBorderDisplay(false);
                    break;
                }
                case "on": {
                    ChatUtil.sendNotice(player, MessagePath.COMMAND_BORDER_NOTICE_ENABLE.getMessage(new Object[0]));
                    player.setIsBorderDisplay(true);
                    break;
                }
                default: {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
            }
        }
        konquest.getTerritoryManager().updatePlayerBorderParticles(player);
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("on");
            tabList.add("off");
        }
        return this.matchLastArgToList(tabList, args);
    }
}

