/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;

public class ChatCommand
extends CommandBase {
    public ChatCommand() {
        super("chat", true, false);
        this.setOptionalArgs(true);
        List<String> argNames = Arrays.asList("global", "kingdom");
        this.addArgument(this.newArg(argNames, true, false));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        boolean isChatFormatEnabled = konquest.getCore().getBoolean(CorePath.CHAT_ENABLE_FORMAT.getPath(), true);
        if (!isChatFormatEnabled) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
            player.setIsGlobalChat(true);
            return;
        }
        if (player.isBarbarian()) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DENY_BARBARIAN.getMessage(new Object[0]));
            return;
        }
        if (args.isEmpty()) {
            if (player.isGlobalChat()) {
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_CHAT_NOTICE_ENABLE.getMessage(new Object[0]));
                player.setIsGlobalChat(false);
            } else {
                ChatUtil.sendNotice(sender, MessagePath.COMMAND_CHAT_NOTICE_DISABLE.getMessage(new Object[0]));
                player.setIsGlobalChat(true);
            }
        } else {
            String chatMode = args.get(0);
            switch (chatMode.toLowerCase()) {
                case "kingdom": {
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_CHAT_NOTICE_ENABLE.getMessage(new Object[0]));
                    player.setIsGlobalChat(false);
                    break;
                }
                case "global": {
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_CHAT_NOTICE_DISABLE.getMessage(new Object[0]));
                    player.setIsGlobalChat(true);
                    break;
                }
                default: {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
            }
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("global");
            tabList.add("kingdom");
        }
        return this.matchLastArgToList(tabList, args);
    }
}

