/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import java.util.ArrayList;
import java.util.List;

public class CommandArgument {
    private final ArrayList<String> argNames = new ArrayList();
    private final boolean isArgLiteral;
    private final boolean hasOptionalSubArg;
    private final ArrayList<CommandArgument> subArguments = new ArrayList();

    public CommandArgument(String arg, boolean isLiteral, boolean hasOptional) {
        this.argNames.add(arg);
        this.isArgLiteral = isLiteral;
        this.hasOptionalSubArg = hasOptional;
    }

    public CommandArgument(List<String> arg, boolean isLiteral, boolean hasOptional) {
        this.argNames.addAll(arg);
        this.isArgLiteral = isLiteral;
        this.hasOptionalSubArg = hasOptional;
    }

    public ArrayList<String> getNames() {
        return this.argNames;
    }

    public boolean matchesName(String name) {
        for (String testName : this.argNames) {
            if (!testName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isArgLiteral() {
        return this.isArgLiteral;
    }

    public boolean hasOptionalSubArg() {
        return this.hasOptionalSubArg;
    }

    public CommandArgument sub(CommandArgument subArg) {
        if (subArg != null && !subArg.getNames().isEmpty() && !this.subArguments.contains(subArg)) {
            this.subArguments.add(subArg);
        }
        return this;
    }

    public List<String> getUsageStrings(boolean isOptional) {
        ArrayList<String> usageStrings = new ArrayList<String>();
        StringBuilder localBuilder = new StringBuilder();
        if (isOptional) {
            localBuilder.append("[");
        }
        for (int i = 0; i < this.argNames.size(); ++i) {
            String option = this.argNames.get(i);
            if (this.isArgLiteral) {
                localBuilder.append(option);
            } else {
                localBuilder.append("<").append(option).append(">");
            }
            if (i == this.argNames.size() - 1) continue;
            localBuilder.append("|");
        }
        if (isOptional) {
            localBuilder.append("]");
        }
        String localArgUsage = localBuilder.toString();
        if (this.subArguments.isEmpty()) {
            usageStrings.add(localArgUsage);
        } else {
            ArrayList<String> subUsageStrings = new ArrayList<String>();
            for (int i = 0; i < this.subArguments.size(); ++i) {
                if (i == 0) {
                    subUsageStrings.addAll(this.subArguments.get(i).getUsageStrings(this.hasOptionalSubArg));
                    continue;
                }
                subUsageStrings.addAll(this.subArguments.get(i).getUsageStrings(false));
            }
            for (String subArg : subUsageStrings) {
                usageStrings.add(localArgUsage + " " + subArg);
            }
        }
        return usageStrings;
    }
}

