/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandArgument;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public abstract class CommandBase {
    private final String cmdName;
    private final boolean isPlayerOnly;
    private final boolean isAdmin;
    private final ArrayList<CommandArgument> arguments;
    private boolean hasOptionalArgs;

    public CommandBase(String name, boolean isPlayerOnly, boolean isAdmin) {
        this.cmdName = name;
        this.isPlayerOnly = isPlayerOnly;
        this.isAdmin = isAdmin;
        this.arguments = new ArrayList();
        this.hasOptionalArgs = false;
    }

    public String getName() {
        return this.cmdName;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean hasOptionalArgs() {
        return this.hasOptionalArgs;
    }

    public void setOptionalArgs(boolean val) {
        this.hasOptionalArgs = val;
    }

    public boolean isSenderAllowed(CommandSender sender) {
        if (this.isPlayerOnly) {
            return sender instanceof Player;
        }
        return sender instanceof Player || sender instanceof ConsoleCommandSender;
    }

    public CommandArgument newArg(String arg, boolean isLiteral, boolean hasOptional) {
        return new CommandArgument(arg, isLiteral, hasOptional);
    }

    public CommandArgument newArg(List<String> arg, boolean isLiteral, boolean hasOptional) {
        return new CommandArgument(arg, isLiteral, hasOptional);
    }

    public void addArgument(CommandArgument argument) {
        this.arguments.add(argument);
    }

    private String getBase() {
        if (this.isAdmin) {
            return "/k admin ";
        }
        return "/k ";
    }

    public String getBaseUsage() {
        return String.valueOf(ChatColor.GOLD) + this.getBase() + this.cmdName.toLowerCase();
    }

    public List<String> getArgumentUsage() {
        ArrayList<String> usageStrings = new ArrayList<String>();
        if (this.hasOptionalArgs || this.arguments.isEmpty()) {
            usageStrings.add(this.getBaseUsage());
        }
        for (CommandArgument cmdArg : this.arguments) {
            for (String argUsage : cmdArg.getUsageStrings(this.hasOptionalArgs)) {
                usageStrings.add(this.getBaseUsage() + " " + String.valueOf(ChatColor.AQUA) + this.formatUsageString(argUsage));
            }
        }
        return usageStrings;
    }

    public List<String> getArgumentUsage(String subArg) {
        ArrayList<String> usageStrings = new ArrayList<String>();
        for (CommandArgument cmdArg : this.arguments) {
            if (!cmdArg.matchesName(subArg)) continue;
            for (String argUsage : cmdArg.getUsageStrings(this.hasOptionalArgs)) {
                usageStrings.add(this.getBaseUsage() + " " + String.valueOf(ChatColor.AQUA) + this.formatUsageString(argUsage));
            }
        }
        return usageStrings;
    }

    private String formatUsageString(String inArgs) {
        return inArgs.replaceAll("<", String.valueOf(ChatColor.GRAY) + "<" + String.valueOf(ChatColor.AQUA)).replaceAll(">", String.valueOf(ChatColor.GRAY) + ">" + String.valueOf(ChatColor.AQUA)).replaceAll("\\|", String.valueOf(ChatColor.GRAY) + "|" + String.valueOf(ChatColor.AQUA)).replaceAll("]", String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.AQUA)).replaceAll("\\[", String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.AQUA));
    }

    public abstract void execute(Konquest var1, CommandSender var2, List<String> var3);

    public abstract List<String> tabComplete(Konquest var1, CommandSender var2, List<String> var3);

    public void sendInvalidArgMessage(CommandSender sender) {
        if (this.isAdmin) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_PARAMETERS_ADMIN.getMessage(new Object[0]));
        } else {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INVALID_PARAMETERS.getMessage(new Object[0]));
        }
    }

    public void sendInvalidSenderMessage(CommandSender sender) {
        ChatUtil.printDebug("Command executed with null player", true);
        ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
    }

    public List<String> matchLastArgToList(List<String> completions, List<String> args) {
        ArrayList<String> matchedCompletions = new ArrayList<String>();
        if (!args.isEmpty()) {
            StringUtil.copyPartialMatches((String)args.get(args.size() - 1), completions, matchedCompletions);
            Collections.sort(matchedCompletions);
        }
        return matchedCompletions;
    }

    public String formatStringListLimited(List<String> entries, int limit) {
        StringBuilder entryListBuilder = new StringBuilder();
        String nameColor = String.valueOf(ChatColor.AQUA);
        String sepColor = String.valueOf(ChatColor.GRAY);
        for (int i = 0; i < entries.size(); ++i) {
            if (i < limit) {
                entryListBuilder.append(nameColor).append(entries.get(i));
                if (i == entries.size() - 1) continue;
                entryListBuilder.append(sepColor).append(", ");
                continue;
            }
            int numRemaining = entries.size() - limit;
            entryListBuilder.append(sepColor).append("... (").append(numRemaining).append(")");
            break;
        }
        return entryListBuilder.toString();
    }

    public boolean validateSender(CommandSender sender) {
        return !this.isPlayerOnly || sender instanceof Player;
    }
}

