/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.command.CommandType;
import com.github.rumsfield.konquest.command.KonquestCommand;
import com.github.rumsfield.konquest.command.admin.AdminCommandType;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class CommandHandler
implements TabExecutor {
    private final Konquest konquest;

    public CommandHandler(Konquest konquest) {
        this.konquest = konquest;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        if (arguments.isEmpty() || ((String)arguments.get(0)).isEmpty()) {
            new KonquestCommand().execute(this.konquest, sender, Collections.emptyList());
            return true;
        }
        String konquestCommandName = (String)arguments.remove(0);
        if (sender instanceof ConsoleCommandSender) {
            if (konquestCommandName.equalsIgnoreCase("reload")) {
                this.konquest.reload();
                ChatUtil.printConsoleAlert(MessagePath.COMMAND_ADMIN_RELOAD_NOTICE_MESSAGE.getMessage(new Object[0]));
                return true;
            }
            if (konquestCommandName.equalsIgnoreCase("save")) {
                this.konquest.save();
                ChatUtil.printConsoleAlert(MessagePath.COMMAND_ADMIN_SAVE_NOTICE_MESSAGE.getMessage(new Object[0]));
                return true;
            }
            if (konquestCommandName.equalsIgnoreCase("version")) {
                this.konquest.getPlugin().printVersion();
                return true;
            }
        }
        if (!sender.hasPermission("konquest.command")) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_PERMISSION.getMessage(new Object[0]) + " konquest.command");
            return true;
        }
        CommandType commandType = CommandType.getCommand(konquestCommandName);
        if (!commandType.isSenderHasPermission(sender)) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_PERMISSION.getMessage(new Object[0]) + " " + commandType.permission());
            return true;
        }
        CommandBase konquestCommand = commandType.command();
        if (!konquestCommand.validateSender(sender)) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_NO_PLAYER.getMessage(new Object[0]));
            return true;
        }
        try {
            konquestCommand.execute(this.konquest, sender, arguments);
        }
        catch (Error | Exception me) {
            String message = "Failed to execute command " + commandType.toString();
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage(message));
            ChatUtil.printConsoleError(message);
            me.printStackTrace();
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        String konquestCommandName;
        CommandType commandArg;
        if (!sender.hasPermission("konquest.command")) {
            return Collections.emptyList();
        }
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        ArrayList<String> tabList = new ArrayList<String>();
        if (arguments.size() == 1) {
            String konquestCommandName2 = (String)arguments.get(0);
            ArrayList<String> baseList = new ArrayList<String>();
            block2: for (CommandType cmd : CommandType.values()) {
                String suggestion = cmd.toString().toLowerCase();
                if (cmd.equals((Object)CommandType.ADMIN)) {
                    for (AdminCommandType subcmd : AdminCommandType.values()) {
                        if (!sender.hasPermission(subcmd.permission())) continue;
                        baseList.add(suggestion);
                        continue block2;
                    }
                    continue;
                }
                if (!sender.hasPermission(cmd.permission())) continue;
                baseList.add(suggestion);
            }
            StringUtil.copyPartialMatches((String)konquestCommandName2, baseList, tabList);
            Collections.sort(tabList);
        } else if (arguments.size() > 1 && (commandArg = CommandType.getCommand(konquestCommandName = (String)arguments.remove(0))).isSenderHasPermission(sender)) {
            try {
                tabList.addAll(commandArg.command().tabComplete(this.konquest, sender, arguments));
            }
            catch (Error | Exception me) {
                String message = "Failed to tab-complete command " + commandArg.toString();
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage(message));
                ChatUtil.printConsoleError(message);
                me.printStackTrace();
            }
        }
        return tabList;
    }
}

