/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.command.BorderCommand;
import com.github.rumsfield.konquest.command.ChatCommand;
import com.github.rumsfield.konquest.command.ClaimCommand;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.command.EventCommand;
import com.github.rumsfield.konquest.command.FavorCommand;
import com.github.rumsfield.konquest.command.FlyCommand;
import com.github.rumsfield.konquest.command.HelpCommand;
import com.github.rumsfield.konquest.command.InfoCommand;
import com.github.rumsfield.konquest.command.KingdomCommand;
import com.github.rumsfield.konquest.command.ListCommand;
import com.github.rumsfield.konquest.command.MapCommand;
import com.github.rumsfield.konquest.command.MenuCommand;
import com.github.rumsfield.konquest.command.PrefixCommand;
import com.github.rumsfield.konquest.command.QuestCommand;
import com.github.rumsfield.konquest.command.ScoreCommand;
import com.github.rumsfield.konquest.command.SettleCommand;
import com.github.rumsfield.konquest.command.SpyCommand;
import com.github.rumsfield.konquest.command.StatsCommand;
import com.github.rumsfield.konquest.command.TownCommand;
import com.github.rumsfield.konquest.command.TravelCommand;
import com.github.rumsfield.konquest.command.UnclaimCommand;
import com.github.rumsfield.konquest.command.admin.AdminCommand;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;

public enum CommandType {
    HELP(Material.LANTERN, "konquest.command.help", "h", new HelpCommand(), MessagePath.DESCRIPTION_HELP.getMessage(new Object[0])),
    MENU(Material.BELL, "konquest.command.menu", "", new MenuCommand(), MessagePath.DESCRIPTION_MENU.getMessage(new Object[0])),
    INFO(Material.SPRUCE_SIGN, "konquest.command.info", "i", new InfoCommand(), MessagePath.DESCRIPTION_INFO.getMessage(new Object[0])),
    LIST(Material.PAPER, "konquest.command.list", "l", new ListCommand(), MessagePath.DESCRIPTION_LIST.getMessage(new Object[0])),
    KINGDOM(Material.DIAMOND_HELMET, "konquest.command.kingdom", "k", new KingdomCommand(), MessagePath.DESCRIPTION_KINGDOM.getMessage(new Object[0])),
    TOWN(Material.OBSIDIAN, "konquest.command.town", "t", new TownCommand(), MessagePath.DESCRIPTION_TOWN.getMessage(new Object[0])),
    MAP(Material.FILLED_MAP, "konquest.command.map", "m", new MapCommand(), MessagePath.DESCRIPTION_MAP.getMessage(new Object[0])),
    SETTLE(Material.DIAMOND_PICKAXE, "konquest.command.settle", "", new SettleCommand(), MessagePath.DESCRIPTION_SETTLE.getMessage(new Object[0])),
    CLAIM(Material.DIAMOND_SHOVEL, "konquest.command.claim", "", new ClaimCommand(), MessagePath.DESCRIPTION_CLAIM.getMessage(new Object[0])),
    UNCLAIM(Material.COBWEB, "konquest.command.unclaim", "", new UnclaimCommand(), MessagePath.DESCRIPTION_UNCLAIM.getMessage(new Object[0])),
    TRAVEL(Material.COMPASS, "konquest.command.travel", "v", new TravelCommand(), MessagePath.DESCRIPTION_TRAVEL.getMessage(new Object[0])),
    CHAT(Material.ENDER_CHEST, "konquest.command.chat", "c", new ChatCommand(), MessagePath.DESCRIPTION_CHAT.getMessage(new Object[0])),
    SPY(Material.ENDER_EYE, "konquest.command.spy", "", new SpyCommand(), MessagePath.DESCRIPTION_SPY.getMessage(new Object[0])),
    FAVOR(Material.GOLD_INGOT, "konquest.command.favor", "f", new FavorCommand(), MessagePath.DESCRIPTION_FAVOR.getMessage(new Object[0])),
    EVENT(Material.CLOCK, "konquest.command.event", "e", new EventCommand(), MessagePath.DESCRIPTION_EVENT.getMessage(new Object[0])),
    SCORE(Material.GOLDEN_CARROT, "konquest.command.score", "", new ScoreCommand(), MessagePath.DESCRIPTION_SCORE.getMessage(new Object[0])),
    QUEST(Material.WRITABLE_BOOK, "konquest.command.quest", "q", new QuestCommand(), MessagePath.DESCRIPTION_QUEST.getMessage(new Object[0])),
    STATS(Material.BOOK, "konquest.command.stats", "s", new StatsCommand(), MessagePath.DESCRIPTION_STATS.getMessage(new Object[0])),
    PREFIX(Material.NAME_TAG, "konquest.command.prefix", "p", new PrefixCommand(), MessagePath.DESCRIPTION_PREFIX.getMessage(new Object[0])),
    BORDER(Material.SPRUCE_FENCE, "konquest.command.border", "b", new BorderCommand(), MessagePath.DESCRIPTION_BORDER.getMessage(new Object[0])),
    FLY(Material.ELYTRA, "konquest.command.fly", "", new FlyCommand(), MessagePath.DESCRIPTION_FLY.getMessage(new Object[0])),
    ADMIN(Material.NETHER_STAR, "", "", new AdminCommand(), MessagePath.DESCRIPTION_ADMIN.getMessage(new Object[0]));

    private final Material iconMaterial;
    private final String permission;
    private final String alias;
    private final CommandBase command;
    private final String description;

    private CommandType(Material iconMaterial, String permission, String alias, CommandBase command, String description) {
        this.iconMaterial = iconMaterial;
        this.permission = permission;
        this.command = command;
        this.description = description;
        this.alias = alias;
    }

    public Material iconMaterial() {
        return this.iconMaterial;
    }

    public String permission() {
        return this.permission;
    }

    public CommandBase command() {
        return this.command;
    }

    public String description() {
        return this.description;
    }

    public String alias() {
        return this.alias;
    }

    public boolean isSenderHasPermission(CommandSender sender) {
        if (this.permission.isEmpty()) {
            return true;
        }
        return sender.hasPermission(this.permission);
    }

    public boolean isSenderAllowed(CommandSender sender) {
        return this.command.isSenderAllowed(sender);
    }

    public String baseUsage() {
        return this.command.getBaseUsage();
    }

    public List<String> argumentUsage() {
        return this.command.getArgumentUsage();
    }

    public static CommandType getCommand(String command) {
        CommandType result = HELP;
        for (CommandType cmd : CommandType.values()) {
            if (!cmd.toString().equalsIgnoreCase(command) && (cmd.alias().equals("") || !cmd.alias().equalsIgnoreCase(command))) continue;
            result = cmd;
        }
        return result;
    }

    public static boolean contains(String command) {
        boolean result = false;
        for (CommandType cmd : CommandType.values()) {
            if (!cmd.toString().equalsIgnoreCase(command)) continue;
            result = true;
        }
        return result;
    }
}

