/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.manager.DisplayManager;
import com.github.rumsfield.konquest.model.KonGlobalEvent;
import com.github.rumsfield.konquest.model.KonGlobalEventEffect;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;

public class EventCommand
extends CommandBase {
    public EventCommand() {
        super("event", false, false);
        this.setOptionalArgs(true);
        this.addArgument(this.newArg("menu", true, false));
        this.addArgument(this.newArg("effects", true, false));
        this.addArgument(this.newArg("list", false, true).sub(this.newArg("page", false, false)));
        this.addArgument(this.newArg("info", true, true).sub(this.newArg("name", false, false)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        if (!konquest.getGlobalEventManager().isEnabled()) {
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
            return;
        }
        int MAX_LINES_PER_PAGE = 6;
        String messagePrefix = "> ";
        String lineTemplate = String.valueOf(ChatColor.GOLD) + "> " + String.valueOf(ChatColor.YELLOW) + "%s" + String.valueOf(ChatColor.WHITE) + " = " + String.valueOf(ChatColor.AQUA) + "%s";
        if (args.isEmpty()) {
            KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
            if (player == null) {
                this.sendInvalidSenderMessage(sender);
                return;
            }
            konquest.getDisplayManager().displayEventMenu(player);
        } else {
            switch (args.get(0).toLowerCase()) {
                case "menu": {
                    KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
                    if (player == null) {
                        this.sendInvalidSenderMessage(sender);
                        return;
                    }
                    konquest.getDisplayManager().displayEventMenu(player);
                    break;
                }
                case "effects": {
                    ArrayList<CallSite> effectLines = new ArrayList<CallSite>();
                    for (KonGlobalEventEffect effect : KonGlobalEventEffect.values()) {
                        String effectTitle = effect.getTitle();
                        String effectDescription = effect.getDescription();
                        String validDisplayText = konquest.getGlobalEventManager().isEffectValid(effect) ? (sender instanceof ConsoleCommandSender ? String.valueOf(ChatColor.DARK_GREEN) + "+" + String.valueOf(ChatColor.LIGHT_PURPLE) : DisplayManager.boolean2Symbol(true) + String.valueOf(ChatColor.LIGHT_PURPLE)) : (sender instanceof ConsoleCommandSender ? String.valueOf(ChatColor.DARK_RED) + "-" + String.valueOf(ChatColor.AQUA) : DisplayManager.boolean2Symbol(false) + String.valueOf(ChatColor.AQUA));
                        effectLines.add((CallSite)((Object)(validDisplayText + " " + effectTitle + String.valueOf(ChatColor.WHITE) + " - " + effectDescription)));
                    }
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_EVENT_NOTICE_EFFECTS.getMessage(new Object[0]));
                    for (String string : effectLines) {
                        ChatUtil.sendMessage(sender, "> " + string, ChatColor.GOLD);
                    }
                    break;
                }
                case "list": {
                    ArrayList<KonGlobalEvent> events = konquest.getGlobalEventManager().getSortedEvents();
                    if (events.isEmpty()) {
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_EVENT_NOTICE_NO_EVENTS.getMessage(new Object[0]));
                        return;
                    }
                    ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
                    int linePos = 1;
                    for (KonGlobalEvent event : events) {
                        String dateInfo;
                        ChatColor eventColor = ChatColor.AQUA;
                        if (event.isActive()) {
                            eventColor = event.isEnabled() ? ChatColor.LIGHT_PURPLE : ChatColor.GRAY;
                            dateInfo = MessagePath.COMMAND_EVENT_NOTICE_ENDS.getMessage(event.getNextEndDateFormat());
                        } else {
                            dateInfo = MessagePath.COMMAND_EVENT_NOTICE_STARTS.getMessage(event.getNextStartDateFormat());
                        }
                        String message = String.valueOf(ChatColor.YELLOW) + linePos + ") " + String.valueOf(eventColor) + event.getName() + " " + dateInfo;
                        arrayList.add((CallSite)((Object)message));
                        ++linePos;
                    }
                    int numLines = arrayList.size();
                    int maxPages = (int)Math.ceil((double)numLines / 6.0);
                    int page = 1;
                    if (args.size() == 2) {
                        try {
                            page = Integer.parseInt(args.get(1));
                        }
                        catch (NumberFormatException ignored) {
                            ChatUtil.sendError(sender, MessagePath.COMMAND_HELP_ERROR_PAGE.getMessage(new Object[0]));
                            this.sendInvalidArgMessage(sender);
                            return;
                        }
                        page = Math.max(page, 1);
                        page = Math.min(page, maxPages);
                    }
                    String pageDisplay = page + "/" + maxPages;
                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_EVENT_NOTICE_EVENTS.getMessage(pageDisplay));
                    if (page == 1 && maxPages > 1) {
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_EVENT_NOTICE_PAGE.getMessage(new Object[0]));
                    }
                    int startIdx = (page - 1) * 6;
                    int endIdx = startIdx + 6;
                    for (int i = startIdx; i < endIdx && i < numLines; ++i) {
                        ChatUtil.sendMessage(sender, "> " + (String)arrayList.get(i), ChatColor.GOLD);
                    }
                    break;
                }
                case "info": {
                    if (args.size() == 1) {
                        ArrayList<KonGlobalEvent> activeEvents = konquest.getGlobalEventManager().getEvents(true);
                        KonGlobalEvent nextEvent = konquest.getGlobalEventManager().getNextEvent();
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_EVENT_NOTICE_INFO.getMessage(new Object[0]));
                        if (activeEvents.isEmpty()) {
                            ChatUtil.sendMessage(sender, String.valueOf(ChatColor.GOLD) + "> " + String.valueOf(ChatColor.YELLOW) + MessagePath.COMMAND_EVENT_NOTICE_INFO_NO_ACTIVE.getMessage(new Object[0]));
                        } else {
                            void var23_44;
                            ChatUtil.sendMessage(sender, String.valueOf(ChatColor.GOLD) + "> " + String.valueOf(ChatColor.YELLOW) + MessagePath.COMMAND_EVENT_NOTICE_INFO_EFFECTS.getMessage(new Object[0]));
                            ArrayList<String> enabledEffectNames = new ArrayList<String>();
                            for (KonGlobalEventEffect effect : konquest.getGlobalEventManager().getValidEffects()) {
                                enabledEffectNames.add(effect.getTitle());
                            }
                            String string = MessagePath.LABEL_NONE.getMessage(new Object[0]);
                            if (!enabledEffectNames.isEmpty()) {
                                String string2 = HelperUtil.formatCommaSeparatedList(enabledEffectNames);
                            }
                            ChatUtil.sendMessage(sender, "  " + (String)var23_44, ChatColor.LIGHT_PURPLE);
                            ChatUtil.sendMessage(sender, String.valueOf(ChatColor.GOLD) + "> " + String.valueOf(ChatColor.YELLOW) + MessagePath.COMMAND_EVENT_NOTICE_INFO_EVENTS.getMessage(new Object[0]));
                            int eventPos = 1;
                            for (KonGlobalEvent globalEvent : activeEvents) {
                                if (!globalEvent.isEnabled()) continue;
                                ChatUtil.sendMessage(sender, "  " + eventPos + ") " + String.valueOf(ChatColor.LIGHT_PURPLE) + globalEvent.getName() + " " + MessagePath.COMMAND_EVENT_NOTICE_ENDS.getMessage(globalEvent.getNextEndDateFormat()));
                                ++eventPos;
                            }
                        }
                        if (nextEvent == null) {
                            ChatUtil.sendMessage(sender, String.valueOf(ChatColor.GOLD) + "> " + String.valueOf(ChatColor.YELLOW) + MessagePath.COMMAND_EVENT_NOTICE_INFO_NO_UPCOMING.getMessage(new Object[0]));
                            break;
                        }
                        ChatUtil.sendMessage(sender, String.valueOf(ChatColor.GOLD) + "> " + String.valueOf(ChatColor.YELLOW) + MessagePath.COMMAND_EVENT_NOTICE_INFO_NEXT.getMessage(new Object[0]));
                        ChatUtil.sendMessage(sender, "  " + String.valueOf(ChatColor.AQUA) + nextEvent.getName() + " " + MessagePath.COMMAND_EVENT_NOTICE_STARTS.getMessage(nextEvent.getNextStartDateFormat()));
                        break;
                    }
                    if (args.size() == 2) {
                        void var23_48;
                        String[] eventInfo;
                        String eventName = args.get(1);
                        KonGlobalEvent globalEvent = konquest.getGlobalEventManager().getEvent(eventName);
                        if (globalEvent == null) {
                            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(eventName));
                            return;
                        }
                        ArrayList<String> eventEffectNames = new ArrayList<String>();
                        for (KonGlobalEventEffect effect : KonGlobalEventEffect.values()) {
                            if (!globalEvent.hasEffect(effect)) continue;
                            eventEffectNames.add(effect.getTitle());
                        }
                        String string = MessagePath.LABEL_NONE.getMessage(new Object[0]);
                        if (!eventEffectNames.isEmpty()) {
                            String string3 = HelperUtil.formatCommaSeparatedList(eventEffectNames);
                        }
                        ChatUtil.sendNotice(sender, MessagePath.COMMAND_EVENT_NOTICE_DETAILS.getMessage(new Object[0]));
                        for (String line : eventInfo = new String[]{String.format(lineTemplate, MessagePath.COMMAND_EVENT_PROPERTY_NAME.getMessage(new Object[0]), globalEvent.getName()), String.format(lineTemplate, MessagePath.LABEL_ENABLED.getMessage(new Object[0]), globalEvent.isEnabled()), String.format(lineTemplate, MessagePath.LABEL_ACTIVE.getMessage(new Object[0]), globalEvent.isActive()), String.format(lineTemplate, MessagePath.COMMAND_EVENT_PROPERTY_DURATION.getMessage(new Object[0]), String.format("%.2f", globalEvent.getDurationHours())), String.format(lineTemplate, MessagePath.COMMAND_EVENT_PROPERTY_REPETITION.getMessage(new Object[0]), String.format("%.2f", globalEvent.getRepetitionDays())), String.format(lineTemplate, MessagePath.COMMAND_EVENT_PROPERTY_START_INITIAL.getMessage(new Object[0]), globalEvent.getStartDateFormat()), String.format(lineTemplate, MessagePath.COMMAND_EVENT_PROPERTY_START_NEXT.getMessage(new Object[0]), globalEvent.getNextStartDateFormat()), String.format(lineTemplate, MessagePath.COMMAND_EVENT_PROPERTY_END_NEXT.getMessage(new Object[0]), globalEvent.getNextEndDateFormat()), String.format(lineTemplate, MessagePath.COMMAND_EVENT_PROPERTY_EFFECTS.getMessage(new Object[0]), var23_48)}) {
                            ChatUtil.sendMessage(sender, line);
                        }
                        break;
                    }
                    this.sendInvalidArgMessage(sender);
                    break;
                }
                default: {
                    this.sendInvalidArgMessage(sender);
                }
            }
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("menu");
            tabList.add("effects");
            tabList.add("list");
            tabList.add("info");
        } else if (args.size() == 2) {
            switch (args.get(0).toLowerCase()) {
                case "list": {
                    tabList.add("#");
                    break;
                }
                case "info": {
                    tabList.addAll(konquest.getGlobalEventManager().getEventNames());
                }
            }
        }
        return this.matchLastArgToList(tabList, args);
    }
}

