/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FavorCommand
extends CommandBase {
    public FavorCommand() {
        super("favor", true, false);
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        if (!args.isEmpty()) {
            this.sendInvalidArgMessage(sender);
            return;
        }
        Player bukkitPlayer = player.getBukkitPlayer();
        double balance = KonquestPlugin.getBalance((OfflinePlayer)bukkitPlayer);
        double cost_spy = konquest.getCore().getDouble(CorePath.FAVOR_COST_SPY.getPath(), 0.0);
        double cost_settle = konquest.getCore().getDouble(CorePath.FAVOR_TOWNS_COST_SETTLE.getPath(), 0.0);
        double cost_settle_incr = konquest.getCore().getDouble(CorePath.FAVOR_TOWNS_COST_SETTLE_INCREMENT.getPath(), 0.0);
        boolean isIncrementKingdom = konquest.getCore().getBoolean(CorePath.TOWNS_SETTLE_INCREMENT_KINGDOM.getPath(), false);
        int townCount = isIncrementKingdom ? player.getKingdom().getNumTowns() : konquest.getKingdomManager().getPlayerLordships(player);
        double cost_settle_adj = (double)townCount * cost_settle_incr + cost_settle;
        double cost_town_rename = konquest.getCore().getDouble(CorePath.FAVOR_TOWNS_COST_RENAME.getPath(), 0.0);
        double cost_claim = konquest.getCore().getDouble(CorePath.FAVOR_COST_CLAIM.getPath(), 0.0);
        double cost_travel = konquest.getCore().getDouble(CorePath.FAVOR_COST_TRAVEL.getPath(), 0.0);
        double cost_kingdom_create = konquest.getKingdomManager().getCostCreate();
        double cost_kingdom_rename = konquest.getKingdomManager().getCostRename();
        double cost_capital_swap = konquest.getKingdomManager().getCostCapitalSwap();
        ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_FAVOR_NOTICE_MESSAGE.getMessage(KonquestPlugin.getCurrencyFormat(balance)));
        ChatUtil.sendMessage((CommandSender)bukkitPlayer, MessagePath.COMMAND_FAVOR_NOTICE_COST_SPY.getMessage(new Object[0]) + " - " + String.valueOf(ChatColor.AQUA) + KonquestPlugin.getCurrencyFormat(cost_spy));
        ChatUtil.sendMessage((CommandSender)bukkitPlayer, MessagePath.COMMAND_FAVOR_NOTICE_COST_TRAVEL.getMessage(new Object[0]) + " - " + String.valueOf(ChatColor.AQUA) + KonquestPlugin.getCurrencyFormat(cost_travel));
        ChatUtil.sendMessage((CommandSender)bukkitPlayer, MessagePath.COMMAND_FAVOR_NOTICE_COST_CLAIM.getMessage(new Object[0]) + " - " + String.valueOf(ChatColor.AQUA) + KonquestPlugin.getCurrencyFormat(cost_claim));
        ChatUtil.sendMessage((CommandSender)bukkitPlayer, MessagePath.COMMAND_FAVOR_NOTICE_COST_TOWN_SETTLE.getMessage(new Object[0]) + " - " + String.valueOf(ChatColor.AQUA) + KonquestPlugin.getCurrencyFormat(cost_settle_adj));
        ChatUtil.sendMessage((CommandSender)bukkitPlayer, MessagePath.COMMAND_FAVOR_NOTICE_COST_TOWN_RENAME.getMessage(new Object[0]) + " - " + String.valueOf(ChatColor.AQUA) + KonquestPlugin.getCurrencyFormat(cost_town_rename));
        ChatUtil.sendMessage((CommandSender)bukkitPlayer, MessagePath.COMMAND_FAVOR_NOTICE_COST_KINGDOM_CREATE.getMessage(new Object[0]) + " - " + String.valueOf(ChatColor.AQUA) + KonquestPlugin.getCurrencyFormat(cost_kingdom_create));
        ChatUtil.sendMessage((CommandSender)bukkitPlayer, MessagePath.COMMAND_FAVOR_NOTICE_COST_KINGDOM_RENAME.getMessage(new Object[0]) + " - " + String.valueOf(ChatColor.AQUA) + KonquestPlugin.getCurrencyFormat(cost_kingdom_rename));
        if (konquest.getKingdomManager().getIsCapitalSwapEnable()) {
            ChatUtil.sendMessage((CommandSender)bukkitPlayer, MessagePath.COMMAND_FAVOR_NOTICE_COST_CAPITAL_SWAP.getMessage(new Object[0]) + " - " + String.valueOf(ChatColor.AQUA) + KonquestPlugin.getCurrencyFormat(cost_capital_swap));
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        return Collections.emptyList();
    }
}

