/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class InfoCommand
extends CommandBase {
    public InfoCommand() {
        super("info", true, false);
        this.setOptionalArgs(true);
        this.addArgument(this.newArg("menu", true, false));
        List<String> argNames = Arrays.asList("player", "kingdom", "capital", "town", "sanctuary", "ruin", "camp", "template");
        this.addArgument(this.newArg(argNames, true, false).sub(this.newArg("name", false, false)));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            ChatUtil.printDebug("Command executed with null player", true);
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
            return;
        }
        if (args.isEmpty()) {
            konquest.getDisplayManager().displayInfoMenu(player);
        } else if (args.size() == 1) {
            String infoType = args.get(0);
            if (infoType.equalsIgnoreCase("menu")) {
                konquest.getDisplayManager().displayInfoMenu(player);
            } else {
                this.sendInvalidArgMessage(sender);
            }
        } else if (args.size() == 2) {
            String infoType = args.get(0);
            String infoName = args.get(1);
            switch (infoType.toLowerCase()) {
                case "player": {
                    KonOfflinePlayer otherPlayer = konquest.getPlayerManager().getOfflinePlayerFromName(infoName);
                    if (otherPlayer == null) break;
                    konquest.getDisplayManager().displayInfoPlayerMenu(player, otherPlayer);
                    return;
                }
                case "kingdom": {
                    if (!konquest.getKingdomManager().isKingdom(infoName)) break;
                    konquest.getDisplayManager().displayInfoKingdomMenu(player, konquest.getKingdomManager().getKingdom(infoName));
                    return;
                }
                case "capital": {
                    for (KonKingdom k : konquest.getKingdomManager().getKingdoms()) {
                        if (!k.hasCapital(infoName)) continue;
                        konquest.getDisplayManager().displayInfoTownMenu(player, k.getCapital());
                        return;
                    }
                    break;
                }
                case "town": {
                    for (KonKingdom k : konquest.getKingdomManager().getKingdoms()) {
                        if (!k.hasTown(infoName)) continue;
                        konquest.getDisplayManager().displayInfoTownMenu(player, k.getTown(infoName));
                        return;
                    }
                    break;
                }
                case "ruin": {
                    if (!konquest.getRuinManager().isRuin(infoName)) break;
                    konquest.getDisplayManager().displayInfoRuinMenu(player, konquest.getRuinManager().getRuin(infoName));
                    return;
                }
                case "sanctuary": {
                    if (!konquest.getSanctuaryManager().isSanctuary(infoName)) break;
                    konquest.getDisplayManager().displayInfoSanctuaryMenu(player, konquest.getSanctuaryManager().getSanctuary(infoName));
                    return;
                }
                case "camp": {
                    if (!konquest.getCampManager().isCampName(infoName)) break;
                    konquest.getDisplayManager().displayInfoCampMenu(player, konquest.getCampManager().getCampByName(infoName));
                    return;
                }
                case "template": {
                    if (!konquest.getSanctuaryManager().isTemplate(infoName)) break;
                    konquest.getDisplayManager().displayInfoTemplateMenu(player, konquest.getSanctuaryManager().getTemplate(infoName));
                    return;
                }
                default: {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
            }
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(infoName));
        } else {
            this.sendInvalidArgMessage(sender);
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("menu");
            tabList.add("player");
            tabList.add("kingdom");
            tabList.add("capital");
            tabList.add("town");
            tabList.add("ruin");
            tabList.add("sanctuary");
            tabList.add("camp");
            tabList.add("template");
        } else if (args.size() == 2) {
            String type;
            switch (type = args.get(0).toLowerCase()) {
                case "player": {
                    for (OfflinePlayer bukkitOfflinePlayer : konquest.getPlayerManager().getAllOfflinePlayers()) {
                        tabList.add(bukkitOfflinePlayer.getName());
                    }
                    break;
                }
                case "kingdom": 
                case "capital": {
                    tabList.addAll(konquest.getKingdomManager().getKingdomNames());
                    break;
                }
                case "town": {
                    for (KonKingdom kingdom : konquest.getKingdomManager().getKingdoms()) {
                        tabList.addAll(kingdom.getTownNames());
                    }
                    break;
                }
                case "ruin": {
                    tabList.addAll(konquest.getRuinManager().getRuinNames());
                    break;
                }
                case "sanctuary": {
                    tabList.addAll(konquest.getSanctuaryManager().getSanctuaryNames());
                    break;
                }
                case "camp": {
                    tabList.addAll(konquest.getCampManager().getCampNames());
                    break;
                }
                case "template": {
                    tabList.addAll(konquest.getSanctuaryManager().getAllTemplateNames());
                    break;
                }
            }
        }
        return this.matchLastArgToList(tabList, args);
    }
}

