/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.api.event.player.KonquestPlayerCreateKingdomEvent;
import com.github.rumsfield.konquest.api.model.KonquestDiplomacyType;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonDirective;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonStatsType;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.ColorRGB;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class KingdomCommand
extends CommandBase {
    public KingdomCommand() {
        super("kingdom", true, false);
        this.setOptionalArgs(true);
        this.addArgument(this.newArg("menu", true, false));
        this.addArgument(this.newArg("create", true, false).sub(this.newArg("template", false, false).sub(this.newArg("name", false, false))));
        this.addArgument(this.newArg("invites", true, false));
        this.addArgument(this.newArg("join", true, false).sub(this.newArg("kingdom", false, false)));
        this.addArgument(this.newArg("exile", true, false));
        this.addArgument(this.newArg("templates", true, false));
        List<String> accessArgNames = Arrays.asList("open", "closed");
        List<String> requestsArgNames = Arrays.asList("accept", "deny");
        List<String> memberArgNames = Arrays.asList("invite", "kick", "promote", "demote", "master");
        this.addArgument(this.newArg("manage", true, false).sub(this.newArg("disband", true, false)).sub(this.newArg("destroy", true, false).sub(this.newArg("town", false, false))).sub(this.newArg("capital", true, false).sub(this.newArg("town", false, false))).sub(this.newArg("rename", true, false).sub(this.newArg("name", false, false))).sub(this.newArg("webcolor", true, true).sub(this.newArg("color", false, false))).sub(this.newArg("template", true, true).sub(this.newArg("name", false, false))).sub(this.newArg("access", true, false).sub(this.newArg(accessArgNames, true, false))).sub(this.newArg("purchase", true, false).sub(this.newArg("town", false, false).sub(this.newArg("amount", false, false)))).sub(this.newArg("diplomacy", true, false).sub(this.newArg("kingdom", false, true).sub(this.newArg("relation", false, false)))).sub(this.newArg("requests", true, true).sub(this.newArg("player", false, false).sub(this.newArg(requestsArgNames, true, false)))).sub(this.newArg("offers", true, true).sub(this.newArg("town", false, true).sub(this.newArg("player", false, false).sub(this.newArg(requestsArgNames, true, false))))).sub(this.newArg("member", true, false).sub(this.newArg(memberArgNames, true, false).sub(this.newArg("player", false, false)))));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        int MAX_LIST_NAMES = 10;
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            ChatUtil.printDebug("Command executed with null player", true);
            ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
            return;
        }
        KonKingdom kingdom = player.getKingdom();
        Player bukkitPlayer = player.getBukkitPlayer();
        UUID playerID = bukkitPlayer.getUniqueId();
        if (args.isEmpty()) {
            konquest.getDisplayManager().displayKingdomMenu(player, kingdom, false);
            return;
        }
        String subCmd = args.get(0);
        block11 : switch (subCmd.toLowerCase()) {
            case "menu": {
                konquest.getDisplayManager().displayKingdomMenu(player, kingdom, false);
                break;
            }
            case "create": {
                if (konquest.getKingdomManager().isKingdomCreateAdminOnly()) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                    return;
                }
                if (!bukkitPlayer.hasPermission("konquest.create.kingdom")) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_PERMISSION.getMessage(new Object[0]) + " konquest.create.kingdom");
                    return;
                }
                if (args.size() == 1) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_ERROR_MISSING_TEMPLATE.getMessage(new Object[0]));
                    return;
                }
                if (konquest.getSanctuaryManager().getNumTemplates() == 0) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_ADMIN_KINGDOM_ERROR_NO_TEMPLATES.getMessage(new Object[0]));
                    return;
                }
                String templateName = args.get(1);
                if (args.size() == 2) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_ERROR_MISSING_NAME.getMessage(new Object[0]));
                    return;
                }
                String newKingdomName = args.get(2);
                if (konquest.validateName(newKingdomName, (CommandSender)bukkitPlayer) != 0) {
                    return;
                }
                if (konquest.getIntegrationManager().getWorldGuard().isEnabled()) {
                    Location settleLoc = bukkitPlayer.getLocation();
                    int radius = konquest.getCore().getInt(CorePath.TOWNS_INIT_RADIUS.getPath());
                    World locWorld = settleLoc.getWorld();
                    for (Point point : HelperUtil.getAreaPoints(settleLoc, radius)) {
                        if (konquest.getIntegrationManager().getWorldGuard().isChunkClaimAllowed(locWorld, point, bukkitPlayer)) continue;
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.REGION_ERROR_CLAIM_DENY.getMessage(new Object[0]));
                        return;
                    }
                }
                KonquestPlayerCreateKingdomEvent invokeEvent = new KonquestPlayerCreateKingdomEvent(konquest, player, bukkitPlayer.getLocation(), newKingdomName);
                Konquest.callKonquestEvent(invokeEvent);
                if (invokeEvent.isCancelled()) {
                    return;
                }
                int createStatus = konquest.getKingdomManager().createKingdom(bukkitPlayer.getLocation(), newKingdomName, templateName, player, false);
                if (createStatus == 0) {
                    KonKingdom createdKingdom = konquest.getKingdomManager().getKingdom(newKingdomName);
                    ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_CREATE.getMessage(bukkitPlayer.getName(), newKingdomName));
                    konquest.getKingdomManager().teleportAwayFromCenter(createdKingdom.getCapital());
                    int starterShieldDuration = konquest.getCore().getInt(CorePath.TOWNS_SHIELD_NEW_TOWNS.getPath(), 0);
                    if (starterShieldDuration > 0) {
                        konquest.getShieldManager().shieldSet(createdKingdom.getCapital(), starterShieldDuration);
                    }
                    Konquest.playTownSettleSound(bukkitPlayer.getLocation());
                    KonKingdom newKingdom = konquest.getKingdomManager().getKingdom(newKingdomName);
                    konquest.getDisplayManager().displayKingdomMenu(player, newKingdom, false);
                    konquest.getKingdomManager().updatePlayerMembershipStats(player);
                    konquest.getDirectiveManager().updateDirectiveProgress(player, KonDirective.CREATE_KINGDOM);
                    konquest.getAccomplishmentManager().modifyPlayerStat(player, KonStatsType.KINGDOMS, 1);
                    break;
                }
                switch (createStatus) {
                    case 1: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_TAKEN_NAME.getMessage(new Object[0]));
                        break;
                    }
                    case 2: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_ERROR_BARBARIAN_CREATE.getMessage(new Object[0]));
                        break;
                    }
                    case 3: {
                        double templateCost = konquest.getSanctuaryManager().getTemplate(templateName).getCost();
                        double totalCost = konquest.getKingdomManager().getCostCreate() + templateCost;
                        String cost = String.format("%.2f", totalCost);
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_FAVOR.getMessage(cost));
                        break;
                    }
                    case 4: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_ERROR_INVALID_TEMPLATE.getMessage(templateName));
                        break;
                    }
                    case 5: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INVALID_WORLD.getMessage(new Object[0]));
                        break;
                    }
                    case 6: {
                        int distance = konquest.getTerritoryManager().getDistanceToClosestTerritory(bukkitPlayer.getLocation());
                        int min_distance_sanc = konquest.getCore().getInt(CorePath.TOWNS_MIN_DISTANCE_SANCTUARY.getPath());
                        int min_distance_town = konquest.getCore().getInt(CorePath.TOWNS_MIN_DISTANCE_TOWN.getPath());
                        int min_distance = Math.min(min_distance_sanc, min_distance_town);
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SETTLE_ERROR_FAIL_PROXIMITY.getMessage(distance, min_distance));
                        break;
                    }
                    case 7: {
                        int distance = konquest.getTerritoryManager().getDistanceToClosestTerritory(bukkitPlayer.getLocation());
                        int max_distance_all = konquest.getCore().getInt(CorePath.TOWNS_MAX_DISTANCE_ALL.getPath());
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SETTLE_ERROR_FAIL_MAX.getMessage(distance, max_distance_all));
                        break;
                    }
                    case 8: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SETTLE_ERROR_FAIL_PLACEMENT.getMessage(new Object[0]));
                        break;
                    }
                    case 12: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SETTLE_ERROR_FAIL_HEIGHT.getMessage(new Object[0]));
                        break;
                    }
                    case 13: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SETTLE_ERROR_FAIL_INIT.getMessage(new Object[0]));
                        break;
                    }
                    case 14: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SETTLE_ERROR_FAIL_AIR.getMessage(new Object[0]));
                        break;
                    }
                    case 15: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SETTLE_ERROR_FAIL_WATER.getMessage(new Object[0]));
                        break;
                    }
                    case 16: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SETTLE_ERROR_FAIL_CONTAINER.getMessage(new Object[0]));
                        break;
                    }
                    case 22: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SETTLE_ERROR_FAIL_FLAT.getMessage(new Object[0]));
                        break;
                    }
                    case 23: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_SETTLE_ERROR_FAIL_HEIGHT.getMessage(new Object[0]));
                        break;
                    }
                    default: {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                    }
                }
                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_SETTLE_NOTICE_MAP_HINT.getMessage(new Object[0]));
                break;
            }
            case "invites": {
                if (args.size() == 1) {
                    String nameListStr = this.formatStringListLimited(konquest.getKingdomManager().getInviteKingdomNames(player), 10);
                    ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_NOTICE_INVITE_LIST.getMessage(new Object[0]));
                    ChatUtil.sendMessage((CommandSender)bukkitPlayer, nameListStr);
                    break;
                }
                this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                break;
            }
            case "join": {
                if (args.size() == 2) {
                    String joinKingdomName = args.get(1);
                    if (!konquest.getKingdomManager().isKingdom(joinKingdomName)) {
                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(joinKingdomName));
                        return;
                    }
                    KonKingdom joinKingdom = konquest.getKingdomManager().getKingdom(joinKingdomName);
                    konquest.getKingdomManager().menuJoinKingdomRequest(player, joinKingdom);
                    break;
                }
                this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                break;
            }
            case "exile": {
                if (args.size() == 1) {
                    konquest.getKingdomManager().menuExileKingdom(player);
                    break;
                }
                this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                break;
            }
            case "templates": {
                if (args.size() == 1) {
                    konquest.getDisplayManager().displayInfoTemplateListMenu(player);
                    break;
                }
                this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                break;
            }
            case "manage": {
                if (player.isBarbarian()) {
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                    return;
                }
                if (args.size() >= 2) {
                    String manageSubCmd = args.get(1);
                    block51 : switch (manageSubCmd.toLowerCase()) {
                        case "disband": {
                            if (!kingdom.isMaster(playerID)) {
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                return;
                            }
                            if (args.size() == 2) {
                                konquest.getKingdomManager().menuDisbandKingdom(kingdom, player);
                                break;
                            }
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            break;
                        }
                        case "destroy": {
                            if (!kingdom.isMaster(playerID)) {
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                return;
                            }
                            if (!konquest.getKingdomManager().getIsTownDestroyMasterEnable()) {
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                                return;
                            }
                            if (args.size() == 3) {
                                String townName = args.get(2);
                                if (!kingdom.hasTown(townName)) {
                                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_BAD_NAME.getMessage(townName));
                                    return;
                                }
                                konquest.getKingdomManager().menuDestroyTown(kingdom.getTown(townName), player);
                                break;
                            }
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            break;
                        }
                        case "capital": {
                            if (!kingdom.isMaster(playerID)) {
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                return;
                            }
                            if (!konquest.getKingdomManager().getIsCapitalSwapEnable()) {
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                                return;
                            }
                            if (args.size() == 3) {
                                String townName = args.get(2);
                                if (!kingdom.hasTown(townName)) {
                                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_BAD_NAME.getMessage(townName));
                                    return;
                                }
                                konquest.getKingdomManager().menuCapitalSwap(kingdom.getTown(townName), player, false);
                                break;
                            }
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            break;
                        }
                        case "rename": {
                            if (!kingdom.isMaster(playerID)) {
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                return;
                            }
                            if (args.size() == 3) {
                                String newName = args.get(2);
                                String oldName = kingdom.getName();
                                if (konquest.validateName(newName, (CommandSender)bukkitPlayer) != 0) {
                                    return;
                                }
                                int status = konquest.getKingdomManager().renameKingdom(oldName, newName, player, false);
                                switch (status) {
                                    case 0: {
                                        ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_NOTICE_RENAME.getMessage(newName));
                                        ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_RENAME.getMessage(oldName, newName));
                                        break block51;
                                    }
                                    case 1: {
                                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(new Object[0]));
                                        break block51;
                                    }
                                    case 2: {
                                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_TAKEN_NAME.getMessage(new Object[0]));
                                        break block51;
                                    }
                                    case 3: {
                                        String cost = String.format("%.2f", konquest.getKingdomManager().getCostRename());
                                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_FAVOR.getMessage(cost));
                                        break block51;
                                    }
                                }
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_FAILED.getMessage(new Object[0]));
                                break;
                            }
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            break;
                        }
                        case "webcolor": {
                            if (konquest.getCore().getBoolean(CorePath.KINGDOMS_WEB_COLOR_ADMIN_ONLY.getPath())) {
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                                return;
                            }
                            if (!kingdom.isMaster(playerID)) {
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                return;
                            }
                            if (args.size() == 2) {
                                int currentWebColor = kingdom.getWebColor();
                                String colorStr = "default";
                                if (currentWebColor != -1) {
                                    colorStr = ChatUtil.reverseLookupColorRGB(currentWebColor);
                                }
                                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_NOTICE_WEB_COLOR_SHOW.getMessage(kingdom.getName(), colorStr));
                                break;
                            }
                            if (args.size() == 3) {
                                String colorStr = args.get(2);
                                if (colorStr.equalsIgnoreCase("default")) {
                                    kingdom.setWebColor(-1);
                                } else {
                                    int newWebColor = ChatUtil.lookupColorRGB(colorStr);
                                    if (newWebColor != -1) {
                                        kingdom.setWebColor(newWebColor);
                                    } else {
                                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_ERROR_WEB_COLOR_INVALID.getMessage(new Object[0]));
                                        return;
                                    }
                                }
                                konquest.getMapHandler().drawUpdateTerritory(kingdom);
                                konquest.getIntegrationManager().getDiscordSrv().changeKingdomRole(kingdom.getName(), kingdom.getName(), kingdom.getWebColorFormal());
                                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_NOTICE_WEB_COLOR_SET.getMessage(kingdom.getName(), colorStr));
                                break;
                            }
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            break;
                        }
                        case "template": {
                            if (args.size() == 2) {
                                ChatUtil.sendNotice(sender, MessagePath.COMMAND_KINGDOM_NOTICE_TEMPLATE_CURRENT.getMessage(kingdom.getMonumentTemplateName()));
                                break;
                            }
                            if (args.size() == 3) {
                                if (!kingdom.isMaster(playerID)) {
                                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                    return;
                                }
                                String newTemplateName = args.get(2);
                                if (!konquest.getSanctuaryManager().isValidTemplate(newTemplateName)) {
                                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_ERROR_INVALID_TEMPLATE.getMessage(newTemplateName));
                                    return;
                                }
                                konquest.getKingdomManager().menuChangeKingdomTemplate(kingdom, konquest.getSanctuaryManager().getTemplate(newTemplateName), player, false);
                                break;
                            }
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            break;
                        }
                        case "access": {
                            if (!kingdom.isMaster(playerID)) {
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                return;
                            }
                            if (args.size() == 3) {
                                String accessType = args.get(2);
                                if (accessType.equalsIgnoreCase("open")) {
                                    kingdom.setIsOpen(true);
                                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_KINGDOM_NOTICE_OPEN.getMessage(new Object[0]));
                                    break;
                                }
                                if (accessType.equalsIgnoreCase("closed")) {
                                    kingdom.setIsOpen(false);
                                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_KINGDOM_NOTICE_CLOSED.getMessage(new Object[0]));
                                    break;
                                }
                                this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                                break;
                            }
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            break;
                        }
                        case "purchase": {
                            if (!kingdom.isOfficer(playerID)) {
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                return;
                            }
                            if (!konquest.getKingdomManager().getIsTownPurchaseEnable()) {
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                                return;
                            }
                            if (args.size() == 4) {
                                int amount;
                                String offerTownName = args.get(2);
                                String offerAmount = args.get(3);
                                if (!konquest.getKingdomManager().isTown(offerTownName)) {
                                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(offerTownName));
                                    return;
                                }
                                KonTown town = konquest.getKingdomManager().getTown(offerTownName);
                                try {
                                    amount = Integer.parseInt(offerAmount);
                                }
                                catch (NumberFormatException e) {
                                    this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                                    return;
                                }
                                konquest.getKingdomManager().applyTownPurchaseOffer(town, player, amount);
                                break;
                            }
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            break;
                        }
                        case "diplomacy": {
                            if (args.size() >= 3) {
                                String otherKingdomName = args.get(2);
                                if (!konquest.getKingdomManager().isKingdom(otherKingdomName)) {
                                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(otherKingdomName));
                                    return;
                                }
                                KonKingdom otherKingdom = konquest.getKingdomManager().getKingdom(otherKingdomName);
                                if (args.size() == 3) {
                                    ChatUtil.sendNotice(sender, MessagePath.COMMAND_KINGDOM_NOTICE_DIPLOMACY_CURRENT.getMessage(otherKingdom.getName(), kingdom.getActiveRelation(otherKingdom).toString()));
                                    break;
                                }
                                if (args.size() == 4) {
                                    KonquestDiplomacyType relation;
                                    if (!kingdom.isOfficer(playerID)) {
                                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                        return;
                                    }
                                    if (kingdom.isPeaceful() || otherKingdom.isPeaceful()) {
                                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_ERROR_DIPLOMACY_PEACEFUL.getMessage(new Object[0]));
                                        return;
                                    }
                                    String relationName = args.get(3);
                                    try {
                                        relation = KonquestDiplomacyType.valueOf(relationName.toUpperCase());
                                    }
                                    catch (IllegalArgumentException ex) {
                                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(relationName));
                                        return;
                                    }
                                    konquest.getKingdomManager().menuChangeKingdomRelation(kingdom, otherKingdom, relation, player, false);
                                    break;
                                }
                                this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                                break;
                            }
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            break;
                        }
                        case "requests": {
                            if (!kingdom.isOfficer(playerID)) {
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                return;
                            }
                            if (args.size() == 2) {
                                ArrayList<String> requestPlayerNames = new ArrayList<String>();
                                for (OfflinePlayer requester : kingdom.getJoinRequests()) {
                                    requestPlayerNames.add(requester.getName());
                                }
                                String nameListStr = this.formatStringListLimited(requestPlayerNames, 10);
                                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_NOTICE_REQUEST_LIST.getMessage(new Object[0]));
                                ChatUtil.sendMessage((CommandSender)bukkitPlayer, nameListStr);
                                break;
                            }
                            if (args.size() == 4) {
                                boolean response;
                                String requesterName = args.get(2);
                                String requestDecision = args.get(3);
                                KonOfflinePlayer requester = konquest.getPlayerManager().getOfflinePlayerFromName(requesterName);
                                if (requester == null) {
                                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(requesterName));
                                    return;
                                }
                                if (requestDecision.equalsIgnoreCase("accept")) {
                                    response = true;
                                } else if (requestDecision.equalsIgnoreCase("deny")) {
                                    response = false;
                                } else {
                                    this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                                    return;
                                }
                                konquest.getKingdomManager().menuRespondKingdomRequest(player, requester, kingdom, response);
                                break;
                            }
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            break;
                        }
                        case "offers": {
                            if (!kingdom.isOfficer(playerID)) {
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                return;
                            }
                            if (!konquest.getKingdomManager().getIsTownPurchaseEnable()) {
                                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_DISABLED.getMessage(new Object[0]));
                                return;
                            }
                            if (args.size() == 2) {
                                ArrayList<String> offerTownNames = new ArrayList<String>();
                                for (KonTown town : konquest.getKingdomManager().getActiveTownPurchaseOffers(kingdom)) {
                                    int numOffers = town.getNumPurchaseOffers();
                                    offerTownNames.add(town.getName() + " (" + numOffers + ")");
                                }
                                String nameListStr = this.formatStringListLimited(offerTownNames, 10);
                                ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_NOTICE_OFFER_TOWNS.getMessage(new Object[0]));
                                ChatUtil.sendMessage((CommandSender)bukkitPlayer, nameListStr);
                                break;
                            }
                            if (args.size() >= 3) {
                                String offerTownName = args.get(2);
                                if (!konquest.getKingdomManager().isTown(offerTownName)) {
                                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(offerTownName));
                                    return;
                                }
                                KonTown offerTown = konquest.getKingdomManager().getTown(offerTownName);
                                konquest.getKingdomManager().refreshPurchaseOffers(offerTown);
                                if (args.size() == 3) {
                                    ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_NOTICE_OFFER_PLAYERS.getMessage(offerTown.getName()));
                                    for (UUID id : offerTown.getPurchaseOffers()) {
                                        KonOfflinePlayer offerPlayer = konquest.getPlayerManager().getOfflinePlayerFromID(id);
                                        double offerAmount = offerTown.getPurchaseOfferAmount(id);
                                        String offerLine = String.valueOf(ChatColor.AQUA) + offerPlayer.getOfflineBukkitPlayer().getName() + " (" + offerPlayer.getKingdom().getName() + ") - " + KonquestPlugin.getCurrencyFormat(offerAmount);
                                        ChatUtil.sendMessage((CommandSender)bukkitPlayer, offerLine);
                                    }
                                    break block11;
                                }
                                if (args.size() == 5) {
                                    boolean response;
                                    String offerPlayerName = args.get(3);
                                    String offerDecision = args.get(4);
                                    KonOfflinePlayer offerPlayer = konquest.getPlayerManager().getOfflinePlayerFromName(offerPlayerName);
                                    if (offerPlayer == null) {
                                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(offerPlayerName));
                                        return;
                                    }
                                    UUID offerID = offerPlayer.getOfflineBukkitPlayer().getUniqueId();
                                    double offerAmount = offerTown.getPurchaseOfferAmount(offerID);
                                    if (offerAmount < 0.0) {
                                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_INVALID_PLAYER.getMessage(new Object[0]));
                                        return;
                                    }
                                    if (offerDecision.equalsIgnoreCase("accept")) {
                                        response = true;
                                    } else if (offerDecision.equalsIgnoreCase("deny")) {
                                        response = false;
                                    } else {
                                        this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                                        return;
                                    }
                                    konquest.getKingdomManager().respondTownPurchaseOffer(offerTown, player, offerID, response);
                                    break;
                                }
                                this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                                break;
                            }
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            break;
                        }
                        case "member": {
                            if (args.size() == 4) {
                                String memberSubCmd = args.get(2);
                                String playerName = args.get(3);
                                KonOfflinePlayer offlinePlayer = konquest.getPlayerManager().getOfflinePlayerFromName(playerName);
                                if (offlinePlayer == null) {
                                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_UNKNOWN_NAME.getMessage(playerName));
                                    return;
                                }
                                playerName = offlinePlayer.getOfflineBukkitPlayer().getName();
                                switch (memberSubCmd.toLowerCase()) {
                                    case "invite": {
                                        if (!kingdom.isOfficer(playerID)) {
                                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                            return;
                                        }
                                        if (!konquest.getKingdomManager().joinKingdomInvite(player, offlinePlayer, kingdom)) break block11;
                                        ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_NOTICE_INVITE_SENT.getMessage(playerName));
                                        break block51;
                                    }
                                    case "kick": {
                                        if (!kingdom.isOfficer(playerID)) {
                                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                            return;
                                        }
                                        OfflinePlayer bukkitOfflinePlayer = offlinePlayer.getOfflineBukkitPlayer();
                                        if (kingdom.isMaster(bukkitOfflinePlayer.getUniqueId())) {
                                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_ERROR_KICK_MASTER.getMessage(new Object[0]));
                                            return;
                                        }
                                        if (offlinePlayer.getOfflineBukkitPlayer().getUniqueId().equals(playerID)) {
                                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                            return;
                                        }
                                        if (!konquest.getKingdomManager().kickKingdomMember(player, bukkitOfflinePlayer)) break block11;
                                        ChatUtil.sendNotice((CommandSender)bukkitPlayer, MessagePath.COMMAND_KINGDOM_NOTICE_KICK.getMessage(playerName));
                                        break block51;
                                    }
                                    case "promote": {
                                        if (!kingdom.isMaster(playerID)) {
                                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                            return;
                                        }
                                        if (konquest.getKingdomManager().menuPromoteOfficer(offlinePlayer.getOfflineBukkitPlayer(), kingdom)) break block11;
                                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                        return;
                                    }
                                    case "demote": {
                                        if (!kingdom.isMaster(playerID)) {
                                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                            return;
                                        }
                                        if (konquest.getKingdomManager().menuDemoteOfficer(offlinePlayer.getOfflineBukkitPlayer(), kingdom)) break block11;
                                        ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                        return;
                                    }
                                    case "master": {
                                        if (!kingdom.isMaster(playerID)) {
                                            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.GENERIC_ERROR_NO_ALLOW.getMessage(new Object[0]));
                                            return;
                                        }
                                        konquest.getKingdomManager().menuTransferMaster(offlinePlayer.getOfflineBukkitPlayer(), kingdom, player);
                                        break block51;
                                    }
                                    default: {
                                        this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                                        return;
                                    }
                                }
                            }
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            break;
                        }
                        default: {
                            this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                            break;
                        }
                    }
                    break;
                }
                this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
                break;
            }
            default: {
                this.sendInvalidArgMessage((CommandSender)bukkitPlayer);
            }
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList;
        block96: {
            int numArgs;
            block99: {
                KonKingdom kingdom;
                block98: {
                    KonPlayer player;
                    block97: {
                        block95: {
                            player = konquest.getPlayerManager().getPlayer(sender);
                            if (player == null) {
                                return Collections.emptyList();
                            }
                            kingdom = player.getKingdom();
                            if (kingdom == null) {
                                return Collections.emptyList();
                            }
                            tabList = new ArrayList<String>();
                            numArgs = args.size();
                            if (numArgs != 1) break block95;
                            tabList.add("menu");
                            tabList.add("create");
                            tabList.add("invites");
                            tabList.add("join");
                            tabList.add("exile");
                            tabList.add("templates");
                            tabList.add("manage");
                            break block96;
                        }
                        if (numArgs != 2) break block97;
                        switch (args.get(0).toLowerCase()) {
                            case "create": {
                                tabList.addAll(konquest.getSanctuaryManager().getAllValidTemplateNames());
                                break;
                            }
                            case "join": {
                                ArrayList<String> kingdomList = new ArrayList<String>(konquest.getKingdomManager().getKingdomNames());
                                kingdomList.remove(player.getKingdom().getName());
                                tabList.addAll(kingdomList);
                                break;
                            }
                            case "manage": {
                                tabList.add("disband");
                                tabList.add("rename");
                                tabList.add("template");
                                tabList.add("access");
                                tabList.add("diplomacy");
                                tabList.add("requests");
                                tabList.add("member");
                                if (!konquest.getCore().getBoolean(CorePath.KINGDOMS_WEB_COLOR_ADMIN_ONLY.getPath())) {
                                    tabList.add("webcolor");
                                }
                                if (konquest.getKingdomManager().getIsTownDestroyMasterEnable()) {
                                    tabList.add("destroy");
                                }
                                if (konquest.getKingdomManager().getIsCapitalSwapEnable()) {
                                    tabList.add("capital");
                                }
                                if (!konquest.getKingdomManager().getIsTownPurchaseEnable()) break;
                                tabList.add("purchase");
                                tabList.add("offers");
                            }
                        }
                        break block96;
                    }
                    if (numArgs != 3) break block98;
                    block14 : switch (args.get(0).toLowerCase()) {
                        case "create": {
                            tabList.add("***");
                            break;
                        }
                        case "manage": {
                            switch (args.get(1).toLowerCase()) {
                                case "rename": {
                                    tabList.add("***");
                                    break block14;
                                }
                                case "destroy": {
                                    if (konquest.getKingdomManager().getIsTownDestroyMasterEnable()) {
                                        tabList.addAll(kingdom.getTownNames());
                                        break block14;
                                    }
                                    break block96;
                                }
                                case "capital": {
                                    if (konquest.getKingdomManager().getIsCapitalSwapEnable()) {
                                        tabList.addAll(kingdom.getTownNames());
                                        break block14;
                                    }
                                    break block96;
                                }
                                case "webcolor": {
                                    if (!konquest.getCore().getBoolean(CorePath.KINGDOMS_WEB_COLOR_ADMIN_ONLY.getPath())) {
                                        for (ColorRGB color : ColorRGB.values()) {
                                            tabList.add(color.getName());
                                        }
                                        tabList.add("#rrggbb");
                                        tabList.add("default");
                                        break block14;
                                    }
                                    break block96;
                                }
                                case "template": {
                                    tabList.addAll(konquest.getSanctuaryManager().getAllTemplateNames());
                                    tabList.remove(kingdom.getMonumentTemplateName());
                                    break block14;
                                }
                                case "access": {
                                    tabList.add("open");
                                    tabList.add("closed");
                                    break block14;
                                }
                                case "purchase": {
                                    if (konquest.getKingdomManager().getIsTownPurchaseEnable()) {
                                        for (KonKingdom otherKingdom : konquest.getKingdomManager().getKingdoms()) {
                                            if (otherKingdom.equals(kingdom)) continue;
                                            tabList.addAll(otherKingdom.getTownNames());
                                        }
                                    }
                                    break block96;
                                }
                                case "diplomacy": {
                                    ArrayList<String> kingdomList = new ArrayList<String>(konquest.getKingdomManager().getKingdomNames());
                                    kingdomList.remove(player.getKingdom().getName());
                                    tabList.addAll(kingdomList);
                                    break block14;
                                }
                                case "requests": {
                                    for (OfflinePlayer requester : kingdom.getJoinRequests()) {
                                        tabList.add(requester.getName());
                                    }
                                    break block96;
                                }
                                case "offers": {
                                    if (konquest.getKingdomManager().getIsTownPurchaseEnable()) {
                                        for (KonTown offerTown : konquest.getKingdomManager().getActiveTownPurchaseOffers(kingdom)) {
                                            tabList.add(offerTown.getName());
                                        }
                                    }
                                    break block96;
                                }
                                case "member": {
                                    tabList.add("invite");
                                    tabList.add("kick");
                                    tabList.add("promote");
                                    tabList.add("demote");
                                    tabList.add("master");
                                }
                            }
                        }
                    }
                    break block96;
                }
                if (numArgs != 4) break block99;
                if (!args.get(0).equalsIgnoreCase("manage")) break block96;
                switch (args.get(1).toLowerCase()) {
                    case "purchase": {
                        if (!konquest.getKingdomManager().getIsTownPurchaseEnable()) break;
                        tabList.add("#");
                        break;
                    }
                    case "diplomacy": {
                        String otherKingdomName = args.get(2);
                        if (!konquest.getKingdomManager().isKingdom(otherKingdomName)) break;
                        for (KonquestDiplomacyType relation : KonquestDiplomacyType.values()) {
                            if (!konquest.getKingdomManager().isValidRelationChoice(kingdom, konquest.getKingdomManager().getKingdom(otherKingdomName), relation)) continue;
                            tabList.add(relation.toString());
                        }
                        break block96;
                    }
                    case "requests": {
                        tabList.add("accept");
                        tabList.add("deny");
                        break;
                    }
                    case "offers": {
                        if (!konquest.getKingdomManager().getIsTownPurchaseEnable()) break;
                        String townName = args.get(2);
                        if (konquest.getKingdomManager().isTown(townName)) {
                            for (OfflinePlayer offerPlayer : konquest.getKingdomManager().getPlayerTownPurchaseOffers(konquest.getKingdomManager().getTown(townName))) {
                                tabList.add(offerPlayer.getName());
                            }
                        }
                        break block96;
                    }
                    case "member": {
                        switch (args.get(2).toLowerCase()) {
                            case "invite": {
                                for (KonOfflinePlayer offlinePlayer : konquest.getPlayerManager().getAllKonquestOfflinePlayers()) {
                                    String name = offlinePlayer.getOfflineBukkitPlayer().getName();
                                    if (name == null || kingdom.isMember(offlinePlayer.getOfflineBukkitPlayer().getUniqueId())) continue;
                                    tabList.add(name);
                                }
                                break block96;
                            }
                            case "kick": {
                                for (KonOfflinePlayer offlinePlayer : konquest.getPlayerManager().getAllKonquestOfflinePlayers()) {
                                    String name = offlinePlayer.getOfflineBukkitPlayer().getName();
                                    if (name == null || !kingdom.isMember(offlinePlayer.getOfflineBukkitPlayer().getUniqueId())) continue;
                                    tabList.add(name);
                                }
                                break block96;
                            }
                            case "promote": {
                                for (OfflinePlayer offlinePlayer : kingdom.getPlayerMembersOnly()) {
                                    String name = offlinePlayer.getName();
                                    if (name == null) continue;
                                    tabList.add(name);
                                }
                                break block96;
                            }
                            case "demote": {
                                for (OfflinePlayer offlinePlayer : kingdom.getPlayerOfficersOnly()) {
                                    String name = offlinePlayer.getName();
                                    if (name == null) continue;
                                    tabList.add(name);
                                }
                                break block96;
                            }
                            case "master": {
                                for (OfflinePlayer offlinePlayer : kingdom.getPlayerMembers()) {
                                    String name = offlinePlayer.getName();
                                    if (name == null || kingdom.isMaster(offlinePlayer.getUniqueId())) continue;
                                    tabList.add(name);
                                }
                            }
                        }
                    }
                }
                break block96;
            }
            if (numArgs == 5 && args.get(0).equalsIgnoreCase("manage") && args.get(1).equalsIgnoreCase("offers") && konquest.getKingdomManager().getIsTownPurchaseEnable()) {
                tabList.add("accept");
                tabList.add("deny");
            }
        }
        return this.matchLastArgToList(tabList, args);
    }
}

