/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class ListCommand
extends CommandBase {
    public ListCommand() {
        super("list", false, false);
        this.setOptionalArgs(true);
        List<String> argNames = Arrays.asList("kingdom", "town", "camp", "ruin", "sanctuary", "template");
        this.addArgument(this.newArg(argNames, true, true).sub(this.newArg("page", false, false)));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        if (args.size() > 2) {
            ChatUtil.printDebug("List arg size is " + args.size());
            this.sendInvalidArgMessage(sender);
            return;
        }
        ListType mode = ListType.KINGDOM;
        if (args.size() >= 1) {
            switch (args.get(0).toLowerCase()) {
                case "kingdom": {
                    mode = ListType.KINGDOM;
                    break;
                }
                case "town": {
                    mode = ListType.TOWN;
                    break;
                }
                case "camp": {
                    mode = ListType.CAMP;
                    break;
                }
                case "sanctuary": {
                    mode = ListType.SANCTUARY;
                    break;
                }
                case "ruin": {
                    mode = ListType.RUIN;
                    break;
                }
                case "template": {
                    mode = ListType.TEMPLATE;
                    break;
                }
                default: {
                    this.sendInvalidArgMessage(sender);
                    return;
                }
            }
        }
        ArrayList<String> lines = new ArrayList<String>();
        switch (mode.ordinal()) {
            case 0: {
                lines.addAll(konquest.getKingdomManager().getKingdomNames());
                break;
            }
            case 1: {
                lines.addAll(konquest.getKingdomManager().getTownNames());
                break;
            }
            case 2: {
                lines.addAll(konquest.getCampManager().getCampNames());
                break;
            }
            case 3: {
                lines.addAll(konquest.getRuinManager().getRuinNames());
                break;
            }
            case 4: {
                lines.addAll(konquest.getSanctuaryManager().getSanctuaryNames());
                break;
            }
            case 5: {
                lines.addAll(konquest.getSanctuaryManager().getAllTemplateNames());
                break;
            }
            default: {
                ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL.getMessage(new Object[0]));
                return;
            }
        }
        Collections.sort(lines);
        if (lines.isEmpty()) {
            String header = MessagePath.COMMAND_LIST_NOTICE_HEADER.getMessage(mode.getLabel()) + " 0/0";
            ChatUtil.sendNotice(sender, header);
        } else {
            int numLines = lines.size();
            int MAX_LINES = 8;
            int totalPages = (int)Math.ceil((double)numLines / (double)MAX_LINES);
            totalPages = Math.max(totalPages, 1);
            int page = 1;
            if (args.size() == 2) {
                try {
                    page = Integer.parseInt(args.get(1));
                }
                catch (NumberFormatException ex) {
                    ChatUtil.sendError(sender, MessagePath.GENERIC_ERROR_INTERNAL_MESSAGE.getMessage(ex.getMessage()));
                    return;
                }
            }
            page = Math.min(page, totalPages);
            page = Math.max(page, 1);
            int startIdx = (page - 1) * MAX_LINES;
            int endIdx = startIdx + MAX_LINES;
            String header = MessagePath.COMMAND_LIST_NOTICE_HEADER.getMessage(mode.getLabel()) + " " + page + "/" + totalPages;
            ChatUtil.sendNotice(sender, header);
            ArrayList<String> pageLines = new ArrayList<String>();
            for (int i = startIdx; i < endIdx && i < numLines; ++i) {
                String line = String.valueOf(ChatColor.GOLD) + (i + 1) + ". " + String.valueOf(ChatColor.AQUA) + (String)lines.get(i);
                pageLines.add(line);
            }
            ChatUtil.sendCommaMessage(sender, pageLines);
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("kingdom");
            tabList.add("town");
            tabList.add("camp");
            tabList.add("ruin");
            tabList.add("sanctuary");
            tabList.add("template");
        } else if (args.size() == 2) {
            tabList.add("#");
        }
        return this.matchLastArgToList(tabList, args);
    }

    public static enum ListType {
        KINGDOM(MessagePath.LABEL_KINGDOM.getMessage(new Object[0])),
        TOWN(MessagePath.TERRITORY_TOWN.getMessage(new Object[0])),
        CAMP(MessagePath.TERRITORY_CAMP.getMessage(new Object[0])),
        RUIN(MessagePath.TERRITORY_RUIN.getMessage(new Object[0])),
        SANCTUARY(MessagePath.TERRITORY_SANCTUARY.getMessage(new Object[0])),
        TEMPLATE(MessagePath.LABEL_MONUMENT_TEMPLATE.getMessage(new Object[0]));

        private final String label;

        private ListType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

