/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.command;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.command.CommandBase;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class MapCommand
extends CommandBase {
    public MapCommand() {
        super("map", true, false);
        this.setOptionalArgs(true);
        List<String> argNames = Arrays.asList("far", "auto");
        this.addArgument(this.newArg(argNames, true, false));
    }

    @Override
    public void execute(Konquest konquest, CommandSender sender, List<String> args) {
        KonPlayer player = konquest.getPlayerManager().getPlayer(sender);
        if (player == null) {
            this.sendInvalidSenderMessage(sender);
            return;
        }
        if (args.isEmpty()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)konquest.getPlugin(), () -> konquest.getTerritoryManager().printPlayerMap(player, 9));
        } else if (args.size() == 1) {
            String subCmd = args.get(0);
            if (subCmd.equalsIgnoreCase("far") || subCmd.equalsIgnoreCase("f")) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)konquest.getPlugin(), () -> konquest.getTerritoryManager().printPlayerMap(player, 19));
            } else if (subCmd.equalsIgnoreCase("auto") || subCmd.equalsIgnoreCase("a")) {
                if (player.isMapAuto()) {
                    player.setIsMapAuto(false);
                    ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_DISABLE_AUTO.getMessage(new Object[0]));
                } else {
                    player.setIsMapAuto(true);
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)konquest.getPlugin(), () -> {
                        konquest.getTerritoryManager().printPlayerMap(player, 9);
                        ChatUtil.sendNotice(sender, MessagePath.GENERIC_NOTICE_ENABLE_AUTO.getMessage(new Object[0]));
                    });
                }
            } else {
                this.sendInvalidArgMessage(sender);
            }
        } else {
            this.sendInvalidArgMessage(sender);
        }
    }

    @Override
    public List<String> tabComplete(Konquest konquest, CommandSender sender, List<String> args) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.size() == 1) {
            tabList.add("far");
            tabList.add("auto");
        }
        return this.matchLastArgToList(tabList, args);
    }
}

